/*
 * Decompiled with CFR 0.152.
 */
package netwatcher.ssh2.preference;

import com.jcraft.jsch.HostKey;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.KeyPair;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import netwatcher.ssh2.model.JSchControl;
import netwatcher.ssh2.preference.ExportDialog;
import netwatcher.ssh2.preference.SSH2PassphrasePrompt;
import netwatcher.ssh2.preference.SSH2UserAuthManagerOutputControl;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class SSH2PreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static String DSA = "DSA";
    private static String RSA = "RSA";
    private Label targetLabel;
    private Label userNameLabel;
    private Label hostLabel;
    private Label passwordLabel;
    private Label passphraseLabel;
    private Text targetText;
    private Text userNameText;
    private Text hostText;
    private Text passwordText;
    private Text passphraseText;
    private Button userAuthSaveButton;
    private Button keyGenerateDSA;
    private Button keyGenerateRSA;
    private Button keyLoad;
    private Button saveKeyPair;
    private Label keyCommentLabel;
    private Text keyCommentText;
    private Label keyFingerPrintLabel;
    private Text keyFingerPrintText;
    private Label keyPassphrase1Label;
    private Text keyPassphrase1Text;
    private Label keyPassphrase2Label;
    private Text keyPassphrase2Text;
    private Label publicKeylabel;
    private Text publicKeyText;
    private KeyPair kpair = null;
    private String kpairComment;
    private TableViewer viewer;
    private Button removeHostKeyButton;
    private JSch jsch = JSchControl.getInstance().getJsch();

    public SSH2PreferencePage() {
        this.setDescription("Configuration options for SSH2:");
    }

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        TabFolder tabFolder = new TabFolder(container, 0);
        tabFolder.setLayoutData((Object)new GridData(1808));
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText("&Key Management");
        tabItem.setControl(this.createKeyManagementPage((Composite)tabFolder));
        tabItem = new TabItem(tabFolder, 0);
        tabItem.setText("Kno&wnHosts");
        tabItem.setControl(this.createHostKeyManagementPage((Composite)tabFolder));
        tabItem = new TabItem(tabFolder, 0);
        tabItem.setText("&User Auth");
        tabItem.setControl(this.createUserAuthManagementPage((Composite)tabFolder));
        this.initControls();
        Dialog.applyDialogFont((Control)parent);
        return container;
    }

    private Control createUserAuthManagementPage(Composite parent) {
        Composite group = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        group.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        group.setLayoutData((Object)gd);
        this.userNameLabel = new Label(group, 0);
        this.userNameLabel.setText("user");
        gd = new GridData();
        gd.horizontalSpan = 1;
        this.userNameLabel.setLayoutData((Object)gd);
        this.userNameText = new Text(group, 2052);
        this.userNameText.setText("");
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.userNameText.setLayoutData((Object)gd);
        this.hostLabel = new Label(group, 0);
        this.hostLabel.setText("host");
        gd = new GridData();
        gd.horizontalSpan = 1;
        this.hostLabel.setLayoutData((Object)gd);
        this.hostText = new Text(group, 2052);
        this.hostText.setText("");
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.hostText.setLayoutData((Object)gd);
        this.targetLabel = new Label(group, 0);
        this.targetLabel.setText("user@host");
        gd = new GridData();
        gd.horizontalSpan = 1;
        this.targetLabel.setLayoutData((Object)gd);
        this.targetText = new Text(group, 2052);
        this.targetText.setText("");
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.targetText.setLayoutData((Object)gd);
        this.targetText.setText("@");
        this.targetText.setEnabled(false);
        this.passwordLabel = new Label(group, 0);
        this.passwordLabel.setText("password");
        gd = new GridData();
        gd.horizontalSpan = 1;
        this.passwordLabel.setLayoutData((Object)gd);
        this.passwordText = new Text(group, 2052);
        this.passwordText.setText("");
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.passwordText.setLayoutData((Object)gd);
        this.passphraseLabel = new Label(group, 0);
        this.passphraseLabel.setText("passphrase");
        gd = new GridData();
        gd.horizontalSpan = 1;
        this.passphraseLabel.setLayoutData((Object)gd);
        this.passphraseText = new Text(group, 2052);
        this.passphraseText.setText("");
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.passphraseText.setLayoutData((Object)gd);
        this.userAuthSaveButton = new Button(group, 0);
        this.userAuthSaveButton.setText("Save");
        gd = new GridData(256);
        gd.horizontalSpan = 1;
        this.userAuthSaveButton.setLayoutData((Object)gd);
        this.userAuthSaveButton.setEnabled(false);
        this.userNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String user = SSH2PreferencePage.this.userNameText.getText();
                String host = SSH2PreferencePage.this.hostText.getText();
                SSH2PreferencePage.this.targetText.setText(String.valueOf(user) + "@" + host);
                SSH2PreferencePage.this.userAuthSaveButton.setEnabled(true);
            }
        });
        this.hostText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String user = SSH2PreferencePage.this.userNameText.getText();
                String host = SSH2PreferencePage.this.hostText.getText();
                SSH2PreferencePage.this.targetText.setText(String.valueOf(user) + "@" + host);
            }
        });
        this.userAuthSaveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String target = SSH2PreferencePage.this.targetText.getText();
                String password = SSH2PreferencePage.this.passwordText.getText();
                String passphrase = SSH2PreferencePage.this.passphraseText.getText();
                String home = "resources/ssh2//" + target;
                File _home = new File(home);
                if (!_home.exists()) {
                    if (!MessageDialog.openConfirm((Shell)SSH2PreferencePage.this.getShell(), (String)"Confirmation", (String)" does not exsit.\nAre you sure you want to create it?")) {
                        return;
                    }
                    if (!_home.mkdirs()) {
                        SSH2PreferencePage.this.setErrorMessage("Failed to create " + home);
                        return;
                    }
                }
                String filePath = String.valueOf(home) + "/" + "user_host_auth.xml";
                SSH2UserAuthManagerOutputControl.getInstance().saveResourceXMLInfo(filePath, target, password, passphrase);
            }
        });
        return group;
    }

    private Control createKeyManagementPage(Composite parent) {
        int columnSpan = 3;
        Composite group = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        group.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        group.setLayoutData((Object)gd);
        this.keyGenerateDSA = new Button(group, 0);
        this.keyGenerateDSA.setText("G&enerate DSA key...");
        gd = new GridData();
        gd.horizontalSpan = 1;
        this.keyGenerateDSA.setLayoutData((Object)gd);
        this.keyGenerateRSA = new Button(group, 0);
        this.keyGenerateRSA.setText("Ge&nerate RSA key...");
        gd = new GridData();
        gd.horizontalSpan = 1;
        this.keyGenerateRSA.setLayoutData((Object)gd);
        this.keyLoad = new Button(group, 0);
        this.keyLoad.setText("&Load existing key...");
        gd = new GridData();
        gd.horizontalSpan = 1;
        this.keyLoad.setLayoutData((Object)gd);
        this.publicKeylabel = new Label(group, 0);
        this.publicKeylabel.setText("&You can paste this public key into the remote authorized_keys file:");
        gd = new GridData();
        gd.horizontalSpan = columnSpan;
        this.publicKeylabel.setLayoutData((Object)gd);
        this.publicKeyText = new Text(group, 2626);
        this.publicKeyText.setText("");
        this.publicKeyText.setEditable(false);
        gd = new GridData();
        gd.horizontalSpan = columnSpan;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        this.publicKeyText.setLayoutData((Object)gd);
        this.keyFingerPrintLabel = new Label(group, 0);
        this.keyFingerPrintLabel.setText("&Fingerprint:");
        this.keyFingerPrintText = new Text(group, 2052);
        this.keyFingerPrintText.setFont(group.getFont());
        this.keyFingerPrintText.setEditable(false);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.keyFingerPrintText.setLayoutData((Object)gd);
        this.keyCommentLabel = new Label(group, 0);
        this.keyCommentLabel.setText("&Comment:");
        this.keyCommentText = new Text(group, 2052);
        this.keyCommentText.setFont(group.getFont());
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.keyCommentText.setLayoutData((Object)gd);
        this.keyCommentText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (SSH2PreferencePage.this.kpair == null) {
                    return;
                }
                try {
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    SSH2PreferencePage.this.kpair.writePublicKey((OutputStream)out, SSH2PreferencePage.this.keyCommentText.getText());
                    out.close();
                    SSH2PreferencePage.this.publicKeyText.setText(out.toString());
                }
                catch (IOException iOException) {}
            }
        });
        this.keyPassphrase1Label = new Label(group, 0);
        this.keyPassphrase1Label.setText("Passp&hrase:");
        this.keyPassphrase1Text = new Text(group, 2052);
        this.keyPassphrase1Text.setFont(group.getFont());
        this.keyPassphrase1Text.setEchoChar('*');
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.keyPassphrase1Text.setLayoutData((Object)gd);
        this.keyPassphrase2Label = new Label(group, 0);
        this.keyPassphrase2Label.setText("C&onfirm passphrase:");
        this.keyPassphrase2Text = new Text(group, 2052);
        this.keyPassphrase2Text.setFont(group.getFont());
        this.keyPassphrase2Text.setEchoChar('*');
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.keyPassphrase2Text.setLayoutData((Object)gd);
        this.keyPassphrase1Text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String pass1 = SSH2PreferencePage.this.keyPassphrase1Text.getText();
                String pass2 = SSH2PreferencePage.this.keyPassphrase2Text.getText();
                if (SSH2PreferencePage.this.kpair != null && pass1.equals(pass2)) {
                    SSH2PreferencePage.this.saveKeyPair.setEnabled(true);
                } else {
                    SSH2PreferencePage.this.saveKeyPair.setEnabled(false);
                }
                if (pass2.length() == 0) {
                    SSH2PreferencePage.this.setErrorMessage(null);
                    return;
                }
                if (pass1.equals(pass2)) {
                    SSH2PreferencePage.this.setErrorMessage(null);
                } else {
                    SSH2PreferencePage.this.setErrorMessage("The passphrases entered do not match.");
                }
            }
        });
        this.keyPassphrase2Text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String pass1 = SSH2PreferencePage.this.keyPassphrase1Text.getText();
                String pass2 = SSH2PreferencePage.this.keyPassphrase2Text.getText();
                if (SSH2PreferencePage.this.kpair != null && pass1.equals(pass2)) {
                    SSH2PreferencePage.this.saveKeyPair.setEnabled(true);
                } else {
                    SSH2PreferencePage.this.saveKeyPair.setEnabled(false);
                }
                if (pass2.length() < pass1.length()) {
                    if (pass1.startsWith(pass2)) {
                        SSH2PreferencePage.this.setErrorMessage(null);
                    } else {
                        SSH2PreferencePage.this.setErrorMessage("The passphrases entered do not match.");
                    }
                    return;
                }
                if (pass1.equals(pass2)) {
                    SSH2PreferencePage.this.setErrorMessage(null);
                } else {
                    SSH2PreferencePage.this.setErrorMessage("The passphrases entered do not match.");
                }
            }
        });
        this.keyPassphrase2Text.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                String pass1 = SSH2PreferencePage.this.keyPassphrase1Text.getText();
                String pass2 = SSH2PreferencePage.this.keyPassphrase2Text.getText();
                if (pass2.length() < pass1.length()) {
                    if (pass1.startsWith(pass2)) {
                        SSH2PreferencePage.this.setErrorMessage(null);
                    } else {
                        SSH2PreferencePage.this.setErrorMessage("The passphrases entered do not match.");
                    }
                    return;
                }
                if (pass1.equals(pass2)) {
                    SSH2PreferencePage.this.setErrorMessage(null);
                } else {
                    SSH2PreferencePage.this.setErrorMessage("The passphrases entered do not match.");
                }
            }

            public void focusLost(FocusEvent e) {
                String pass2;
                String pass1 = SSH2PreferencePage.this.keyPassphrase1Text.getText();
                if (pass1.equals(pass2 = SSH2PreferencePage.this.keyPassphrase2Text.getText())) {
                    SSH2PreferencePage.this.setErrorMessage(null);
                } else {
                    SSH2PreferencePage.this.setErrorMessage("The passphrases entered do not match.");
                }
            }
        });
        this.saveKeyPair = new Button(group, 0);
        this.saveKeyPair.setText("&Save Private Key...");
        gd = new GridData(128);
        gd.horizontalSpan = columnSpan;
        this.saveKeyPair.setLayoutData((Object)gd);
        SelectionAdapter keygenadapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean ok = true;
                String _type = "";
                try {
                    int type = 0;
                    if (e.widget == SSH2PreferencePage.this.keyGenerateDSA) {
                        type = 1;
                        _type = DSA;
                    } else if (e.widget == SSH2PreferencePage.this.keyGenerateRSA) {
                        type = 2;
                        _type = RSA;
                    } else {
                        return;
                    }
                    final KeyPair[] _kpair = new KeyPair[1];
                    final JSch _jsch = SSH2PreferencePage.this.jsch;
                    final int __type = type;
                    final JSchException[] _e = new JSchException[1];
                    BusyIndicator.showWhile((Display)SSH2PreferencePage.this.getShell().getDisplay(), (Runnable)new Runnable(){

                        public void run() {
                            try {
                                _kpair[0] = KeyPair.genKeyPair((JSch)_jsch, (int)__type);
                            }
                            catch (JSchException e) {
                                _e[0] = e;
                            }
                        }
                    });
                    if (_e[0] != null) {
                        throw _e[0];
                    }
                    SSH2PreferencePage.this.kpair = _kpair[0];
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    SSH2PreferencePage.this.kpairComment = String.valueOf(_type) + "-1024";
                    SSH2PreferencePage.this.kpair.writePublicKey((OutputStream)out, SSH2PreferencePage.this.kpairComment);
                    out.close();
                    SSH2PreferencePage.this.publicKeyText.setText(out.toString());
                    SSH2PreferencePage.this.keyFingerPrintText.setText(SSH2PreferencePage.this.kpair.getFingerPrint());
                    SSH2PreferencePage.this.keyCommentText.setText(SSH2PreferencePage.this.kpairComment);
                    SSH2PreferencePage.this.keyPassphrase1Text.setText("");
                    SSH2PreferencePage.this.keyPassphrase2Text.setText("");
                    SSH2PreferencePage.this.updateControls();
                }
                catch (IOException iOException) {
                    ok = false;
                }
                catch (JSchException jSchException) {
                    ok = false;
                }
                if (!ok) {
                    MessageDialog.openError((Shell)SSH2PreferencePage.this.getShell(), (String)"Error", (String)"The key was not generated.");
                }
            }
        };
        this.keyGenerateDSA.addSelectionListener((SelectionListener)keygenadapter);
        this.keyGenerateRSA.addSelectionListener((SelectionListener)keygenadapter);
        this.keyLoad.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean ok = true;
                String home = "resources/ssh2/";
                FileDialog fd = new FileDialog(SSH2PreferencePage.this.getShell(), 4096);
                fd.setFilterPath(home);
                String o = fd.open();
                if (o == null) {
                    return;
                }
                String pkey = fd.getFileName();
                String pkeyab = new File(fd.getFilterPath(), pkey).getAbsolutePath();
                try {
                    KeyPair _kpair = KeyPair.load((JSch)SSH2PreferencePage.this.jsch, (String)pkeyab);
                    SSH2PassphrasePrompt prompt = null;
                    while (_kpair.isEncrypted()) {
                        if (prompt == null) {
                            prompt = new SSH2PassphrasePrompt("Enter passphrase for " + pkey);
                        }
                        Display.getDefault().syncExec(prompt);
                        String passphrase = prompt.getPassphrase();
                        if (passphrase == null || _kpair.decrypt(passphrase)) break;
                        MessageDialog.openError((Shell)SSH2PreferencePage.this.getShell(), (String)"Error", (String)("failed to decrypt " + pkey));
                    }
                    if (_kpair.isEncrypted()) {
                        return;
                    }
                    SSH2PreferencePage.this.kpair = _kpair;
                    String _type = SSH2PreferencePage.this.kpair.getKeyType() == 1 ? DSA : RSA;
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    SSH2PreferencePage.this.kpairComment = String.valueOf(_type) + "-1024";
                    SSH2PreferencePage.this.kpair.writePublicKey((OutputStream)out, SSH2PreferencePage.this.kpairComment);
                    out.close();
                    SSH2PreferencePage.this.publicKeyText.setText(out.toString());
                    SSH2PreferencePage.this.keyFingerPrintText.setText(SSH2PreferencePage.this.kpair.getFingerPrint());
                    SSH2PreferencePage.this.keyCommentText.setText(SSH2PreferencePage.this.kpairComment);
                    SSH2PreferencePage.this.keyPassphrase1Text.setText("");
                    SSH2PreferencePage.this.keyPassphrase2Text.setText("");
                    SSH2PreferencePage.this.updateControls();
                }
                catch (IOException iOException) {
                    ok = false;
                }
                catch (JSchException jSchException) {
                    ok = false;
                }
                if (!ok) {
                    MessageDialog.openError((Shell)SSH2PreferencePage.this.getShell(), (String)"Error", (String)"failed to load given file.");
                }
            }
        });
        this.saveKeyPair.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SSH2PreferencePage.this.kpair == null) {
                    return;
                }
                String pass = SSH2PreferencePage.this.keyPassphrase1Text.getText();
                if (!pass.equals(SSH2PreferencePage.this.keyPassphrase2Text.getText())) {
                    MessageDialog.openError((Shell)SSH2PreferencePage.this.getShell(), (String)"Error", (String)"The passphrases entered do not match.");
                    return;
                }
                if (pass.length() == 0 && !MessageDialog.openConfirm((Shell)SSH2PreferencePage.this.getShell(), (String)"Confirmation", (String)"Are you sure you want to save this private key without the passpharse protection?")) {
                    return;
                }
                SSH2PreferencePage.this.kpair.setPassphrase(pass);
                final String[] target = new String[1];
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        Display display = Display.getCurrent();
                        Shell shell = new Shell(display);
                        ExportDialog dialog = new ExportDialog(shell, "Save ssh key.", "Specify a target dir(in user@host format) where your public key should be saved.\nYour key will be stored in user@host");
                        dialog.open();
                        shell.dispose();
                        target[0] = dialog.getTarget();
                    }
                });
                if (target[0] == null) {
                    return;
                }
                String user = "";
                String host = "";
                if (target[0].indexOf(64) > 0) {
                    user = target[0].substring(0, target[0].indexOf(64));
                    host = target[0].substring(target[0].indexOf(64) + 1);
                }
                if (user.length() == 0 || host.length() == 0) {
                    SSH2PreferencePage.this.setErrorMessage(String.valueOf(target[0]) + " is not valid dir.");
                    return;
                }
                String home = "resources/ssh2/" + target[0];
                File _home = new File(home);
                if (!_home.exists()) {
                    if (!MessageDialog.openConfirm((Shell)SSH2PreferencePage.this.getShell(), (String)"Confirmation", (String)" does not exsit.\nAre you sure you want to create it?")) {
                        return;
                    }
                    if (!_home.mkdirs()) {
                        SSH2PreferencePage.this.setErrorMessage("Failed to create " + home);
                        return;
                    }
                }
                FileDialog fd = new FileDialog(SSH2PreferencePage.this.getShell(), 8192);
                fd.setFilterPath("./" + home + "/");
                String file = SSH2PreferencePage.this.kpair.getKeyType() == 2 ? "id_rsa" : "id_dsa";
                fd.setFileName(file);
                file = fd.open();
                if (file == null) {
                    return;
                }
                if (new File(file).exists() && !MessageDialog.openConfirm((Shell)SSH2PreferencePage.this.getShell(), (String)"Confirmation", (String)(String.valueOf(file) + " has already existed.\nAre you sure you want to over write it?"))) {
                    return;
                }
                boolean ok = true;
                try {
                    SSH2PreferencePage.this.kpair.writePrivateKey(file);
                    SSH2PreferencePage.this.kpair.writePublicKey(String.valueOf(file) + ".pub", SSH2PreferencePage.this.kpairComment);
                }
                catch (Exception exception) {
                    ok = false;
                }
                if (ok) {
                    MessageDialog.openInformation((Shell)SSH2PreferencePage.this.getShell(), (String)"Information", (String)("Successfully saved.\nPrivate key: " + file + "\n" + "Public key: " + file + ".pub"));
                }
            }
        });
        return group;
    }

    private Control createHostKeyManagementPage(Composite parent) {
        Composite group = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        group.setLayoutData((Object)gd);
        Label label = new Label(group, 0);
        label.setText("Host Keys included in known_hosts.");
        gd = new GridData();
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.viewer = new TableViewer(group, 68354);
        Table table = this.viewer.getTable();
        new TableEditor(table);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        gd = new GridData(1808);
        gd.widthHint = this.convertWidthInCharsToPixels(30);
        gd.heightHint = 100;
        table.setLayoutData((Object)gd);
        table.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                SSH2PreferencePage.this.handleSelection();
            }
        });
        new TableColumn(table, 0);
        new TableColumn(table, 0);
        new TableColumn(table, 0);
        TableColumn[] columns = table.getColumns();
        columns[0].setText("Hostname");
        columns[1].setText("Type");
        columns[2].setText("Fingerprint");
        this.viewer.setColumnProperties(new String[]{"Hostname", "Type", "Fingerprint"});
        this.viewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement == null) {
                    return null;
                }
                return (Object[])inputElement;
            }
        });
        TableLayout tl = new TableLayout();
        tl.addColumnData((ColumnLayoutData)new ColumnWeightData(20));
        tl.addColumnData((ColumnLayoutData)new ColumnWeightData(10));
        tl.addColumnData((ColumnLayoutData)new ColumnWeightData(70));
        table.setLayout((Layout)tl);
        Composite buttons = new Composite(group, 0);
        buttons.setLayoutData((Object)new GridData(2));
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttons.setLayout((Layout)layout);
        this.removeHostKeyButton = new Button(buttons, 8);
        this.removeHostKeyButton.setText("Remove");
        gd = new GridData();
        gd.horizontalAlignment = 4;
        this.removeHostKeyButton.setLayoutData((Object)gd);
        this.removeHostKeyButton.setEnabled(false);
        this.removeHostKeyButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                SSH2PreferencePage.this.removeHostKey();
            }
        });
        Dialog.applyDialogFont((Control)parent);
        HostKey[] hostKey = this.jsch.getHostKeyRepository().getHostKey();
        if (hostKey != null) {
            int i = 0;
            while (i < hostKey.length) {
                this.viewer.setInput((Object)hostKey);
                ++i;
            }
        }
        this.handleSelection();
        return group;
    }

    private void handleSelection() {
        boolean empty = this.viewer.getSelection().isEmpty();
        this.removeHostKeyButton.setEnabled(!empty);
    }

    private void removeHostKey() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        for (HostKey hostkey : selection) {
            this.jsch.getHostKeyRepository().remove(hostkey.getHost(), hostkey.getType());
            this.viewer.remove((Object)hostkey);
        }
    }

    private void updateControls() {
        boolean enable = this.kpair != null;
        this.publicKeylabel.setEnabled(enable);
        this.publicKeyText.setEnabled(enable);
        this.keyFingerPrintLabel.setEnabled(enable);
        this.keyFingerPrintText.setEnabled(enable);
        this.keyCommentLabel.setEnabled(enable);
        this.keyCommentText.setEnabled(enable);
        this.keyPassphrase1Label.setEnabled(enable);
        this.keyPassphrase1Text.setEnabled(enable);
        this.keyPassphrase2Label.setEnabled(enable);
        this.keyPassphrase2Text.setEnabled(enable);
        this.saveKeyPair.setEnabled(enable);
    }

    public void init(IWorkbench workbench) {
    }

    public void initialize() {
    }

    private void initControls() {
        this.updateControls();
    }

    public boolean performOk() {
        boolean result = super.performOk();
        if (result) {
            this.setErrorMessage(null);
            String home = "resources/ssh2/";
            File _home = new File(home);
            if (!_home.exists()) {
                MessageBox mb = new MessageBox(this.getShell(), 196);
                mb.setText("Question");
                mb.setMessage(String.valueOf(home) + " does not exist.\nAre you sure you want to create it?");
                if (mb.open() == 64 && !_home.mkdirs()) {
                    this.setErrorMessage("Failed to create " + home);
                    return false;
                }
            }
        }
        return result;
    }

    public void performApply() {
        super.performApply();
        this.setErrorMessage(null);
        String home = "resources/ssh2/";
        File _home = new File(home);
        if (!_home.exists()) {
            MessageBox mb = new MessageBox(this.getShell(), 196);
            mb.setText("Question");
            mb.setMessage(String.valueOf(home) + " does not exist.\nAre you sure you want to create it?");
            if (mb.open() == 64 && !_home.mkdirs()) {
                this.setErrorMessage("Failed to create " + home);
                return;
            }
        }
    }

    protected void performDefaults() {
        super.performDefaults();
        this.updateControls();
    }

    protected void createSpacer(Composite composite, int columnSpan) {
        Label label = new Label(composite, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = columnSpan;
        label.setLayoutData((Object)gd);
    }

    class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        TableLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            HostKey entry = (HostKey)element;
            switch (columnIndex) {
                case 0: {
                    return entry.getHost();
                }
                case 1: {
                    return entry.getType();
                }
                case 2: {
                    return entry.getFingerPrint(SSH2PreferencePage.this.jsch);
                }
            }
            return null;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }
}

