/*
 * Created on 2006/12/02
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 */
package netwatcher.ssh2.command;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;

import netwatcher.ssh2.command.oneshotschedule.CommandTimerTask;
import netwatcher.ssh2.command.schedule.SchedulerCommandTask;
import netwatcher.ssh2.preference.SSH2Preference;

public final class CommandTaskScheduleControl {
	// MO
	private static Logger logger = null;

	/* ^XNXPW[ێ郊Xg */
	private Map taskScheduleList = Collections.synchronizedMap(new HashMap());

	// RXgN^privateɂĕspӂɒڃRXgN^Ăяoh~
	private CommandTaskScheduleControl() {
		logger = Logger.getLogger(this.getClass().getName());
	}

	public synchronized void setTaskSchedule(String taskID, String target,
			String commandFileName, Date setStartDate) {

		String commandFilePath = SSH2Preference.RESOURCE_SSH2_DIR + target
				+ "/" + SSH2Preference.COMMAND_DIR + "/" + commandFileName;

		Timer taskTimer = new Timer();

		/* wɎsiJnj^XNZbg */
		TimerTask threadStartTask = new CommandTimerTask(target,
				commandFilePath);
		taskTimer.schedule(threadStartTask, setStartDate);

		/* ^XNXPW[𐶐āAXgɕێ */
		CommandTaskScheduleInfo info = new CommandTaskScheduleInfo();
		info.setTaskStartDate(setStartDate);
		info.setTaskTimer(taskTimer);

		info.setTaskID(taskID);
		info.setTarget(target);
		info.setCommandFile(commandFileName);
		taskScheduleList.put(info.getTaskID(), info);

	}

	public synchronized void setTaskSchedule(String taskID, String target,
			String commandFileName, int dayOfMonth, int dayOfWeek,
			int hourOfDay, int minute) {

		String commandFilePath = SSH2Preference.RESOURCE_SSH2_DIR + target
				+ "/" + SSH2Preference.COMMAND_DIR + "/" + commandFileName;

		CommandTaskScheduleInfo info = new CommandTaskScheduleInfo();

		info.setTaskID(taskID);
		info.setTarget(target);
		info.setCommandFile(commandFilePath);
		if (dayOfMonth > 0) {
			info.setDayOfMonth(dayOfMonth);
			info.setDayOfMonthHour(hourOfDay);
			info.setDayOfMonthMinute(minute);
		}
		if (dayOfWeek > 0) {
			info.setDayOfWeek(dayOfWeek);
			info.setDayOfWeekHour(hourOfDay);
			info.setDayOfWeekMinute(minute);
		}

		SchedulerCommandTask commandTask = new SchedulerCommandTask(target,
				commandFilePath, dayOfMonth, dayOfWeek, hourOfDay, minute);
		commandTask.start();
		info.setCommandTask(commandTask);
		taskScheduleList.put(info.getTaskID(), info);

	}

	/**
	 * ^XNXPW[LZ܂B
	 * 
	 * @param info
	 *            ^XNXPW[
	 */
	public synchronized void cancelTaskSchedule(CommandTaskScheduleInfo info) {
		logger.info("Cancel Task ID=" + info.getTaskID());
		if (info.getTaskTimer() != null) {
			info.getTaskTimer().cancel();
		} else if (info.getCommandTask() != null) {
			info.getCommandTask().stop();
		}
		taskScheduleList.remove(info.getTaskID());

	}

	/**
	 * ^XNXPW[񃊃XgԂ܂B
	 * 
	 * 
	 * @return taskScheduleList ^XNXPW[񃊃Xg
	 */
	public synchronized Map getTaskSchedule() {
		return taskScheduleList;
	}

	/**
	 * ̃NX̃CX^XԂ܂B<BR>
	 * iNXێĂVOgEIuWFNg Ԃ܂j<BR>
	 * 
	 * @return VOgEIuWFNgƂĂ̂̃NX CX^X
	 */
	public static CommandTaskScheduleControl getInstance() {
		return SingletonResource.INSTANCE;
	}

	/**
	 * VOgEIuWFNgێNXłB<BR>
	 * 
	 */
	private static class SingletonResource {
		static final CommandTaskScheduleControl INSTANCE = new CommandTaskScheduleControl();
	}
}
