/*
 * Created on 2006/12/02
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 */
package netwatcher.ssh2.command;

import java.util.Date;
import java.util.Timer;

import netwatcher.ssh2.command.schedule.SchedulerCommandTask;

public class CommandTaskScheduleInfo {

	// ^XNID
	private String taskID;

	private SchedulerCommandTask commandTask;

	private String target;

	private String commandFile;

	// ^XNJn
	private Date taskStartDate;

	// ^XN^C}[CX^X
	private transient Timer taskTimer;

	private int dayOfMonth = 0;

	private int dayOfMonthHour = 0;

	private int dayOfMonthMinute = 0;

	private int dayOfWeek = 0;

	private int dayOfWeekHour = 0;

	private int dayOfWeekMinute = 0;

	/**
	 * ^XNJnԂ܂B
	 * 
	 * @return taskStartDate ^XNJn
	 */
	public Date getTaskStartDate() {
		return taskStartDate;
	}

	/**
	 * ^XN^C}[CX^XԂ܂B
	 * 
	 * @return taskTimer ^XN^C}[CX^X
	 */
	public Timer getTaskTimer() {
		return taskTimer;
	}

	/**
	 * ^XNJnZbg܂B
	 * 
	 * @param date
	 *            ^XNJn
	 */
	public void setTaskStartDate(Date date) {
		taskStartDate = date;
	}

	/**
	 * ^XN^C}[CX^XZbg܂B
	 * 
	 * @param timer
	 *            ^XN^C}[CX^X
	 */
	public void setTaskTimer(Timer timer) {
		taskTimer = timer;
	}

	/**
	 * ^XNIDԂ܂B
	 * 
	 * @return taskID ^XNID
	 */
	public String getTaskID() {
		return taskID;
	}

	/**
	 * ^XNIDZbg܂B
	 * 
	 * @param string
	 *            ^XNID
	 */
	public void setTaskID(String string) {
		taskID = string;
	}

	public String getCommandFile() {
		return commandFile;
	}

	public void setCommandFile(String commandFile) {
		this.commandFile = commandFile;
	}

	public String getTarget() {
		return target;
	}

	public void setTarget(String target) {
		this.target = target;
	}

	public int getDayOfMonth() {
		return dayOfMonth;
	}

	public void setDayOfMonth(int dayOfMonth) {
		this.dayOfMonth = dayOfMonth;
	}

	public int getDayOfMonthHour() {
		return dayOfMonthHour;
	}

	public void setDayOfMonthHour(int dayOfMonthHour) {
		this.dayOfMonthHour = dayOfMonthHour;
	}

	public int getDayOfMonthMinute() {
		return dayOfMonthMinute;
	}

	public void setDayOfMonthMinute(int dayOfMonthMinute) {
		this.dayOfMonthMinute = dayOfMonthMinute;
	}

	public int getDayOfWeek() {
		return dayOfWeek;
	}

	public void setDayOfWeek(int dayOfWeek) {
		this.dayOfWeek = dayOfWeek;
	}

	public int getDayOfWeekHour() {
		return dayOfWeekHour;
	}

	public void setDayOfWeekHour(int dayOfWeekHour) {
		this.dayOfWeekHour = dayOfWeekHour;
	}

	public int getDayOfWeekMinute() {
		return dayOfWeekMinute;
	}

	public void setDayOfWeekMinute(int dayOfWeekMinute) {
		this.dayOfWeekMinute = dayOfWeekMinute;
	}

	public SchedulerCommandTask getCommandTask() {
		return commandTask;
	}

	public void setCommandTask(SchedulerCommandTask commandTask) {
		this.commandTask = commandTask;
	}
}
