/*
 * Created on 2006/12/02
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 */
package netwatcher.ssh2.command.oneshotschedule;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;

import netwatcher.ssh2.info.Credentials;
import netwatcher.ssh2.info.NetWatcherUserInfo;
import netwatcher.ssh2.info.SSHNodeInfo;
import netwatcher.ssh2.info.SSHNodeInfoControl;
import netwatcher.ssh2.info.SessionInfo;
import netwatcher.ssh2.model.SSHCommandThread;
import netwatcher.ssh2.preference.SSH2Preference;
import netwatcher.ssh2.preference.SSH2UserAuthManager;

public class OneshotCommandTask {

	/* MO */
	private static Logger logger;

	private String target;

	private String commandFileName;

	public OneshotCommandTask(String target, String commandFileName) {
		logger = Logger.getLogger(this.getClass().getName());
		this.target = target;
		this.commandFileName = commandFileName;
	}

	public void executeCommand() {

		ArrayList commandList = null;
		SSH2UserAuthManager manager = new SSH2UserAuthManager();

		try {
			commandList = parseCommandFile(commandFileName);
			manager.getSystemResourceFileParse(SSH2Preference.RESOURCE_SSH2_DIR
					+ target + "/" + SSH2Preference.USER_HOST_AUTH);
		} catch (IOException e1) {

			return;
		}
		String userHost = manager.getTarget();

		String user = "";
		String host = "";

		if (target.indexOf('@') > 0) {
			user = userHost.substring(0, userHost.indexOf('@'));
			host = userHost.substring(userHost.indexOf('@') + 1);
		}

		setSSHInfo(user, host, manager.getPassword(), manager.getPassphrase());

		SSHCommandThread thread = new SSHCommandThread();
		thread.setUserHost(user, host);
		thread.setCommandList(commandList);
		thread.startSSHCommandThread();

	}

	public ArrayList parseCommandFile(String commandFilePath)
			throws IOException {

		ArrayList commandList = new ArrayList();
		BufferedReader buffReader = null;
		FileReader fi = null;
		try {
			fi = new FileReader(commandFilePath);
			buffReader = new BufferedReader(fi);
		} catch (FileNotFoundException e1) {
			throw e1;
		}

		try {

			String message;

			while ((message = buffReader.readLine()) != null) {
				commandList.add(message);
			}

		} catch (FileNotFoundException e1) {
			e1.printStackTrace();
			throw e1;
		} catch (IOException e) {
			e.printStackTrace();
			throw e;
		} finally {
			if (buffReader != null) {
				try {
					buffReader.close();
				} catch (IOException e2) {
					logger.warning(e2.getMessage());
					e2.printStackTrace();
				}
			}

			if (fi != null) {
				try {
					fi.close();
				} catch (IOException e2) {
					logger.warning(e2.getMessage());
					e2.printStackTrace();
				}
			}
		}

		return commandList;

	}

	private void setSSHInfo(String userName, String host, String password,
			String passphrase) {

		Credentials cred = new Credentials();
		cred.setPassphrase(passphrase);
		File id_dsa_keyFile = new File(SSH2Preference.RESOURCE_SSH2_DIR
				+ userName + "@" + host + "/" + SSH2Preference.ID_DSA_FILE);

		if (id_dsa_keyFile == null) {
			logger.warning("resources/id_dsa null");
		} else {
			if (!id_dsa_keyFile.exists()) {
				logger.info("resources/id_dsa no exists");
			} else {
				cred.setIdDSAKeyFile(id_dsa_keyFile);

			}
		}

		File id_rsa_keyFile = new File(SSH2Preference.RESOURCE_SSH2_DIR
				+ userName + "@" + host + "/" + SSH2Preference.ID_RSA_FILE);

		ArrayList commandList = new ArrayList();

		if (id_rsa_keyFile == null) {
			logger.info("resources/id_rsa null");
		} else {
			if (!id_rsa_keyFile.exists()) {
				logger.warning("resources/id_rsa no exists");
			} else {
				cred.setIdRSAKeyFile(id_rsa_keyFile);

			}

		}

		SessionInfo sessionInfo = new SessionInfo();
		sessionInfo.setHost(host);
		sessionInfo.setPort(SSH2Preference.SSH_PORT);
		sessionInfo.setUserName(userName);

		NetWatcherUserInfo userInfo = new NetWatcherUserInfo(password,
				passphrase);

		SSHNodeInfo sshNodeInfo = new SSHNodeInfo();
		sshNodeInfo.setCredentials(cred);
		sshNodeInfo.setSshUserInfo(userInfo);
		sshNodeInfo.setSessionInfo(sessionInfo);
		sshNodeInfo.setCommandList(commandList);

		SSHNodeInfoControl.getInstance().setSSHInfo(userName + "@" + host,
				sshNodeInfo);

	}
}
