/*
 * Created on 2006/12/02
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 */
package netwatcher.ssh2.command.schedule;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DailyIterator implements ScheduleIterator {

	private DateFormat dateformat = new SimpleDateFormat(
			"yyyy-MM-dd (EEE) HH:mm:ss");

	private final int dayOfMonth;

	private final int dayOfWeek;

	private final int hourOfDay;

	private final int minute;

	private final int second;

	private final Calendar calendar = Calendar.getInstance();

	public DailyIterator(int dayOfMonth, int dayOfWeek, int hourOfDay,
			int minute) {
		this(dayOfMonth, dayOfWeek, hourOfDay, minute, new Date());
	}

	public DailyIterator(int dayOfMonth, int dayOfWeek, int hourOfDay,
			int minute, Date date) {
		this.dayOfMonth = dayOfMonth;
		this.dayOfWeek = dayOfWeek;
		this.hourOfDay = hourOfDay;
		this.minute = minute;
		this.second = 0;
		calendar.setTime(date);
		if (dayOfMonth > 0) {
			calendar.set(Calendar.DAY_OF_MONTH, dayOfMonth);
		}
		if (dayOfWeek > 0) {
			calendar.set(Calendar.DAY_OF_WEEK, dayOfWeek);
		}
		calendar.set(Calendar.HOUR_OF_DAY, hourOfDay);
		calendar.set(Calendar.MINUTE, minute);
		calendar.set(Calendar.SECOND, second);
		calendar.set(Calendar.MILLISECOND, 0);

		if (!calendar.getTime().before(date)) {
			if (dayOfMonth > 0) {
				calendar.add(Calendar.MONTH, -1);

			} else if (dayOfWeek > 0) {
				calendar.add(Calendar.DAY_OF_MONTH, -7);

			}
		}
	}

	public Date next() {
		if (dayOfMonth > 0) {

			calendar.add(Calendar.MONTH, 1);

		} else if (dayOfWeek > 0) {

			calendar.add(Calendar.DAY_OF_MONTH, 7);

		}
		return calendar.getTime();
	}

}
