/*
 * Created on 2006/12/02
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 */
package netwatcher.ssh2.command.schedule;

import java.util.TimerTask;

public abstract class SchedulerTask implements Runnable {
	final Object lock = new Object();

	int state = VIRGIN;

	static final int VIRGIN = 0;

	static final int SCHEDULED = 1;

	static final int CANCELLED = 2;

	protected TimerTask timerTask;

	protected SchedulerTask() {
	}

	public abstract void run();

	public boolean cancel() {
		synchronized (lock) {
			if (timerTask != null) {
				timerTask.cancel();
			}
			boolean result = (state == SCHEDULED);
			state = CANCELLED;
			return result;
		}
	}

	public long scheduledExecutionTime() {
		synchronized (lock) {
			return timerTask == null ? 0 : timerTask.scheduledExecutionTime();
		}
	}
}
