/*
 * Created on 2006/12/02
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 */
package netwatcher.ssh2.gui.action;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;

import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.common.view.MenuPreference;
import netwatcher.ssh2.gui.editor.EditorInputSSHNodeView;
import netwatcher.ssh2.gui.editor.EditorSSHCommandScheduleView;
import netwatcher.ssh2.gui.editor.EditorSSHCommandView;
import netwatcher.ssh2.gui.treenode.ISSHUserHostTreeNode;
import netwatcher.ssh2.gui.treenode.SSHNodeTree;
import netwatcher.ssh2.gui.treenode.SSHNodeTreeGroup;
import netwatcher.ssh2.gui.treeview.AbstractSSHNodeTreeView;
import netwatcher.ssh2.gui.treeview.SSHNodeTreeViewSorter;
import netwatcher.ssh2.preference.SSH2Preference;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

/**
 * SSH2 m[hTree ViewɂANVNXłB
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class ActionBuilderNodeTree extends Action {
	/* MO */
	private static Logger logger = null;

	/*
	 * m[hIcon ImageIcon image filekeyƂĕێ (Icon imageQdɐ邱Ɩh~ƂƂɁA
	 * finalize()ImagejꍇɎgp)
	 */
	private HashMap nodeIconImageMap = new HashMap();

	/* TreeViewer */
	private TreeViewer nodeListTreeViewer;

	/* Xe[^XC}l[W擾pView */
	private AbstractSSHNodeTreeView nodeTreeView;

	/* Xe[^XC}l[W */
	private SubStatusLineManager statusLineManager;

	/* Composite */
	private Composite parentComposite;

	/* NodeTreeGroup */
	private SSHNodeTreeGroup nodeTreeGroupRoot;

	private Image fileObjImage;

	/*
	 * GroupǗMapGroupɑ݂Ă邩AVK Group쐬邩̔fɎgp
	 */
	private HashMap groupMap = new HashMap();

	/* 摜肷邽߂PluginResource bundle */
	private final Bundle bundle = NetJFWatcherPlugin.getInstance().getBundle();

	private IAction reloadNodeTreeDatabase = new ActionReloadNodeTree();

	private IAction sortNodeTreeDatabase = new ActionSortNodeTreeDatabase();

	private IAction openSSH2CommandView = new ActionSSH2CommandView();

	private IAction openSSH2CommandSchedule = new ActionSSH2CommandSchedule();

	/**
	 * m[hTree ViewɂANVNXCX^X 𐶐܂B
	 * 
	 */
	public ActionBuilderNodeTree() {
		logger = Logger.getLogger(this.getClass().getName());
		createNodeIconImage();
	}

	public ActionBuilderNodeTree(AbstractSSHNodeTreeView nodeTreeView,
			TreeViewer nodeListTreeViewer, Composite parentComposite,
			SSHNodeTreeGroup nodeTreeGroupRoot) {
		logger = Logger.getLogger(this.getClass().getName());
		this.nodeTreeView = nodeTreeView;
		this.nodeListTreeViewer = nodeListTreeViewer;
		this.parentComposite = parentComposite;
		this.nodeTreeGroupRoot = nodeTreeGroupRoot;
		createNodeIconImage();
	}

	/**
	 * TreeViewerԂ܂B
	 * 
	 * @return nodeListTreeViewer TreeViewer
	 */
	public TreeViewer getViewer() {
		return nodeListTreeViewer;
	}

	/**
	 * m[hTreeǂݍ݃ANVԂ܂B
	 * 
	 * @return reloadNodeTree m[hTreeǂݍ݃ANV
	 */
	public IAction actionReloadNodeTreeDatabase() {
		return reloadNodeTreeDatabase;
	}

	/**
	 * m[hTree\[gANVԂ܂B
	 * 
	 * @return sortNodeTreeDatabase m[hTree\[gANV
	 */
	public IAction actionSortNodeTreeDatabase() {
		return sortNodeTreeDatabase;
	}

	public IAction actionOpenSSH2CommandView() {
		return openSSH2CommandView;
	}

	public IAction actionOpenSSH2CommandSchedule() {
		return openSSH2CommandSchedule;
	}

	public void createNodeTree(final boolean isSortDirectionTreeView) {

		File fleDir = new File(SSH2Preference.RESOURCE_SSH2_DIR);
		File[] fileList = fleDir.listFiles();
		if (fileList != null) {
			for (int fileCount = 0; fileCount < fileList.length; fileCount++) {
				if (fileList[fileCount].isDirectory()) {

					/* 擾GroupVȖȌꍇGroupVK쐬 */
					SSHNodeTreeGroup nodetreeGroup = null;

					String group = fileList[fileCount].getName();

					if (groupMap.containsKey(group)) {
						/* 擾Groupɑ݂ꍇɂ́AGroup擾 */
						nodetreeGroup = (SSHNodeTreeGroup) groupMap.get(group);
					} else {
						/* 擾GroupVȖȌꍇGroupVK쐬 */
						nodetreeGroup = new SSHNodeTreeGroup(group);

						/* m[hTree RootGroupǉ */
						nodeTreeGroupRoot.addChild(nodetreeGroup);
						groupMap.put(group, nodetreeGroup);
					}

					nodeTreeGroupRoot.addChild(nodetreeGroup);

					File[] userHostFileList = fileList[fileCount].listFiles();
					for (int userHostCount = 0; userHostCount < userHostFileList.length; userHostCount++) {
						if (userHostFileList[userHostCount].isFile()) {

							nodetreeGroup.addChild(new SSHNodeTree(
									fileList[fileCount].getName(),
									userHostFileList[userHostCount].getName(),
									userHostFileList[userHostCount],
									fileObjImage));

						} else {
							SSHNodeTreeGroup commandGroup = new SSHNodeTreeGroup(
									userHostFileList[userHostCount].getName());
							nodetreeGroup.addChild(commandGroup);
							File[] cmdFileList = userHostFileList[userHostCount]
									.listFiles();
							for (int cmdCount = 0; cmdCount < cmdFileList.length; cmdCount++) {
								if (cmdFileList[cmdCount].isFile()) {

									commandGroup
											.addChild(new SSHNodeTree(
													fileList[fileCount]
															.getName(),
													cmdFileList[cmdCount]
															.getName(),
													cmdFileList[cmdCount],
													fileObjImage));
								}
							}
						}
					}

				} else {
					if (fileList[fileCount].getName().equals(
							SSH2Preference.KNOWN_HOSTS_FILE)) {
						nodeTreeGroupRoot.addChild(new SSHNodeTree(
								fileList[fileCount].getName(),
								fileList[fileCount].getName(),
								fileList[fileCount], fileObjImage));
					}

				}
			}
		}

		/* TreeView\[g */
		nodeListTreeViewer.setSorter(new SSHNodeTreeViewSorter() {

			public int compare(Viewer viewer, Object e1, Object e2) {

				int cat1 = category(e1);
				int cat2 = category(e2);
				if (cat1 != cat2) {
					return cat1 - cat2;
				}

				// cat1 == cat2
				String name1;
				String name2;

				if ((viewer == null) || !(viewer instanceof ContentViewer)) {
					name1 = e1.toString();
					name2 = e2.toString();
				} else {
					IBaseLabelProvider prov = ((ContentViewer) viewer)
							.getLabelProvider();

					if (prov instanceof ILabelProvider) {
						ILabelProvider lprov = (ILabelProvider) prov;
						name1 = lprov.getText(e1);
						name2 = lprov.getText(e2);
					} else {
						name1 = e1.toString();
						name2 = e2.toString();
					}
				}

				if (name1 == null) {
					name1 = ""; //$NON-NLS-1$
				}

				if (name2 == null) {
					name2 = ""; //$NON-NLS-1$
				}

				if (isSortDirectionTreeView) {
					// \[g
					return collator.compare(name1, name2);
				}

				// ~\[g
				return collator.compare(name2, name1);
			}
		});

		nodeListTreeViewer.expandAll();
		nodeListTreeViewer.refresh();
	}

	/**
	 * Xe[^XC\Zbg܂B
	 * 
	 * @param groupNo
	 *            O[v
	 * @param nodeNo
	 *            m[h
	 */
	protected void setStatusLine(int groupNo, int nodeNo) {
		/* Xe[^XC\L */
		statusLineManager = (SubStatusLineManager) (nodeTreeView.getViewSite()
				.getActionBars().getStatusLineManager());

		statusLineManager.setVisible(true);
		statusLineManager.setMessage("Node Tree View " + "Group count="
				+ groupNo + " Node count=" + nodeNo);
	}

	/**
	 * m[hTreȇIm[hԂ܂B
	 * 
	 * @return node m[h
	 */
	public ISSHUserHostTreeNode getNodeBase() {
		// TreeIm[ho
		IStructuredSelection selectElement = (IStructuredSelection) getViewer()
				.getSelection();
		ISSHUserHostTreeNode node = (ISSHUserHostTreeNode) selectElement
				.getFirstElement();

		if (node == null) {
			node = (ISSHUserHostTreeNode) getViewer().getInput();
		}

		return node;
	}

	/**
	 * m[hO[vԂ܂B
	 * 
	 * @param node
	 *            m[h
	 * @return baseNodeGroup m[hO[v
	 */
	public SSHNodeTreeGroup setNodeGroupBase(ISSHUserHostTreeNode node) {
		SSHNodeTreeGroup baseNodeGroup = null;

		if (node != null) {
			baseNodeGroup = node.getParent();
		}

		if (node instanceof SSHNodeTreeGroup) {
			baseNodeGroup = (SSHNodeTreeGroup) node;
		}

		return baseNodeGroup;
	}

	/*
	 * ( Javadoc)
	 * 
	 * @see java.lang.Object#finalize()
	 */
	protected void finalize() throws Throwable {
		super.finalize();

		/* m[hIcon imagej */
		Map list = nodeIconImageMap;
		Iterator it = null;

		for (it = list.keySet().iterator(); it.hasNext();) {
			String key = (String) it.next();
			Image nodeIconImage = (Image) list.get(key);

			if (nodeIconImage != null) {
				nodeIconImage.dispose();
			}
		}
	}

	/**
	 * ANV`钊ۃNXłB
	 * 
	 * @author Yoshimasa Matsumoto
	 * @version 1.0
	 */
	protected abstract class AbstractNodeAction extends Action {
		/**
		 * ANVs܂B
		 */
		public final void run() {
			SSHNodeTreeGroup baseNodeGroup = null;

			ISSHUserHostTreeNode node = getNodeBase();
			baseNodeGroup = setNodeGroupBase(node);

			doTask(baseNodeGroup, node);
		}

		/**
		 * ANVs^XNłB
		 * 
		 * @param group
		 *            m[hO[v
		 * @param node
		 *            m[h
		 */
		protected abstract void doTask(SSHNodeTreeGroup group,
				ISSHUserHostTreeNode node);

		/**
		 * ImageDescriptorԂ܂B
		 * 
		 * @return ImageDescriptor
		 */
		public ImageDescriptor getImageDescriptor() {
			return ImageDescriptor.createFromURL(bundle
					.getEntry("icons/reload.gif"));
		}

		/**
		 * TextԂ܂B
		 * 
		 * @return Text
		 */
		public String getText() {
			return "Node Tree reload";
		}

		/**
		 * ToolTipTextԂ܂B
		 * 
		 * @return ToolTipText
		 */
		public String getToolTipText() {
			return "Node Tree reload";
		}
	}

	public final class ActionReloadNodeTree extends AbstractNodeAction {

		protected void doTask(SSHNodeTreeGroup group, ISSHUserHostTreeNode node) {
			nodeTreeGroupRoot.removeChildAll();
			groupMap.clear();
			setNodeTree();
		}

		public void setNodeTree() {
			createNodeTree(true);
		}
	}

	/**
	 * m[h\[gANV`钊ۃNXłB
	 * 
	 * @author Yoshimasa Matsumoto
	 * @version 1.0
	 */
	protected abstract class AbstractNodeSortAction extends AbstractNodeAction {
		/**
		 * ImageDescriptorԂ܂B
		 * 
		 * @return ImageDescriptor
		 */
		public ImageDescriptor getImageDescriptor() {
			return ImageDescriptor.createFromURL(bundle
					.getEntry(MenuPreference.NODE_TREE_SORT_IMAGE_FILE));
		}

		/**
		 * TextԂ܂B
		 * 
		 * @return Text
		 */
		public String getText() {
			return MenuPreference.NODE_TREE_SORT;
		}

		/**
		 * ToolTipTextԂ܂B
		 * 
		 * @return ToolTipText
		 */
		public String getToolTipText() {
			return MenuPreference.NODE_TREE_SORT_TOOL_TIP;
		}
	}

	/**
	 * m[hTree\[gANVNXłB
	 * 
	 * @author Yoshimasa Matsumoto
	 * @version 1.0
	 */
	protected final class ActionSortNodeTreeDatabase extends
			AbstractNodeSortAction {

		private boolean isSortToggle = true;

		/**
		 * Node TreeSort^XNłB
		 * 
		 * @param group
		 *            m[hO[v
		 * @param node
		 *            m[h
		 */
		protected void doTask(SSHNodeTreeGroup group, ISSHUserHostTreeNode node) {
			if (isSortToggle) {

				isSortToggle = false;
			} else {

				isSortToggle = true;
			}

			/*
			 * ێĂm[hTreeO[vXgUNA 邽߂ɃO[vǂݏoAz̎q
			 * m[h폜Ƀm[hTreeO[vXgN A
			 * 
			 */
			Iterator it = null;

			for (it = groupMap.keySet().iterator(); it.hasNext();) {
				String groupName = (String) it.next();
				SSHNodeTreeGroup nodeTreeGroup = (SSHNodeTreeGroup) groupMap
						.get(groupName);

				if (nodeTreeGroup != null) {
					SSHNodeTreeGroup parentNodeTreeGroup = nodeTreeGroup
							.getParent();

					if (node instanceof SSHNodeTreeGroup) {
						parentNodeTreeGroup = (SSHNodeTreeGroup) node;
					}

					/* O[vz̃m[h폜 */
					parentNodeTreeGroup.removeChildAll();
				}
			}

			nodeTreeGroupRoot.removeChildAll();
			groupMap.clear();
			setNodeTree();
		}

		/**
		 * Node TreeZbg܂B
		 * 
		 */
		protected void setNodeTree() {

			createNodeTree(isSortToggle);

		}
	}

	private void createNodeIconImage() {

		String sshNodeFileImageName = "icons/file_obj.gif";
		fileObjImage = null;

		Display display = parentComposite.getDisplay();

		URL url = null;
		url = bundle.getEntry(sshNodeFileImageName);
		if (url == null) {
			/* Icon\[Xt@CȂꍇMO̎ */
			logger.severe("Not found icon file : " + sshNodeFileImageName);
		} else {
			try {
				/* m[hIconC[W */
				fileObjImage = new Image(display, url.openStream());

			} catch (IOException e) {
				logger.warning("Abort create image " + e.getMessage() + " for "
						+ sshNodeFileImageName);
				e.printStackTrace();
			}
		}

	}

	public final class ActionSSH2CommandView extends AbstractNodeAction {
		private ISSHUserHostTreeNode sshNodeTree;

		private IEditorPart editorPart;

		/**
		 * ImageDescriptorԂ܂B
		 * 
		 * @return ImageDescriptor
		 */
		public ImageDescriptor getImageDescriptor() {
			return ImageDescriptor.createFromURL(bundle
					.getEntry("icons/file_obj.gif"));
		}

		/**
		 * TextԂ܂B
		 * 
		 * @return Text
		 */
		public String getText() {
			return "SSH2 Command";
		}

		/**
		 * ToolTipTextԂ܂B
		 * 
		 * @return ToolTipText
		 */
		public String getToolTipText() {
			return "SSH2 Command";
		}

		protected void doTask(SSHNodeTreeGroup group, ISSHUserHostTreeNode node) {

			openEditor();
		}

		public void openEditor() {

			IWorkbenchPage activePage = PlatformUI.getWorkbench()
					.getActiveWorkbenchWindow().getActivePage();

			if (editorPart != null) {

				activePage.closeEditor(editorPart, false);
				editorPart = null;
			}

			if (sshNodeTree instanceof SSHNodeTree) {

			} else if (sshNodeTree instanceof SSHNodeTreeGroup) {

				if (!((SSHNodeTreeGroup) sshNodeTree).getName().equals(
						SSH2Preference.COMMAND_DIR)) {
					try {

						editorPart = activePage.openEditor(
								new EditorInputSSHNodeView(
										((SSHNodeTreeGroup) sshNodeTree)
												.getName()
												+ " Command",
										((SSHNodeTreeGroup) sshNodeTree)
												.getName(), null, true),
								EditorSSHCommandView.class.getName());
					} catch (Exception e) {
						logger.warning("Exception " + e.getMessage());
					}
				}

			}

		}

		public void setSshNodeTree(ISSHUserHostTreeNode sshNodeTree) {
			this.sshNodeTree = sshNodeTree;
		}
	}

	public final class ActionSSH2CommandSchedule extends AbstractNodeAction {

		private ISSHUserHostTreeNode sshNodeTree;

		private IEditorPart editorPart;

		/**
		 * ImageDescriptorԂ܂B
		 * 
		 * @return ImageDescriptor
		 */
		public ImageDescriptor getImageDescriptor() {
			return ImageDescriptor.createFromURL(bundle
					.getEntry("icons/configs.gif"));
		}

		/**
		 * TextԂ܂B
		 * 
		 * @return Text
		 */
		public String getText() {
			return "SSH2 Command Schedule";
		}

		/**
		 * ToolTipTextԂ܂B
		 * 
		 * @return ToolTipText
		 */
		public String getToolTipText() {
			return "SSH2 Command Schedule";
		}

		protected void doTask(SSHNodeTreeGroup group, ISSHUserHostTreeNode node) {

			openEditor();
		}

		public void openEditor() {

			IWorkbenchPage activePage = PlatformUI.getWorkbench()
					.getActiveWorkbenchWindow().getActivePage();

			if (editorPart != null) {

				activePage.closeEditor(editorPart, false);
				editorPart = null;
			}

			if (sshNodeTree instanceof SSHNodeTree) {

			} else if (sshNodeTree instanceof SSHNodeTreeGroup) {

				if (!((SSHNodeTreeGroup) sshNodeTree).getName().equals(
						SSH2Preference.COMMAND_DIR)) {
					try {

						editorPart = activePage.openEditor(
								new EditorInputSSHNodeView(
										((SSHNodeTreeGroup) sshNodeTree)
												.getName()
												+ " Command Schedule",
										((SSHNodeTreeGroup) sshNodeTree)
												.getName(), null, true),
								EditorSSHCommandScheduleView.class.getName());
					} catch (Exception e) {
						logger.warning("Exception " + e.getMessage());
					}
				}

			}

		}

		public void setSshNodeTree(ISSHUserHostTreeNode sshNodeTree) {
			this.sshNodeTree = sshNodeTree;
		}
	}
}
