/*
 * Created on 2006/12/02
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 */
package netwatcher.ssh2.gui.editor;

import java.util.logging.Logger;

import netjfwatcher.application.NetJFWatcherPlugin;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import org.osgi.framework.Bundle;

public abstract class AbstractEditorSSH extends EditorPart {
	/* MO */
	private static Logger logger;

	/* Xe[^XC}l[W */
	protected SubStatusLineManager statusLineManager;

	/** Table */
	protected Table table;

	/*
	 * SocketɂăT[of[^擾邩f[^x[X 擾邩tO
	 */
	protected boolean isSocket;

	/* 摜肷邽߂PluginResource bundle */
	private final Bundle bundle = NetJFWatcherPlugin.getInstance().getBundle();

	/**
	 * m[hEditorɕ\NXׂۃNX RXgN^łB
	 */
	public AbstractEditorSSH() {
		logger = Logger.getLogger(this.getClass().getName());
	}

	/**
	 * PartControl𐶐܂B
	 * 
	 * @param parent
	 *            Composite
	 */
	abstract public void createPartControl(Composite parent);

	/**
	 * Xe[^XC\Zbg܂B
	 * 
	 */
	protected abstract void setStatusLine();

	/**
	 * tH[JXZbg̏łB
	 */
	public void setFocus() {
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.ISaveablePart#isDirty()
	 */
	public boolean isDirty() {
		return false;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.ISaveablePart#doSave(org.eclipse.core.runtime.IProgressMonitor)
	 */
	public void doSave(IProgressMonitor monitor) {
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.ISaveablePart#doSaveAs()
	 */
	public void doSaveAs() {
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.ISaveablePart#isSaveAsAllowed()
	 */
	public boolean isSaveAsAllowed() {
		return false;
	}

	/**
	 * EditorEBhEɏݒs܂B
	 * 
	 * @param site
	 *            TCg
	 * @param input
	 *            ͒l
	 * @throws PartInitException
	 *             ͒lݒ肪ُ̏ꍇ
	 */
	public void init(IEditorSite site, IEditorInput input)
			throws PartInitException {
		/* ͒lݒ肪킩`FbN */
		if (!(input instanceof EditorInputSSHNodeView)) {
			logger.warning("Wrong input: " + input.getClass());
			throw new PartInitException("Wrong input: " + input.getClass());
		}

		setSite(site);
		setInput(input);
		setPartName(input.getName());
	}

	/*
	 * ( Javadoc)
	 * 
	 * @see java.lang.Object#finalize()
	 */
	protected void finalize() throws Throwable {
		super.finalize();

		if (table != null) {
			table.dispose();
		}
	}
}
