/*
 * Created on 2006/12/02
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 */
package netwatcher.ssh2.gui.editor;

import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Logger;

import netjfwatcher.common.view.CalendarComposite;
import netwatcher.ssh2.command.CommandTaskScheduleControl;
import netwatcher.ssh2.command.CommandTaskScheduleInfo;
import netwatcher.ssh2.preference.SSH2Preference;

import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;

public class EditorSSHCommandScheduleView extends AbstractEditorSSH {

	/* Scroll CompositeTCY */
	private static final int[] SCROLL_COMPOSITE_SIZE = { 800, 900 };

	private static final int SCHEDULE_LIST_ITEM_HEIGHT = 12;

	private static final int COMMAND_LIST_ITEM_HEIGHT = 10;

	private static final int MONITOR_TEXT_WIDTH_HINT = 600;

	private static final int MONITOR_TEXT_HEIGHT_HINT = 400;

	/* {^ */
	private static final int BUTTON_WIDTH = 150;

	/* {^ */
	private static final int BUTTON_HEIGHT = 20;

	/* List */
	private static final int LIST_WIDTHHINT = 300;

	private static final int HORIZONTAL_SPAN3 = 3;

	private static final int HORIZONTAL_SPAN8 = 8;

	private static final String[] WEEK_STR_ARRY = { "Sun", "Mon", "Tue", "Wed",
			"Thu", "Fri", "Sat" };

	/* R}hj^[\^C}[ */
	private static final int MONITOR_TIMER = 1000;

	/* MO */
	private static Logger logger;

	/* ^XNXPW[Xg\[gpList */
	private static java.util.List taskScheduleSortList = Collections
			.synchronizedList(new LinkedList());

	/* Xe[^XC}l[W */
	private SubStatusLineManager statusLineManager;

	/* XV{^ */
	private Button refreshButton;

	/* \[g{^ */
	private Button sortButton;

	/* LZ{^ */
	private Button cancelButton;

	/* Zbg{^ */
	private Button setButton;

	/* XPW[\List */
	private List scheduleList;

	/* R}h\List */
	private List commandList;

	/* ^XNXPW[ JnN */
	private Text assignmentYearText;

	/* ^XNXPW[ Jn */
	private Text assignmentMonthText;

	/* ^XNXPW[ Jn */
	private Text assignmentDateText;

	private Button assignmentDateButton;

	private Button dayCheckButton;

	private Button dayOfWeekCheckButton;

	private Combo assignmentDateHourCombo;

	private Combo assignmentDateMinuteCombo;

	private Combo dayOfMonthHourCombo;

	private Combo dayOfMonthMinuteCombo;

	private Combo dayOfWeekHourCombo;

	private Combo dayOfWeekMinuteCombo;

	private Combo dayOfMonthCombo;

	private Combo dayOfWeekCombo;

	private Button monitorResetButton;

	private Text moniterText;

	/* JneLXg琶Date */
	private Date setStartDate;

	/* XPW[\tH[}bg */
	private DateFormat dateformat;

	/* ^XNXPW[Xg */
	private boolean isSortDirection = true;

	/** f[^\eLXg */
	public static final int DATE_TEXT_WIDTH = 250;

	/** eLXg\ */
	public static final int TEXT_WIDTH1 = 120;

	private EditorSSHCommandTimerProcessor timerProcessor;

	/* Display */
	private Display display;

	private String target;

	private String commandFileName;

	/**
	 * EditorEBhEɃuEU\邽߂̃CX^X 𐶐܂B
	 * 
	 */
	public EditorSSHCommandScheduleView() {
		logger = Logger.getLogger(this.getClass().getName());

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.ISaveablePart#isSaveAsAllowed()
	 */
	public boolean isSaveAsAllowed() {
		return false;
	}

	/**
	 * EditorEBhE𐶐܂B
	 * 
	 * @param parent
	 *            Composite
	 */
	public void createPartControl(Composite parent) {

		display = parent.getDisplay();

		/* ͐ݒlm[hĎ擾 */
		EditorInputSSHNodeView nodeViewEditorInput = (EditorInputSSHNodeView) getEditorInput();
		target = nodeViewEditorInput.getTarget();
		dateformat = new SimpleDateFormat("yyyy-MM-dd (EEE) HH:mm:ss");

		ScrolledComposite scrollComposite = new ScrolledComposite(parent,
				SWT.H_SCROLL | SWT.V_SCROLL);

		GridLayout layout = new GridLayout(1, false);
		scrollComposite.setLayout(layout);

		GridData gridData = null;

		GridLayout gridLayout0 = new GridLayout(2, true);
		Composite baseComposite = new Composite(scrollComposite, SWT.NONE);
		baseComposite.setLayout(gridLayout0);
		baseComposite.setLayoutData(new GridData());

		GridLayout gridLayoutListComp = new GridLayout(1, false);
		Composite compositeList = new Composite(baseComposite, SWT.NULL);
		compositeList.setLayout(gridLayoutListComp);
		compositeList.setLayoutData(new GridData(
				GridData.HORIZONTAL_ALIGN_BEGINNING
						| GridData.VERTICAL_ALIGN_BEGINNING));

		GridLayout gridLayoutOperation = new GridLayout(1, false);
		Composite compositeOperation = new Composite(baseComposite, SWT.NULL);
		compositeOperation.setLayout(gridLayoutOperation);
		compositeOperation.setLayoutData(new GridData(
				GridData.HORIZONTAL_ALIGN_BEGINNING
						| GridData.VERTICAL_ALIGN_BEGINNING));

		GridLayout gridLayoutButtonComp = new GridLayout(1, false);
		Composite compositeButton = new Composite(compositeOperation, SWT.NULL);
		compositeButton.setLayout(gridLayoutButtonComp);
		compositeButton.setLayoutData(new GridData());

		GridLayout gridLayoutDateTextComp = new GridLayout(HORIZONTAL_SPAN8,
				false);
		Composite compositeDateText = new Composite(compositeOperation,
				SWT.NULL);
		compositeDateText.setLayout(gridLayoutDateTextComp);
		compositeDateText.setLayoutData(new GridData());

		GridLayout gridLayoutCalendar = new GridLayout(1, false);
		Composite compositeCalendar = new Composite(compositeOperation,
				SWT.NONE);
		compositeCalendar.setLayoutData(new GridData(
				GridData.HORIZONTAL_ALIGN_FILL));
		compositeCalendar.setLayout(gridLayoutCalendar);

		GridLayout gridLayoutMonitor = new GridLayout(1, false);
		Composite compositeMonitor = new Composite(baseComposite, SWT.NULL);
		compositeMonitor.setLayout(gridLayoutMonitor);
		GridData monitorGridData = new GridData();
		monitorGridData.horizontalSpan = 2;
		monitorGridData.verticalSpan = 1;
		compositeMonitor.setLayoutData(monitorGridData);

		/*
		 * XPW[\Xg
		 */
		Label label = new Label(compositeList, SWT.NONE);
		label.setText("Schedule List");
		GridData listGridData = new GridData();
		listGridData.horizontalSpan = 1;
		listGridData.verticalSpan = 1;
		label.setLayoutData(listGridData);
		scheduleList = new List(compositeList, SWT.SINGLE | SWT.BORDER
				| SWT.V_SCROLL | SWT.H_SCROLL);
		GridData data = new GridData(GridData.VERTICAL_ALIGN_BEGINNING
				| GridData.HORIZONTAL_ALIGN_BEGINNING);
		data.horizontalSpan = 1; // Xp
		data.verticalSpan = 10; // Xp
		data.widthHint = LIST_WIDTHHINT;
		data.heightHint = scheduleList.getItemHeight()
				* SCHEDULE_LIST_ITEM_HEIGHT;
		scheduleList.setLayoutData(data);

		label = new Label(compositeList, SWT.NONE);
		label.setText("Command File List");
		listGridData = new GridData();
		listGridData.horizontalSpan = 1;
		listGridData.verticalSpan = 1;
		label.setLayoutData(listGridData);
		commandList = new List(compositeList, SWT.SINGLE | SWT.BORDER
				| SWT.V_SCROLL | SWT.H_SCROLL);

		data = new GridData(GridData.VERTICAL_ALIGN_BEGINNING
				| GridData.HORIZONTAL_ALIGN_BEGINNING);
		data.horizontalSpan = 1; // Xp
		data.verticalSpan = 10; // Xp
		data.widthHint = LIST_WIDTHHINT;
		data.heightHint = commandList.getItemHeight()
				* COMMAND_LIST_ITEM_HEIGHT;
		commandList.setLayoutData(data);

		monitorResetButton = new Button(compositeMonitor, SWT.NULL);
		monitorResetButton.setText("Monitor reset");
		monitorResetButton.setLayoutData(new GridData());

		moniterText = new Text(compositeMonitor, SWT.MULTI | SWT.BORDER
				| SWT.V_SCROLL | SWT.WRAP);
		moniterText.setText("");
		gridData = new GridData(GridData.FILL_HORIZONTAL);
		gridData.horizontalSpan = 1;
		gridData.widthHint = MONITOR_TEXT_WIDTH_HINT;
		gridData.heightHint = MONITOR_TEXT_HEIGHT_HINT;

		moniterText.setLayoutData(gridData);

		refreshButton = new Button(compositeButton, SWT.NONE);
		refreshButton.setText(" Refresh");
		refreshButton.setSize(BUTTON_WIDTH, BUTTON_HEIGHT);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		refreshButton.setLayoutData(gridData);

		sortButton = new Button(compositeButton, SWT.NONE);
		sortButton.setText(" Sort    ");
		sortButton.setSize(BUTTON_WIDTH, BUTTON_HEIGHT);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		sortButton.setLayoutData(gridData);

		cancelButton = new Button(compositeButton, SWT.NONE);

		cancelButton.setSize(BUTTON_WIDTH, BUTTON_HEIGHT);
		cancelButton.setText(" Cancel ");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		cancelButton.setLayoutData(gridData);

		setButton = new Button(compositeButton, SWT.NONE);

		setButton.setSize(BUTTON_WIDTH, BUTTON_HEIGHT);
		setButton.setText(" Set     ");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		setButton.setLayoutData(gridData);

		assignmentDateButton = new Button(compositeDateText, SWT.RADIO);
		assignmentDateButton.setText("Assignment Date");
		assignmentDateButton.setSelection(true);
		assignmentDateButton.setLayoutData(new GridData());

		assignmentYearText = new Text(compositeDateText, SWT.BORDER);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = 40;
		assignmentYearText.setLayoutData(gridData);

		assignmentMonthText = new Text(compositeDateText, SWT.BORDER);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = 20;
		assignmentMonthText.setLayoutData(gridData);

		label = new Label(compositeDateText, SWT.NONE);
		label.setText("/");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		assignmentDateText = new Text(compositeDateText, SWT.BORDER);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = 20;
		assignmentDateText.setLayoutData(gridData);

		assignmentDateHourCombo = new Combo(compositeDateText, SWT.READ_ONLY);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		// gridData.widthHint = 20;
		assignmentDateHourCombo.setLayoutData(gridData);
		setHourCombo(assignmentDateHourCombo);
		assignmentDateHourCombo.select(0);

		label = new Label(compositeDateText, SWT.NONE);
		label.setText(":");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		assignmentDateMinuteCombo = new Combo(compositeDateText, SWT.READ_ONLY);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		// gridData.widthHint = 20;
		assignmentDateMinuteCombo.setLayoutData(gridData);
		setMinuteCombo(assignmentDateMinuteCombo);
		assignmentDateMinuteCombo.select(0);

		dayCheckButton = new Button(compositeDateText, SWT.RADIO);
		dayCheckButton.setText("Day of Month");

		dayOfMonthCombo = new Combo(compositeDateText, SWT.READ_ONLY);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		// gridData.widthHint = 20;
		dayOfMonthCombo.setLayoutData(gridData);
		setDayCombo(dayOfMonthCombo);
		dayOfMonthCombo.select(0);

		/* Dummy column */
		label = new Label(compositeDateText, SWT.NONE);
		label.setText("");
		GridData gridData2 = new GridData();
		gridData2.horizontalSpan = HORIZONTAL_SPAN3;
		gridData2.verticalSpan = 1;
		label.setLayoutData(gridData2);

		dayOfMonthHourCombo = new Combo(compositeDateText, SWT.READ_ONLY);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		// gridData.widthHint = 20;
		dayOfMonthHourCombo.setLayoutData(gridData);
		setHourCombo(dayOfMonthHourCombo);
		dayOfMonthHourCombo.select(0);

		label = new Label(compositeDateText, SWT.NONE);
		label.setText(":");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		dayOfMonthMinuteCombo = new Combo(compositeDateText, SWT.READ_ONLY);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		// gridData.widthHint = 20;
		dayOfMonthMinuteCombo.setLayoutData(gridData);
		setMinuteCombo(dayOfMonthMinuteCombo);
		dayOfMonthMinuteCombo.select(0);

		dayOfWeekCheckButton = new Button(compositeDateText, SWT.RADIO);
		dayOfWeekCheckButton.setText("Day of Week");

		dayOfWeekCombo = new Combo(compositeDateText, SWT.READ_ONLY);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		// gridData.widthHint = 20;
		dayOfWeekCombo.setLayoutData(gridData);
		setWeekCombo(dayOfWeekCombo);
		dayOfWeekCombo.select(0);

		/* Dummy column */
		label = new Label(compositeDateText, SWT.NONE);
		label.setText("");
		GridData gridData3 = new GridData();
		gridData3.horizontalSpan = HORIZONTAL_SPAN3;
		gridData3.verticalSpan = 1;
		label.setLayoutData(gridData3);

		dayOfWeekHourCombo = new Combo(compositeDateText, SWT.READ_ONLY);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		// gridData.widthHint = 20;
		dayOfWeekHourCombo.setLayoutData(gridData);
		setHourCombo(dayOfWeekHourCombo);
		dayOfWeekHourCombo.select(0);

		label = new Label(compositeDateText, SWT.NONE);
		label.setText(":");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		dayOfWeekMinuteCombo = new Combo(compositeDateText, SWT.READ_ONLY);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		// gridData.widthHint = 20;
		dayOfWeekMinuteCombo.setLayoutData(gridData);
		setMinuteCombo(dayOfWeekMinuteCombo);
		dayOfWeekMinuteCombo.select(0);

		CalendarComposite calendarComposite = new CalendarComposite();
		calendarComposite.setYearText(assignmentYearText);
		calendarComposite.setMonthText(assignmentMonthText);
		calendarComposite.setDateText(assignmentDateText);

		calendarComposite.setDayOfMonthCombo(dayOfMonthCombo);
		calendarComposite.setDayOfWeekCombo(dayOfWeekCombo);

		calendarComposite.createCalendarView(compositeCalendar);

		assignmentYearText.setText(calendarComposite.getCalendarTable()
				.getTodaysYY());
		assignmentMonthText.setText(calendarComposite.getCalendarTable()
				.getTodaysMM());
		assignmentDateText.setText(calendarComposite.getCalendarTable()
				.getTodaysDD());

		/*
		 * Scroll compositeZbg
		 */
		scrollComposite.setContent(baseComposite);
		scrollComposite.setMinSize(SCROLL_COMPOSITE_SIZE[0],
				SCROLL_COMPOSITE_SIZE[1]);
		scrollComposite.setExpandHorizontal(true);
		scrollComposite.setExpandVertical(true);

		/*
		 * XV{^Listener
		 */
		refreshButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {
				logger = Logger.getLogger(this.getClass().getName());

				refreshButton.setEnabled(false);
				getTaskSchedule();
				refreshButton.setEnabled(true);
			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});

		/*
		 * XPW[Zbg{^Listener
		 */
		setButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {
				setButton.setEnabled(false);

				getSelectDate();

				setTaskSchedule();
				getTaskSchedule();
				setButton.setEnabled(true);

				startTimer();
			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});

		/*
		 * XPW[LZ{^Listener
		 */
		cancelButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {
				cancelButton.setEnabled(false);

				int selectListIndex = scheduleList.getSelectionIndex();

				if (selectListIndex >= 0) {
					CommandTaskScheduleInfo taskInfo = (CommandTaskScheduleInfo) taskScheduleSortList
							.get(selectListIndex);

					if (taskInfo != null) {
						cancelTaskSchedule(taskInfo);
						getTaskSchedule();
					}
				}

				cancelButton.setEnabled(true);
			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});

		/*
		 * XPW[\[g{^Listener
		 */
		sortButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {
				sortButton.setEnabled(false);

				/* \[g] */
				if (isSortDirection) {
					isSortDirection = false;
				} else {
					isSortDirection = true;
				}

				getTaskSchedule();
				sortButton.setEnabled(true);
			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});

		commandList.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent event) {

				int index = commandList.getSelectionIndex();
				if (index < 0) {
					return;
				}
				// commandList.select(index);
				System.out.println("Command " + commandList.getItem(index));
				commandFileName = commandList.getItem(index);

			}
		});

		monitorResetButton.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				moniterText.setText("");

			}
		});

		getTaskSchedule();

		setCommandList();

	}

	private void setCommandList() {
		File fleDir = new File(SSH2Preference.RESOURCE_SSH2_DIR + target + "/"
				+ SSH2Preference.COMMAND_DIR + "/");
		File[] fileList = fleDir.listFiles();
		if (fileList != null) {
			for (int fileCount = 0; fileCount < fileList.length; fileCount++) {
				if (!fileList[fileCount].isDirectory()) {

					commandList.add(fileList[fileCount].getName());
				}
			}
		}
	}

	/*
	 * Hour Combo Boxݒ肵܂B
	 * 
	 */
	private void setHourCombo(Combo combo) {
		for (int i = 0; i < 24; i++) {
			String work = Integer.toString(i);

			if (work.length() == 1) {
				work = "0" + work;
			}

			combo.add(work);
		}
	}

	/*
	 * Minute Combo Boxݒ肵܂B
	 * 
	 * @param combo Combo
	 */
	private void setMinuteCombo(Combo combo) {
		for (int i = 0; i < 60; i++) {
			String work = Integer.toString(i);

			if (work.length() == 1) {
				work = "0" + work;
			}

			combo.add(work);
		}
	}

	private void setDayCombo(Combo combo) {
		for (int i = 1; i <= 31; i++) {
			String work = Integer.toString(i);

			if (work.length() == 1) {
				work = "0" + work;
			}

			combo.add(work);
		}
	}

	private void setWeekCombo(Combo combo) {
		for (int i = 0; i < WEEK_STR_ARRY.length; i++) {
			combo.add(WEEK_STR_ARRY[i]);
		}
	}

	/*
	 * ^XNXPW[[h܂B
	 * 
	 */
	private void getTaskSchedule() {
		scheduleList.removeAll();
		taskScheduleSortList.clear();

		Map taskSchduleList = CommandTaskScheduleControl.getInstance()
				.getTaskSchedule();

		int count = 0;

		for (Iterator it = taskSchduleList.keySet().iterator(); it.hasNext();) {
			String keyId = (String) it.next();

			CommandTaskScheduleInfo info = (CommandTaskScheduleInfo) taskSchduleList
					.get(keyId);

			taskScheduleSortList.add(count, info);
			count++;
		}

		/*
		 * ^XNXPW[List\[g
		 */
		Collections.sort(taskScheduleSortList, new Comparator() {
			public int compare(Object o1, Object o2) {
				String startData = ((CommandTaskScheduleInfo) o1).getTaskID();
				String startDate2 = ((CommandTaskScheduleInfo) o2).getTaskID();

				if (isSortDirection) {
					return startDate2.compareTo(startData);
				}

				return startData.compareTo(startDate2);
			}
		});

		for (int i = 0; i < taskScheduleSortList.size(); i++) {
			CommandTaskScheduleInfo info = (CommandTaskScheduleInfo) taskScheduleSortList
					.get(i);
			String message = info.getTaskID();
			scheduleList.add(message);
		}
	}

	private String getDateStr(int dateData) {

		String work = Integer.toString(dateData);

		if (work.length() == 1) {
			work = "0" + work;
		}

		return work;

	}

	/*
	 * ^XNXPW[Zbg܂B
	 */
	private void setTaskSchedule() {

		if (commandFileName == null || commandFileName.equals("")) {
			MessageDialog.openError(getSite().getShell(), "Error",
					"Please select command file ");

			return;
		}

		if (assignmentDateButton.getSelection()) {

			getSelectDate();

			Map taskSchduleList = CommandTaskScheduleControl.getInstance()
					.getTaskSchedule();

			for (Iterator it = taskSchduleList.keySet().iterator(); it
					.hasNext();) {
				String keyId = (String) it.next();

				CommandTaskScheduleInfo info = (CommandTaskScheduleInfo) taskSchduleList
						.get(keyId);

				if (info.getTaskStartDate() != null) {
					if (dateformat.format(setStartDate).equals(
							dateformat.format(info.getTaskStartDate()))) {
						MessageDialog.openError(getSite().getShell(), "Error",
								"Already Start Date "
										+ dateformat.format(setStartDate)
										+ "  !");

						return;
					}
				}
			}

			String message = target + " : " + dateformat.format(setStartDate)
					+ " : " + commandFileName;

			CommandTaskScheduleControl.getInstance().setTaskSchedule(message,
					target, commandFileName, setStartDate);
		} else if (dayCheckButton.getSelection()) {

			int selectDayComboIndex = dayOfMonthCombo.getSelectionIndex();

			if (selectDayComboIndex >= 0) {

				int dayOfMonth = 0;
				int dayOfMonthHour = 0;
				int dayOfMonthMinute = 0;
				dayOfMonth = Integer.parseInt(dayOfMonthCombo.getText());
				dayOfMonthHour = Integer
						.parseInt(dayOfMonthHourCombo.getText());
				dayOfMonthMinute = Integer.parseInt(dayOfMonthMinuteCombo
						.getText());

				String message = target + " : Day Of Month " + dayOfMonth + " "
						+ getDateStr(dayOfMonthHour) + ":"
						+ getDateStr(dayOfMonthMinute) + " : "
						+ commandFileName;

				CommandTaskScheduleControl.getInstance().setTaskSchedule(
						message, target, commandFileName, dayOfMonth, 0,
						dayOfMonthHour, dayOfMonthMinute);

			}
		} else if (dayOfWeekCheckButton.getSelection()) {

			int selectDayOfWeekComboIndex = dayOfWeekCombo.getSelectionIndex();

			if (selectDayOfWeekComboIndex >= 0) {

				int dayOfWeek = 0;
				int dayOfWeekHour = 0;
				int dayOfWeekMinute = 0;
				dayOfWeek = selectDayOfWeekComboIndex + 1;
				dayOfWeekHour = Integer.parseInt(dayOfWeekHourCombo.getText());
				dayOfWeekMinute = Integer.parseInt(dayOfWeekMinuteCombo
						.getText());

				String message = target + " : Day Of Week "
						+ WEEK_STR_ARRY[dayOfWeek - 1] + "  "
						+ getDateStr(dayOfWeekHour) + ":"
						+ getDateStr(dayOfWeekMinute) + " : " + commandFileName;

				CommandTaskScheduleControl.getInstance().setTaskSchedule(
						message, target, commandFileName, 0, dayOfWeek,
						dayOfWeekHour, dayOfWeekMinute);

			}

		}

	}

	private void getSelectDate() {
		int indexStartHH = assignmentDateHourCombo.getSelectionIndex();
		int indexStartMin = assignmentDateMinuteCombo.getSelectionIndex();

		int startYY = 0;

		try {
			startYY = Integer.parseInt(assignmentYearText.getText());
		} catch (NumberFormatException e) {
			MessageDialog.openError(getSite().getShell(), "Error",
					"Illegal Date " + " !");
			assignmentYearText.setFocus();

			return;
		}

		int startMM = 0;

		try {
			startMM = Integer.parseInt(assignmentMonthText.getText());
		} catch (NumberFormatException e) {
			MessageDialog.openError(getSite().getShell(), "Error",
					"Illegal Date " + " !");
			assignmentMonthText.setFocus();

			return;
		}

		int startDD = 0;

		try {
			startDD = Integer.parseInt(assignmentDateText.getText());
		} catch (NumberFormatException e) {
			MessageDialog.openError(getSite().getShell(), "Error",
					"Illegal Date " + " !");
			assignmentDateText.setFocus();

			return;
		}

		int startHH = 0;

		try {
			startHH = Integer.parseInt(assignmentDateHourCombo
					.getItem(indexStartHH));
		} catch (NumberFormatException e) {
			MessageDialog.openError(getSite().getShell(), "Error",
					"Illegal Date " + " !");
			assignmentDateHourCombo.setFocus();

			return;
		}

		int startMIN = 0;

		try {
			startMIN = Integer.parseInt(assignmentDateMinuteCombo
					.getItem(indexStartMin));
		} catch (NumberFormatException e) {
			MessageDialog.openError(getSite().getShell(), "Error",
					"Illegal Date " + " !");
			assignmentDateMinuteCombo.setFocus();

			return;
		}

		/* Jn */
		Calendar cal = Calendar.getInstance();
		cal.set(startYY, startMM - 1, startDD, startHH, startMIN, 0);
		setStartDate = cal.getTime();

	}

	/*
	 * ^XNXPW[LZ܂B
	 * 
	 */
	private void cancelTaskSchedule(CommandTaskScheduleInfo taskInfo) {

		// Timer Cancel
		if (taskInfo != null) {
			CommandTaskScheduleControl.getInstance().cancelTaskSchedule(
					taskInfo);
		}
	}

	private void startTimer() {

		EditorSSHCommandTimerProcessor.getInstance().setDisplay(display);
		EditorSSHCommandTimerProcessor.getInstance().setMonitorText(
				getEditorSite(), moniterText, null);
		timerProcessor = EditorSSHCommandTimerProcessor.getInstance();
		display.timerExec(MONITOR_TIMER, timerProcessor);
	}

	/**
	 * tH[JXZbgꂽ̏łB
	 */
	public void setFocus() {
	}

	/**
	 * Xe[^XC\Zbg܂B
	 * 
	 */
	protected void setStatusLine() {

	}

}
