/*
 * Created on 2006/12/02
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 */
package netwatcher.ssh2.gui.editor;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;
import java.util.regex.Pattern;

import netjfwatcher.snmpmanager.model.ActionBuilderTrapReceiveTable;
import netwatcher.ssh2.info.Credentials;
import netwatcher.ssh2.info.NetWatcherUserInfo;
import netwatcher.ssh2.info.SSHNodeInfo;
import netwatcher.ssh2.info.SSHNodeInfoControl;
import netwatcher.ssh2.info.SessionInfo;
import netwatcher.ssh2.model.SSHCommandThread;
import netwatcher.ssh2.preference.SSH2Preference;
import netwatcher.ssh2.preference.SSH2UserAuthManager;

import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class EditorSSHCommandView extends AbstractEditorSSH {
	/** View^CgSuffix */
	public static final String TITLE_SUFFIX = " Node View";

	/** f[^\eLXg */
	public static final int DATE_TEXT_WIDTH = 250;

	/** eLXg\ */
	public static final int TEXT_WIDTH1 = 120;

	/* Scroll CompositeTCY */
	private static final int[] SCROLL_COMPOSITE_SIZE = { 800, 800 };

	/* Horizontal Span 4 */
	private static final int HORIZONTAL_SPAN4 = 4;

	/* Horizontal Span 6 */
	private static final int HORIZONTAL_SPAN6 = 6;

	/* R}hj^[\^C}[ */
	private static final int MONITOR_TIMER = 1000;

	private EditorSSHCommandTimerProcessor timerProcessor;

	/* Display */
	private Display display;

	private Button commandResetButton;

	private Button commandLoadButton;

	private Button commandSaveButton;

	private Text commandText;

	private Text moniterText;

	private Button commandButton;

	private Button monitorResetButton;

	private String target;

	private File commandFile;

	private String selectFileName;

	/* Logging */
	private static Logger logger;

	public EditorSSHCommandView() {
		logger = Logger.getLogger(this.getClass().getName());

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.ISaveablePart#isSaveAsAllowed()
	 */
	public boolean isSaveAsAllowed() {
		return false;
	}

	/**
	 * EditorEBhE𐶐܂B
	 * 
	 * @param parent
	 *            Composite
	 */
	public void createPartControl(Composite parent) {

		display = parent.getDisplay();

		/* ͐ݒlm[hĎ擾 */
		EditorInputSSHNodeView nodeViewEditorInput = (EditorInputSSHNodeView) getEditorInput();

		commandFile = nodeViewEditorInput.getFile();
		target = nodeViewEditorInput.getTarget();

		/*
		 * ViewCAEg
		 */
		ScrolledComposite scrollComposite = new ScrolledComposite(parent,
				SWT.H_SCROLL | SWT.V_SCROLL);

		GridLayout layout = new GridLayout(1, false);
		scrollComposite.setLayout(layout);

		GridData gridData = null;

		GridLayout gridLayout0 = new GridLayout(1, true);
		Composite composite0 = new Composite(scrollComposite, SWT.NONE);
		composite0.setLayout(gridLayout0);
		composite0.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_FILL
				| GridData.VERTICAL_ALIGN_FILL));

		GridLayout gridLayout = new GridLayout(1, false);
		Composite composite1 = new Composite(composite0, SWT.NULL);
		composite1.setLayout(gridLayout);
		composite1.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_FILL));
		gridData = new GridData();

		Label label;

		GridLayout gridLayout2 = new GridLayout(HORIZONTAL_SPAN6, true);
		Composite composite2 = new Composite(composite0, SWT.NONE);
		composite2.setLayoutData(new GridData(GridData.BEGINNING));

		composite2.setLayout(gridLayout2);

		commandResetButton = new Button(composite2, SWT.NULL);
		commandResetButton.setText("Command reset");
		GridData gd = new GridData();
		gd.horizontalSpan = 1;
		commandResetButton.setLayoutData(gd);

		commandLoadButton = new Button(composite2, SWT.NULL);
		commandLoadButton.setText("Command load");
		gd = new GridData();
		gd.horizontalSpan = 1;
		commandLoadButton.setLayoutData(gd);

		commandSaveButton = new Button(composite2, SWT.NULL);
		commandSaveButton.setText("Command save");
		gd = new GridData();
		gd.horizontalSpan = 1;
		commandSaveButton.setLayoutData(gd);

		/* Dummy column */
		label = new Label(composite2, SWT.NONE);
		label.setText("");
		GridData gridData2 = new GridData();
		gridData2.horizontalSpan = 3;
		gridData2.verticalSpan = 1;
		label.setLayoutData(gridData2);

		commandText = new Text(composite2, SWT.MULTI | SWT.BORDER
				| SWT.V_SCROLL | SWT.WRAP);
		commandText.setText("");
		gridData = new GridData(GridData.FILL_HORIZONTAL);
		gridData.horizontalSpan = HORIZONTAL_SPAN6;
		// gridData.verticalSpan = 7;
		gridData.widthHint = 600;
		gridData.heightHint = 100;

		gridData.grabExcessHorizontalSpace = true;
		gridData.grabExcessVerticalSpace = true;

		commandText.setLayoutData(gridData);

		commandButton = new Button(composite2, SWT.NULL);
		commandButton.setText("Command exec");
		gd = new GridData();
		gd.horizontalSpan = 1;
		commandButton.setLayoutData(gd);

		monitorResetButton = new Button(composite2, SWT.NULL);
		monitorResetButton.setText("Monitor reset");
		gd = new GridData();
		gd.horizontalSpan = 1;
		monitorResetButton.setLayoutData(gd);

		/* Dummy column */
		label = new Label(composite2, SWT.NONE);
		label.setText("");
		gridData2 = new GridData();
		gridData2.horizontalSpan = HORIZONTAL_SPAN4;
		gridData2.verticalSpan = 1;
		label.setLayoutData(gridData2);

		moniterText = new Text(composite2, SWT.MULTI | SWT.BORDER
				| SWT.V_SCROLL | SWT.WRAP);
		moniterText.setText("");
		gridData = new GridData(GridData.FILL_HORIZONTAL);
		gridData.horizontalSpan = HORIZONTAL_SPAN6;
		// gridData.verticalSpan = 4;
		// gridData.widthHint = 200;
		gridData.widthHint = 600;
		gridData.heightHint = 400;

		moniterText.setLayoutData(gridData);

		scrollComposite.setContent(composite0);
		scrollComposite.setMinSize(SCROLL_COMPOSITE_SIZE[0],
				SCROLL_COMPOSITE_SIZE[1]);
		scrollComposite.setExpandHorizontal(true);
		scrollComposite.setExpandVertical(true);

		if (commandFile != null) {
			try {
				parseCommandFile(commandFile.getPath());
			} catch (IOException e) {
				logger.warning("IOException : " + e.getMessage());
			}
		} else {
			commandLoadButton.setEnabled(false);
		}
		setSelectionListener();
	}

	private void setSelectionListener() {
		commandResetButton.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				commandText.setText("");

			}
		});
		commandLoadButton.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				if (commandFile != null) {
					commandText.setText("");
					try {
						parseCommandFile(commandFile.getPath());
					} catch (IOException e2) {
						MessageDialog.openError(getSite().getShell(), "Error",
								"IOException " + e2.getMessage() + " "
										+ commandFile.getPath());
						return;
					}
				}

			}
		});

		commandSaveButton.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {

				String commandDirPath = SSH2Preference.RESOURCE_SSH2_DIR
						+ target + "/" + SSH2Preference.COMMAND_DIR;
				File commandDir = new File(commandDirPath);
				if (!commandDir.exists()) {
					if (!commandDir.mkdirs()) {
						MessageDialog.openError(getEditorSite().getShell(),
								"Error", "Abrot mkdir."
										+ System.getProperty("line.separator")
										+ commandDir);
						return;
					}
				}

				Display.getDefault().syncExec(new Runnable() {
					public void run() {
						FileDialog openDialog = new FileDialog(getEditorSite()
								.getShell(), SWT.OPEN);
						openDialog
								.setFilterPath(SSH2Preference.RESOURCE_SSH2_DIR
										+ target + "/"
										+ SSH2Preference.COMMAND_DIR + "/");
						selectFileName = openDialog.open();

					}
				});

				if (selectFileName == null || selectFileName.equals("")) {
					return;
				}
				File selectCommandDir = new File(
						SSH2Preference.RESOURCE_SSH2_DIR
								+ SSH2Preference.COMMAND_DIR + "/");
				if (!selectCommandDir.exists()) {

					if (!MessageDialog.openConfirm(getEditorSite().getShell(),
							"Confirmation", " does not exsit."
									+ System.getProperty("line.separator")
									+ "Are you sure you want to create it?")) {
						return;
					}

					if (!selectCommandDir.mkdirs()) {
						MessageDialog.openError(getEditorSite().getShell(),
								"Error", "Abrot mkdir."
										+ System.getProperty("line.separator")
										+ selectCommandDir);
						return;
					}
				}

				File selectCommandFile = new File(selectFileName);
				if (selectCommandFile.exists()) {
					if (!MessageDialog
							.openConfirm(
									getEditorSite().getShell(),
									"Confirmation",
									selectCommandFile
											+ " has already existed."
											+ System
													.getProperty("line.separator")
											+ "Are you sure you want to over write it?")) {
						return;
					}
				}
				FileWriter fileWriter = null;
				BufferedWriter bufferedWriter = null;
				boolean ok = true;
				try {

					if (selectCommandFile == null) {
						return;
					}

					fileWriter = new FileWriter(selectCommandFile);
					bufferedWriter = new BufferedWriter(fileWriter);

					String commandString = commandText.getText();

					Pattern pattern;
					String[] commandStrArray;
					pattern = Pattern.compile(System
							.getProperty("line.separator"));
					commandStrArray = pattern.split(commandString);

					if (commandStrArray != null) {
						for (int i = 0; i < commandStrArray.length; i++) {
							bufferedWriter.write(commandStrArray[i]);
						}
					}

				} catch (Exception ee) {
					ok = false;
				} finally {

					if (bufferedWriter != null) {
						try {
							bufferedWriter.close();
						} catch (Exception e1) {
							logger.warning("Exception " + e1.getMessage());
						}
					}
					if (fileWriter != null) {
						try {
							fileWriter.close();
						} catch (Exception e2) {
							logger.warning("Exception " + e2.getMessage());
						}
					}
				}

				if (ok) {

					MessageDialog.openInformation(getEditorSite().getShell(),
							"Information", "Successfully saved."
									+ System.getProperty("line.separator")
									+ selectCommandFile);

				}

			}
		});

		monitorResetButton.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				moniterText.setText("");

			}
		});

		commandButton.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {

				commandButton.setEnabled(false);
				String commandString = commandText.getText();

				Pattern pattern;
				String[] commandStrArray;
				pattern = Pattern.compile(System.getProperty("line.separator"));
				commandStrArray = pattern.split(commandString);
				ArrayList commandList = new ArrayList();

				if (commandStrArray != null) {
					for (int i = 0; i < commandStrArray.length; i++) {
						System.out.println("command " + i + " : "
								+ commandStrArray[i]);
						commandList.add(commandStrArray[i]);
						// commandList.add("uname");
					}
				}

				System.out.println("target " + target);

				SSH2UserAuthManager manager = new SSH2UserAuthManager();

				try {
					manager
							.getSystemResourceFileParse(SSH2Preference.RESOURCE_SSH2_DIR
									+ target
									+ "/"
									+ SSH2Preference.USER_HOST_AUTH);
				} catch (IOException e1) {
					MessageDialog.openError(getSite().getShell(), "Error",
							"IOException " + e1.getMessage() + " "
									+ SSH2Preference.RESOURCE_SSH2_DIR + target
									+ "/" + SSH2Preference.USER_HOST_AUTH);
					commandButton.setEnabled(true);
					return;
				}
				String userHost = manager.getTarget();

				String user = "";
				String host = "";

				if (target.indexOf('@') > 0) {
					user = userHost.substring(0, userHost.indexOf('@'));
					host = userHost.substring(userHost.indexOf('@') + 1);
				}

				System.out.println("user " + user);
				System.out.println("host " + host);
				System.out.println("Password " + manager.getPassword());
				System.out.println("Passphrase " + manager.getPassphrase());

				setSSHInfo(user, host, manager.getPassword(), manager
						.getPassphrase());

				SSHCommandThread thread = new SSHCommandThread();
				thread.setUserHost(user, host);
				thread.setCommandList(commandList);
				thread.startSSHCommandThread();

				startTimer();
			}
		});
	}

	public void parseCommandFile(String file) throws IOException {

		BufferedReader buffReader = null;
		FileReader fi = null;
		try {
			fi = new FileReader(file);
			buffReader = new BufferedReader(fi);
		} catch (FileNotFoundException e1) {
			throw e1;
		}

		try {

			String message;

			while ((message = buffReader.readLine()) != null) {
				commandText.append(message
						+ System.getProperty("line.separator"));
			}

		} catch (FileNotFoundException e1) {
			e1.printStackTrace();
			throw e1;
		} catch (IOException e) {
			e.printStackTrace();
			throw e;
		} finally {
			if (buffReader != null) {
				try {
					buffReader.close();
				} catch (IOException e2) {
					logger.warning(e2.getMessage());
					e2.printStackTrace();
				}
			}

			if (fi != null) {
				try {
					fi.close();
				} catch (IOException e2) {
					logger.warning(e2.getMessage());
					e2.printStackTrace();
				}
			}
		}

	}

	public void setSSHInfo(String userName, String host, String password,
			String passphrase) {

		Credentials cred = new Credentials();
		cred.setPassphrase(passphrase);
		File id_dsa_keyFile = new File(SSH2Preference.RESOURCE_SSH2_DIR
				+ userName + "@" + host + "/" + SSH2Preference.ID_DSA_FILE);

		if (id_dsa_keyFile == null) {
			logger.warning("resources/id_dsa null");
		} else {
			if (!id_dsa_keyFile.exists()) {
				logger.warning("resources/id_dsa no exists");
			} else {
				cred.setIdDSAKeyFile(id_dsa_keyFile);

			}
		}

		File id_rsa_keyFile = new File(SSH2Preference.RESOURCE_SSH2_DIR
				+ userName + "@" + host + "/" + SSH2Preference.ID_RSA_FILE);

		ArrayList commandList = new ArrayList();

		if (id_rsa_keyFile == null) {
			logger.warning("resources/id_rsa null");
		} else {
			if (!id_rsa_keyFile.exists()) {
				logger.warning("resources/id_rsa no exists");
			} else {
				cred.setIdRSAKeyFile(id_rsa_keyFile);

			}

		}

		SessionInfo sessionInfo = new SessionInfo();
		sessionInfo.setHost(host);
		sessionInfo.setPort(SSH2Preference.SSH_PORT);
		sessionInfo.setUserName(userName);

		NetWatcherUserInfo userInfo = new NetWatcherUserInfo(password,
				passphrase);

		SSHNodeInfo sshNodeInfo = new SSHNodeInfo();
		sshNodeInfo.setCredentials(cred);
		sshNodeInfo.setSshUserInfo(userInfo);
		sshNodeInfo.setSessionInfo(sessionInfo);
		sshNodeInfo.setCommandList(commandList);

		SSHNodeInfoControl.getInstance().setSSHInfo(userName + "@" + host,
				sshNodeInfo);

	}

	/**
	 * Xe[^XC\Zbg܂B
	 */
	protected void setStatusLine() {
		/* Xe[^XC\L */
		statusLineManager = (SubStatusLineManager) (getEditorSite()
				.getActionBars().getStatusLineManager());
		statusLineManager.setVisible(true);
	}

	private void startTimer() {

		EditorSSHCommandTimerProcessor.getInstance().setDisplay(display);
		EditorSSHCommandTimerProcessor.getInstance().setMonitorText(
				getEditorSite(), moniterText, commandButton);
		timerProcessor = EditorSSHCommandTimerProcessor.getInstance();
		display.timerExec(MONITOR_TIMER, timerProcessor);
	}

	/*
	 * ( Javadoc)
	 * 
	 * @see java.lang.Object#finalize()
	 */
	protected void finalize() throws Throwable {
		super.finalize();

		/* TrapMf[^\^C}[~ */
		display.timerExec(ActionBuilderTrapReceiveTable.TIMER_STOP,
				timerProcessor);
	}

}
