/*
 * Created on 2006/12/02
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 */
package netwatcher.ssh2.gui.treenode;

import java.util.HashSet;
import java.util.Set;

import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

public class SSHNodeTreeGroup extends AbstractSSHUserHostTreeNode {
	/*
	 * serialVersionUID
	 */
	private static final long serialVersionUID = 1L;

	/*
	 * m[hTree groupɏm[hTreẽm[hi[HashSet
	 */
	private Set childrenHashSet = new HashSet();

	/**
	 * m[hTreeɂm[hO[vƂȂTreem[hNX CX^X𐶐܂B
	 * 
	 */
	public SSHNodeTreeGroup() {
	}

	/**
	 * m[hTreeɂm[hO[vƂȂTreem[hNX CX^XO[vw肵Đ܂B
	 * 
	 * @param name
	 *            m[hO[v
	 */
	public SSHNodeTreeGroup(String name) {
		setName(name);
	}

	/**
	 * m[hTree groupɏm[hTreẽm[hzŕԂ܂B
	 * 
	 * @return INodeTreeNode[]
	 */
	public ISSHUserHostTreeNode[] getChildren() {
		return (ISSHUserHostTreeNode[]) childrenHashSet
				.toArray(new ISSHUserHostTreeNode[childrenHashSet.size()]);
	}

	/**
	 * m[hTree groupIconC[WԂ܂B
	 * 
	 * @return m[hTree groupIconC[W
	 */
	public Image getImage() {
		return PlatformUI.getWorkbench().getSharedImages().getImage(
				ISharedImages.IMG_OBJ_FOLDER);
	}

	/**
	 * m[hTree groupɃm[hTreẽm[ho^܂B
	 * 
	 * @param toAdd
	 *            o^m[hTreẽm[h
	 */
	public void addChild(ISSHUserHostTreeNode toAdd) {
		childrenHashSet.add(toAdd);
		toAdd.setParent(this);
	}

	/**
	 * Childem[h݂邩Ԃ܂B
	 * 
	 * @return Childem[hݗL
	 */
	public boolean hasChildren() {
		return !childrenHashSet.isEmpty();
	}

	/**
	 * m[hTree groupɏw̃m[hTreẽm[h 폜܂B
	 * 
	 * @param toRemove
	 *            폜m[hTreẽm[h
	 */
	public void removeChild(ISSHUserHostTreeNode toRemove) {
		childrenHashSet.remove(toRemove);
	}

	/**
	 * SĂChildem[h폜܂B
	 * 
	 */
	public void removeChildAll() {
		childrenHashSet.clear();
	}
}
