/*
 * Created on 2006/11/25
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 */
package netwatcher.ssh2.gui.treeview;

import netwatcher.ssh2.gui.action.ActionBuilderEditorsPartClose;
import netwatcher.ssh2.gui.action.ActionBuilderNodeTree;
import netwatcher.ssh2.gui.treenode.ISSHUserHostTreeNode;
import netwatcher.ssh2.gui.treenode.SSHNodeTreeGroup;

import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.part.ViewPart;

/**
 * SSH2 Node Tree Viewɂ郁o[yу\bh钊ۃNXłB
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public abstract class AbstractSSHNodeTreeView extends ViewPart {
	/** Node TreeANV */
	protected ActionBuilderNodeTree actionNodeTree;

	/** Editor PartɊւANV */
	protected ActionBuilderEditorsPartClose actionBuilderEditorPart = new ActionBuilderEditorsPartClose();

	/** TreeViewer */
	protected TreeViewer nodeTreeViewer;

	/**
	 * Node Tree Viewɂ郁o[yу\bh钊ۃNX CX^X𐶐܂B
	 * 
	 */
	public AbstractSSHNodeTreeView() {
		// nothing
	}

	/**
	 * m[hTreeɊւANVԂ܂B
	 * 
	 * @return actionNodeTree m[hTreeɊւANV
	 */
	public ActionBuilderNodeTree getActionNodeTreeBuilder() {
		return actionNodeTree;
	}

	/**
	 * tH[JXZbgꂽ̏łB
	 * 
	 */
	public void setFocus() {
	}

	/**
	 * TreeViewerԂ܂B
	 * 
	 * @return nodeTreeViewer TreeViewer
	 */
	public TreeViewer getViewer() {
		return nodeTreeViewer;
	}

	/**
	 * r[ꂽƂɂ܂sꃁ\bhłB
	 * 
	 * @param parentComposite
	 *            Composite
	 */
	public void createPartControl(Composite parentComposite) {
		/* Tree Viewer𐶐 */
		nodeTreeViewer = new TreeViewer(parentComposite);
		nodeTreeViewer.setUseHashlookup(true);
		nodeTreeViewer.setContentProvider(new SSHNodeTreeViewContentProvider());
		nodeTreeViewer.setLabelProvider(new SSHNodeTreeViewLabelProvider());

		/* SorterZbg */
		nodeTreeViewer.setSorter(new SSHNodeTreeViewSorter());

		/* m[hTree Group̓f[^ƂăZbg */
		nodeTreeViewer.setInput(createInitialInput());
		nodeTreeViewer.expandAll();

		/* m[hTreeRoot擾 */
		ISSHUserHostTreeNode nodeTreeNode = (ISSHUserHostTreeNode) getViewer()
				.getInput();
		SSHNodeTreeGroup nodeTreeGroupRoot = nodeTreeNode.getParent();

		if (nodeTreeNode instanceof SSHNodeTreeGroup) {
			nodeTreeGroupRoot = (SSHNodeTreeGroup) nodeTreeNode;
		}

		/* m[hTreeANVZbg */
		actionNodeTree = new ActionBuilderNodeTree(this, nodeTreeViewer,
				parentComposite, nodeTreeGroupRoot);

		/* m[hTree View̑IXi[ݒ */
		setupNodeTreeViewListener();

		/* Contextj[ */
		createContextMenu();

		/* ANV̏ƂToolBarݒ */
		setToolBarActions();

		/* \ݒ */
		initShow();
	}

	/**
	 * ̃m[hTreer[̏͐ݒl𐶐܂B
	 * 
	 * @return topInputDataObject
	 */
	protected Object createInitialInput() {
		/* m[hTreełtopm[h𐶐 */
		SSHNodeTreeGroup topInputDataObject = new RootOfRootNodeTreeGroup();

		return topInputDataObject;
	}

	/**
	 * m[hTree View̏\̂߂Ƀf[^擾A\ \bhłB
	 * 
	 */
	abstract protected void initShow();

	/**
	 * m[hTree View̑IXi[ݒ肵܂B
	 * 
	 */
	protected void setupNodeTreeViewListener() {
		/*
		 * Node Tree ViewɃXi[o^ Xi[̏ƂẮA e[uViewɃtB[hꗗőIGg͒lƂĐݒ
		 * 
		 */
		nodeTreeViewer.addSelectionChangedListener(new SSHNodeTreeListener());
	}

	/**
	 * m[hTree View̃j[ݒ肷郁\bhłB
	 * 
	 */
	abstract protected void setToolBarActions();

	/**
	 * m[hTree ViewContextj[ݒ肷郁\bhłB
	 * 
	 */
	abstract protected void createContextMenu();

	/**
	 * m[hTreeɂTopm[ĥ߂̃NXłB
	 * 
	 * @author Yoshimasa Matsumoto
	 * @version 1.0
	 */
	protected static final class RootOfRootNodeTreeGroup extends
			SSHNodeTreeGroup {
		/**
		 * em[hԂ܂B
		 * 
		 * @return em[h
		 */
		public SSHNodeTreeGroup getParent() {
			return null;
		}

		/**
		 * qm[h폜܂B
		 * 
		 * @param toRemove
		 *            m[h
		 */
		public void removeChild(ISSHUserHostTreeNode toRemove) {
			// ROOT O[vȂ悤ɃI[o[Ch
		}
	}
}
