/*
 * Created on 2006/12/02
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 */
package netwatcher.ssh2.gui.treeview;

import java.util.logging.Logger;

import netwatcher.ssh2.gui.action.ActionBuilderNodeTree.ActionReloadNodeTree;
import netwatcher.ssh2.gui.action.ActionBuilderNodeTree.ActionSSH2CommandSchedule;
import netwatcher.ssh2.gui.action.ActionBuilderNodeTree.ActionSSH2CommandView;
import netwatcher.ssh2.gui.treenode.ISSHUserHostTreeNode;
import netwatcher.ssh2.gui.treenode.SSHNodeTree;
import netwatcher.ssh2.gui.treenode.SSHNodeTreeGroup;
import netwatcher.ssh2.preference.SSH2Preference;

import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchActionConstants;

public class SSHNodeTreeView extends AbstractSSHNodeTreeView {

	private static Logger logger = null;

	public SSHNodeTreeView() {
		logger = Logger.getLogger(this.getClass().getName());
	}

	protected void initShow() {
		((ActionReloadNodeTree) actionNodeTree.actionReloadNodeTreeDatabase())
				.setNodeTree();

	}

	/**
	 * ReLXgj[𐶐܂B
	 * 
	 */
	public void createContextMenu() {
		/* j[}l[W */
		MenuManager mm = new MenuManager();
		mm.setRemoveAllWhenShown(true);

		/* j[Xi[Zbg */
		mm.addMenuListener(new IMenuListener() {
			public void menuAboutToShow(IMenuManager manager) {
				fillContextMenu(manager);
			}
		});

		Menu menu = mm.createContextMenu(nodeTreeViewer.getControl());
		nodeTreeViewer.getControl().setMenu(menu);
		getSite().registerContextMenu(mm, nodeTreeViewer);
	}

	/**
	 * ANV̏ƂToolBarݒ肵܂B
	 * 
	 */
	protected void setToolBarActions() {
		/* ToolBarݒ */
		IToolBarManager toolBarManager = getViewSite().getActionBars()
				.getToolBarManager();

		/* m[hTreeēǍANV */
		toolBarManager.add(getActionNodeTreeBuilder()
				.actionReloadNodeTreeDatabase());
		toolBarManager.add(getActionNodeTreeBuilder()
				.actionSortNodeTreeDatabase());
		toolBarManager.add(actionBuilderEditorPart.actionCloseAllEditors());
	}

	/**
	 * j[o[ݒ肵܂B preWindowOpenɌĂ΂܂B m[hTreẽm[hIĂꍇƑIĂȂꍇ
	 * j[ς܂B
	 * 
	 * @param manager
	 *            IMenuManager
	 */
	protected void fillContextMenu(IMenuManager manager) {
		/* m[hTreeǂݍ݃ANVZbg */
		manager.add(new GroupMarker(IWorkbenchActionConstants.MB_ADDITIONS));

		/* m[hTreeēǂݍ */
		manager.add(getActionNodeTreeBuilder().actionReloadNodeTreeDatabase());

		/* m[hTree\[g */
		manager.add(getActionNodeTreeBuilder().actionSortNodeTreeDatabase());

		/*
		 * Treẽm[hIĂ邩`FbN
		 */
		if (nodeTreeViewer.getTree().getSelection() != null) {
			TreeItem[] treeItem = nodeTreeViewer.getTree().getSelection();

			if ((treeItem != null) && (treeItem.length > 0)) {
				for (int nodeTreeSelectNo = 0; nodeTreeSelectNo < treeItem.length; nodeTreeSelectNo++) {
					if (treeItem[nodeTreeSelectNo].getData() instanceof SSHNodeTreeGroup) {
						/* GroupI */
						if (!((SSHNodeTreeGroup) treeItem[nodeTreeSelectNo]
								.getData()).getName().equals(
								SSH2Preference.COMMAND_DIR)) {

							((ActionSSH2CommandView) actionNodeTree
									.actionOpenSSH2CommandView())
									.setSshNodeTree((ISSHUserHostTreeNode) treeItem[nodeTreeSelectNo]
											.getData());
							((ActionSSH2CommandSchedule) actionNodeTree
									.actionOpenSSH2CommandSchedule())
									.setSshNodeTree((ISSHUserHostTreeNode) treeItem[nodeTreeSelectNo]
											.getData());
							manager.add(actionNodeTree
									.actionOpenSSH2CommandView());
							manager.add(actionNodeTree
									.actionOpenSSH2CommandSchedule());
						} else {
							nodeTreeViewer.getTree().deselectAll();
						}
					} else if (treeItem[nodeTreeSelectNo].getData() instanceof SSHNodeTree) {

					} else {
						/* Groupłm[hłȂ */
						nodeTreeViewer.getTree().deselectAll();
					}
				}
			} else {
				/* TreeI */

			}
		}

	}

	/**
	 * m[hTree View̑IXi[ݒ肵܂B
	 * 
	 */
	protected void setupNodeTreeViewListener() {
		/*
		 * Node Tree ViewɃXi[o^ Xi[̏ƂẮA e[uViewɃtB[hꗗőIGg͒lƂĐݒ
		 * 
		 */
		nodeTreeViewer.addSelectionChangedListener(new SSHNodeTreeListener());
	}
}
