/*
 * Created on 2006/12/02
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 */
package netwatcher.ssh2.gui.treeview;

import netwatcher.ssh2.gui.treenode.SSHNodeTree;
import netwatcher.ssh2.gui.treenode.SSHNodeTreeGroup;
import netwatcher.ssh2.preference.SSH2Preference;

import org.eclipse.jface.viewers.ViewerSorter;

/**
 * m[hTree ViewrSorterɂm[hTreẽm[hcategory ̕ނI[o[ChĕނNXłB
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class SSHNodeTreeViewSorter extends ViewerSorter {
	/**
	 * m[hTreẽGg𕪗ނĕԂ܂B
	 * 
	 * @see org.eclipse.jface.viewers.ViewerSorter#category(java.lang.Object)
	 */
	public int category(Object element) {
		if (element instanceof SSHNodeTreeGroup) {
			return 1;
		}

		if (element instanceof SSHNodeTree) {

			String check1 = ((SSHNodeTree) element).getName();
			if (check1.equals(SSH2Preference.KNOWN_HOSTS_FILE)) {
				return 4;
			}

			return 2;
		}

		return 3;
	}
}
