/*
 * Created on 2006/11/22
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 */
package netwatcher.ssh2.model;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;

public class CommandFileParse {
	/* Logging */
	private static Logger logger = null;

	public CommandFileParse() {
		logger = Logger.getLogger(this.getClass().getName());
	}

	public ArrayList getCommandList(String file) throws FileNotFoundException {

		ArrayList commandList = new ArrayList();
		BufferedReader buffReader = null;
		FileReader fi = null;
		try {
			fi = new FileReader(file);
			buffReader = new BufferedReader(fi);
		} catch (FileNotFoundException e1) {
			e1.printStackTrace();
			throw e1;
		}

		try {

			String str;

			while ((str = buffReader.readLine()) != null) {
				commandList.add(str);
			}

		} catch (FileNotFoundException e1) {
			e1.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		} finally {
			if (buffReader != null) {
				try {
					buffReader.close();
				} catch (IOException e2) {
					logger.warning(e2.getMessage());
					e2.printStackTrace();
				}
			}

			if (fi != null) {
				try {
					fi.close();
				} catch (IOException e2) {
					logger.warning(e2.getMessage());
					e2.printStackTrace();
				}
			}
		}

		return commandList;
	}

}
