/*
 * Created on 2006/10/25
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 */
package netwatcher.ssh2.model;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public final class SSHCommandMessageQueue {
	/* L[郊Xg */
	private static List sshCommandMessageQueueList;

	private static final int LIMIT = 100;

	private SSHCommandMessageQueue() {
		sshCommandMessageQueueList = Collections
				.synchronizedList(new LinkedList());
	}

	public synchronized void pushSSHCommandMessage(
			final String sshCommandMessage) {

		if (sshCommandMessageQueueList.size() > LIMIT) {
			sshCommandMessageQueueList.remove(0);

		}
		sshCommandMessageQueueList.add(sshCommandMessage);
	}

	public synchronized String popPortScanInfo() {
		String sshCommandMessage = null;

		if (sshCommandMessageQueueList.size() > 0) {
			sshCommandMessage = (String) sshCommandMessageQueueList.get(0);
			sshCommandMessageQueueList.remove(0);
		}

		return sshCommandMessage;
	}

	/**
	 * ̃NX̃CX^XԂ܂B<BR>
	 * iNXێĂVOgEIuWFNg Ԃ܂j<BR>
	 * 
	 * @return VOgEIuWFNgƂĂ̂̃NX CX^X
	 */
	public static SSHCommandMessageQueue getInstance() {
		return SingletonResource.MESSAGE_QUEUE;
	}

	/**
	 * VOgEIuWFNgێNXłB<BR>
	 * 
	 */
	private static class SingletonResource {
		static final SSHCommandMessageQueue MESSAGE_QUEUE = new SSHCommandMessageQueue();
	}
}
