/*
 * Created on 2006/12/02
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 */
package netwatcher.ssh2.preference;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.logging.Logger;

import netjfwatcher.engine.resource.XMLOutputterFormat;

import org.jdom.Document;
import org.jdom.output.XMLOutputter;

public class SSH2UserAuthManagerOutputControl {
	/* MO */
	private static Logger logger;

	private SSH2UserAuthManagerOutputControl() {

	}

	/**
	 * wBufferedWriteryDocumentXML Fileɏo͂܂B
	 * 
	 * @param bufWriter
	 * @param dom
	 */
	public void outputXMLFile(BufferedWriter bufWriter, Document dom) {
		logger = Logger.getLogger(this.getClass().getName());

		/*
		 * qGgeGg2wAGgԂ̉s w͂ȂiXMLt@CŌXsĂ邽߁j
		 */

		// XMLOutputter outputter = new XMLOutputter(" ", true);
		XMLOutputter outputter = XMLOutputterFormat.getInstance()
				.getXMLOutputterFormat();

		// XMLOutputter outputter = new XMLOutputter();
		// outputter.setIndent(" ");
		FileWriter writer = null;

		try {
			outputter.output(dom, System.out);
			outputter.output(dom, bufWriter);
		} catch (IOException e1) {
			logger.warning(e1.getMessage());
			e1.printStackTrace();
		} finally {
			if (writer != null) {
				try {
					writer.close();
				} catch (IOException e2) {
					logger.warning(e2.getMessage());
					e2.printStackTrace();
				}
			}
		}
	}

	protected void saveResourceXMLInfo(String filePath, String target,
			String password, String passphrase) {
		// Document
		Document dom = null;

		// t@Co̓obt@
		BufferedWriter bufWriter = null;

		SSH2UserAuthManager manager = new SSH2UserAuthManager();

		dom = this.updateResource(manager, target, password, passphrase);
		bufWriter = manager.getResourceFileWriter(filePath);

		// XMLt@Co
		this.outputXMLFile(bufWriter, dom);

		if (bufWriter != null) {
			try {
				bufWriter.close();
			} catch (IOException e) {
				logger
						.warning("Abort close BufferedWriter for snmp resource : "
								+ e.getMessage());
				e.printStackTrace();
			}
		}

	}

	protected Document updateResource(SSH2UserAuthManager manager,
			String target, String password, String passphrase) {

		Document dom = manager.updateDocument(target, password, passphrase);
		return dom;
	}

	/**
	 * ̃NX̃CX^XԂ܂B<BR>
	 * iNXێĂVOgEIuWFNg Ԃ܂j<BR>
	 * 
	 * @return VOgEIuWFNgƂĂ̂̃NX CX^X
	 */
	public static SSH2UserAuthManagerOutputControl getInstance() {
		return SingletonResource.RESOURCE;
	}

	/**
	 * VOgEIuWFNgێNXłB<BR>
	 * 
	 */
	private static class SingletonResource {
		static final SSH2UserAuthManagerOutputControl RESOURCE = new SSH2UserAuthManagerOutputControl();
	}
}
