/*
 * Created on 2006/08/25
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 */
package netjfwatcher.macaddress.gui;

import java.util.logging.Logger;

import netjfwatcher.engine.view.editorpart.common.EditorInputNodeView;

import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;


/**
 * TEh\\Editor ViewOpenNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class MacAddressEditorViewOpenAction {
    /* MO */
    private static Logger logger = null;

    private MacAddressEditorViewOpenAction() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public void openSearchEditorView() {
        IWorkbenchPage activePage =
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();

        try {
            activePage.openEditor(
                new EditorInputNodeView("Mac Address Search", false),
                MacAddressSearchEditorView.class.getName());
        } catch (PartInitException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
        }
    }

    public void openNodeMacAddressEditorView() {
        IWorkbenchPage activePage =
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();

        try {
            activePage.openEditor(
                new EditorInputNodeView("Node Interface Mac", false),
                NodeMacAddressEditorView.class.getName());
        } catch (PartInitException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
        }
    }
    
    /**
     * ̃NX̃CX^XԂ܂B<BR>
     * iNXێĂVOgEIuWFNg
     * Ԃ܂j<BR>
     *
     * @return VOgEIuWFNgƂĂ̂̃NX
     * CX^X
     */
    public static MacAddressEditorViewOpenAction getInstance() {
        return SingletonResource.RESOURCE;
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonResource {
        static final MacAddressEditorViewOpenAction RESOURCE =
            new MacAddressEditorViewOpenAction();
    }
}
