/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.provision.command.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Logger;
import netjfwatcher.provision.command.core.LoggingProvision;
import netjfwatcher.provision.command.core.LoginAuthAbortException;
import netjfwatcher.provision.info.ProvisionInfo;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;

public class EngineFtp {
    private ProvisionInfo provisionInfo;
    private static Logger logger;

    public EngineFtp(ProvisionInfo provisionInfo) {
        logger = Logger.getLogger(this.getClass().getName());
        this.provisionInfo = provisionInfo;
    }

    public void putFile() throws LoginAuthAbortException, Exception {
        if (this.provisionInfo.getFtpSourceFile() == null || this.provisionInfo.getFtpStoreFile() == null) {
            return;
        }
        FileInputStream istream = null;
        FTPClient ftpclient = new FTPClient();
        try {
            try {
                ftpclient.connect(this.provisionInfo.getIpAddress());
                int reply = ftpclient.getReplyCode();
                if (!FTPReply.isPositiveCompletion((int)reply)) {
                    logger.warning("connect fail");
                    LoggingProvision.getInstance().writeLogFile(this.provisionInfo.getProvisionID(), this.provisionInfo.getIpAddress(), "connect fail");
                    throw new LoginAuthAbortException("connect fail");
                }
                if (!ftpclient.login(this.provisionInfo.getUserName(), this.provisionInfo.getPassword())) {
                    logger.warning("login fail");
                    LoggingProvision.getInstance().writeLogFile(this.provisionInfo.getProvisionID(), this.provisionInfo.getIpAddress(), "login fail");
                    throw new LoginAuthAbortException("login fail");
                }
                ftpclient.setFileType(2);
                istream = new FileInputStream(this.provisionInfo.getFtpSourceFile());
                ftpclient.storeFile(this.provisionInfo.getFtpStoreFile(), (InputStream)istream);
                logger.info("FTP source=" + this.provisionInfo.getFtpSourceFile() + " store=" + this.provisionInfo.getFtpStoreFile());
                LoggingProvision.getInstance().writeLogFile(this.provisionInfo.getProvisionID(), this.provisionInfo.getIpAddress(), "FTP source=" + this.provisionInfo.getFtpSourceFile() + " store=" + this.provisionInfo.getFtpStoreFile());
            }
            catch (Exception e) {
                logger.warning("Exception " + e.getMessage());
                LoggingProvision.getInstance().writeLogFile(this.provisionInfo.getProvisionID(), this.provisionInfo.getIpAddress(), "Exception " + e.getMessage());
                throw e;
            }
        }
        finally {
            if (istream != null) {
                try {
                    istream.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    logger.warning("Exception " + e.getMessage());
                }
            }
            if (ftpclient.isConnected()) {
                try {
                    ftpclient.logout();
                    ftpclient.disconnect();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    logger.warning("Exception " + e.getMessage());
                }
            }
        }
    }

    public void getDataFiles(String server, String username, String password, String folder, String destinationFolder, Calendar start, Calendar end) {
        try {
            FTPClient ftp = new FTPClient();
            ftp.connect(server);
            ftp.login(username, password);
            System.out.println("Connected to " + server + ".");
            System.out.print(ftp.getReplyString());
            ftp.changeWorkingDirectory(folder);
            FTPFile[] files = ftp.listFiles();
            System.out.println("Number of files in dir: " + files.length);
            DateFormat df = DateFormat.getDateInstance(3);
            int i = 0;
            while (i < files.length) {
                Date fileDate = files[i].getTimestamp().getTime();
                if (fileDate.compareTo(start.getTime()) >= 0 && fileDate.compareTo(end.getTime()) <= 0) {
                    System.out.print(df.format(files[i].getTimestamp().getTime()));
                    System.out.println("\t" + files[i].getName());
                    File file = new File(String.valueOf(destinationFolder) + File.separator + files[i].getName());
                    FileOutputStream fos = new FileOutputStream(file);
                    ftp.retrieveFile(files[i].getName(), (OutputStream)fos);
                    fos.close();
                    file.setLastModified(fileDate.getTime());
                }
                ++i;
            }
            ftp.logout();
            ftp.disconnect();
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.warning("Exception " + e.getMessage());
        }
    }
}

