/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.provision.command.core;

import java.io.InputStream;
import java.io.PrintStream;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.logging.Logger;
import netjfwatcher.provision.command.core.LoggingProvision;
import netjfwatcher.provision.command.core.LoginAuthAbortException;
import netjfwatcher.provision.command.core.ParserCommandFile;
import netjfwatcher.provision.info.ProvisionInfo;
import org.apache.commons.net.telnet.TelnetClient;

public class EngineTelnet {
    private TelnetClient telnet = new TelnetClient();
    private ProvisionInfo provisionInfo;
    private ParserCommandFile commandFile = new ParserCommandFile();
    private InputStream inStream;
    private PrintStream outStream;
    private static final String SEND = "[send]";
    private static final String RECEIVE = "[receive]";
    private char prompt = (char)36;
    private static Logger logger;
    private static final int WAIT_SLEEP_TIME = 5000;

    public EngineTelnet(ProvisionInfo provisionInfo) {
        logger = Logger.getLogger(this.getClass().getName());
        this.provisionInfo = provisionInfo;
    }

    public void start(boolean isTest, ArrayList testCommandList) throws LoginAuthAbortException, SocketTimeoutException, Exception {
        if (this.provisionInfo == null) {
            return;
        }
        String server = this.provisionInfo.getIpAddress();
        String user = this.provisionInfo.getUserName();
        String password = this.provisionInfo.getPassword();
        ArrayList commandList = null;
        try {
            commandList = isTest ? testCommandList : this.commandFile.parse(this.provisionInfo.getCommandFile());
            if (commandList == null) {
                return;
            }
            try {
                this.telnet.connect(server, 23);
                this.telnet.setSoTimeout(10000);
                this.inStream = this.telnet.getInputStream();
                this.outStream = new PrintStream(this.telnet.getOutputStream());
                logger.info("user " + user);
                logger.info("password " + password);
                logger.info("response " + this.readUntil("login: ", null, null));
                this.write(user);
                logger.info("response " + this.readUntil("Password: ", "login: ", "incorrect"));
                this.write(password);
                String response = this.readUntil(String.valueOf(this.prompt) + " ", "incorrect", null);
                logger.info("response " + response);
                if (response.equals("incorrect")) {
                    logger.warning("NG Response " + response);
                    LoggingProvision.getInstance().writeLogFile(this.provisionInfo.getProvisionID(), this.provisionInfo.getIpAddress(), "Abort login " + response);
                    throw new LoginAuthAbortException("login fail");
                }
                String rootPassword = this.provisionInfo.getSuPpassword();
                if (rootPassword != null && !rootPassword.equals("") && !this.loginSu(rootPassword)) {
                    throw new LoginAuthAbortException("su logins fail");
                }
                int i = 0;
                while (i < commandList.size()) {
                    String command = (String)commandList.get(i);
                    this.sendCommand(command);
                    ++i;
                }
            }
            catch (SocketTimeoutException e) {
                logger.warning(" SocketTimeoutException " + e.getMessage());
                LoggingProvision.getInstance().writeLogFile(this.provisionInfo.getProvisionID(), this.provisionInfo.getIpAddress(), "SocketTimeoutException " + e.getMessage());
                throw e;
            }
            catch (Exception e) {
                logger.warning(" Exception " + e.getMessage());
                LoggingProvision.getInstance().writeLogFile(this.provisionInfo.getProvisionID(), this.provisionInfo.getIpAddress(), "Exception " + e.getMessage());
                throw e;
            }
        }
        finally {
            if (this.inStream != null) {
                this.inStream.close();
                this.inStream = null;
            }
            if (this.outStream != null) {
                this.outStream.close();
                this.outStream = null;
            }
            this.disconnect();
        }
    }

    public boolean loginSu(String rootPassword) throws Exception {
        boolean isRoot = true;
        this.write("su");
        String response = this.readUntil("Password: ", "login: ", "incorrect");
        this.write(rootPassword);
        this.prompt = (char)35;
        response = this.readUntil(String.valueOf(this.prompt) + " ", "incorrect", null);
        if (response.indexOf(this.prompt) < 0) {
            isRoot = false;
            logger.warning("su login NG response " + response);
            LoggingProvision.getInstance().writeLogFile(this.provisionInfo.getProvisionID(), this.provisionInfo.getIpAddress(), "Abort su login " + response);
        }
        return isRoot;
    }

    private String readUntil(String expectPattern, String ngPattern1, String ngPattern2) throws SocketTimeoutException, Exception {
        char expectLastChar = expectPattern.charAt(expectPattern.length() - 1);
        char ng1LastChar = ' ';
        char ng2LastChar = ' ';
        if (ngPattern1 != null && ngPattern1.length() >= 1) {
            ng1LastChar = ngPattern1.charAt(ngPattern1.length() - 1);
        }
        if (ngPattern2 != null && ngPattern2.length() > 2) {
            ng2LastChar = ngPattern2.charAt(ngPattern2.length() - 1);
        }
        StringBuffer sb = new StringBuffer();
        char ch = '\u0000';
        if (this.inStream.available() != 0) {
            ch = (char)this.inStream.read();
        }
        try {
            while (true) {
                if (ch != '\u0000') {
                    sb.append(ch);
                    if (ch == expectLastChar || ch == ng1LastChar || ch == ng2LastChar) {
                        if (sb.toString().endsWith(expectPattern)) {
                            String string = expectPattern;
                            return string;
                        }
                        if (ngPattern1 != null && sb.toString().endsWith(ngPattern1)) {
                            String string = ngPattern1;
                            return string;
                        }
                        if (ngPattern2 != null && sb.toString().endsWith(ngPattern2)) {
                            String string = ngPattern2;
                            return string;
                        }
                    }
                }
                if (this.inStream.available() == 0) {
                    try {
                        Thread.sleep(5000L);
                        ch = '\u0000';
                    }
                    catch (InterruptedException e) {
                        logger.warning(e.getMessage());
                        e.printStackTrace();
                    }
                    if (this.inStream.available() != 0) continue;
                    throw new SocketTimeoutException("Available data length=0");
                }
                ch = (char)this.inStream.read();
            }
        }
        finally {
            LoggingProvision.getInstance().writeLogFile(this.provisionInfo.getProvisionID(), this.provisionInfo.getIpAddress(), RECEIVE + sb.toString());
        }
    }

    private void write(String value) throws Exception {
        this.outStream.println(value);
        this.outStream.flush();
        logger.info(value);
        LoggingProvision.getInstance().writeLogFile(this.provisionInfo.getProvisionID(), this.provisionInfo.getIpAddress(), SEND + value);
    }

    private String sendCommand(String command) throws Exception {
        this.write(command);
        return this.readUntil(String.valueOf(this.prompt) + " ", "login: ", "incorrect");
    }

    private void disconnect() {
        try {
            if (this.telnet.isConnected()) {
                this.telnet.disconnect();
            }
        }
        catch (Exception e) {
            logger.warning("Exception " + e.getMessage());
            LoggingProvision.getInstance().writeLogFile(this.provisionInfo.getProvisionID(), this.provisionInfo.getIpAddress(), "Exception" + e.getMessage());
            e.printStackTrace();
        }
    }
}

