/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.provision.command.schedule;

import java.net.SocketTimeoutException;
import java.util.logging.Logger;
import netjfwatcher.provision.command.core.EngineFtp;
import netjfwatcher.provision.command.core.EngineTelnet;
import netjfwatcher.provision.command.core.LoginAuthAbortException;
import netjfwatcher.provision.info.ProvisionInfo;
import netjfwatcher.provision.info.ProvisionInfoControl;
import netjfwatcher.provision.nodemaneger.list.ProvisionMessageQueue;

public class ProvisionCommandTask {
    private static Logger logger;
    private ProvisionInfo provisionInfo;

    public ProvisionCommandTask(ProvisionInfo provisionInfo) {
        logger = Logger.getLogger(this.getClass().getName());
        this.provisionInfo = provisionInfo;
    }

    public void executeCommand() {
        if (!this.provisionInfo.getFtpSourceFile().equals("") && !this.provisionInfo.getFtpStoreFile().equals("")) {
            try {
                EngineFtp testFtp = new EngineFtp(this.provisionInfo);
                testFtp.putFile();
            }
            catch (LoginAuthAbortException loginAuthAbortException) {
                this.provisionInfo.setCommandResult("login fail");
            }
            catch (Exception e) {
                this.provisionInfo.setCommandResult("abort (" + e.getMessage() + ")");
            }
        }
        if (!this.provisionInfo.getCommandFile().equals("")) {
            EngineTelnet telnet = new EngineTelnet(this.provisionInfo);
            try {
                telnet.start(false, null);
            }
            catch (LoginAuthAbortException loginAuthAbortException) {
                this.provisionInfo.setCommandResult("login fail");
            }
            catch (SocketTimeoutException e) {
                this.provisionInfo.setCommandResult("abort (" + e.getMessage() + ")");
            }
            catch (Exception e) {
                this.provisionInfo.setCommandResult("abort (" + e.getMessage() + ")");
            }
        }
        if (this.provisionInfo.getCommandResult().equals("waiting...")) {
            this.provisionInfo.setCommandResult("complete");
        }
        ProvisionInfoControl.getInstance().setProvisionInfo(this.provisionInfo.getProvisionID(), this.provisionInfo);
        ProvisionMessageQueue.getInstance().pushProvisionMessage(this.provisionInfo.getIpAddress());
    }
}

