/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.provision.command.schedule;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;
import netjfwatcher.provision.command.schedule.ProvisionCommandTaskScheduleInfo;
import netjfwatcher.provision.command.schedule.ProvisionCommandTimerTask;
import netjfwatcher.provision.info.ProvisionInfo;
import netjfwatcher.provision.info.ProvisionInfoControl;
import netjfwatcher.provision.nodemaneger.list.ProvisionMessageQueue;

public final class ProvisionCommandTaskScheduleControl {
    private static Logger logger = null;
    private Map taskScheduleMap = Collections.synchronizedMap(new HashMap());

    private ProvisionCommandTaskScheduleControl() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public synchronized void setTaskSchedule(ProvisionInfo provisionInfo, Date startDate) {
        Timer taskTimer = new Timer();
        ProvisionCommandTimerTask threadStartTask = new ProvisionCommandTimerTask(provisionInfo);
        taskTimer.schedule((TimerTask)threadStartTask, startDate);
        ProvisionCommandTaskScheduleInfo taskScheduleInfo = new ProvisionCommandTaskScheduleInfo();
        taskScheduleInfo.setTaskStartDate(startDate);
        taskScheduleInfo.setTaskTimer(taskTimer);
        taskScheduleInfo.setProvisionInfo(provisionInfo);
        this.taskScheduleMap.put(provisionInfo.getProvisionID(), taskScheduleInfo);
    }

    public synchronized void cancelTaskSchedule(ProvisionCommandTaskScheduleInfo taskScheduleInfo) {
        ProvisionInfo provisionInfo = taskScheduleInfo.getProvisionInfo();
        logger.info("Cancel Provision ID=" + provisionInfo.getProvisionID());
        if (taskScheduleInfo.getTaskTimer() != null) {
            taskScheduleInfo.getTaskTimer().cancel();
            if (provisionInfo.getCommandResult().equals("waiting...")) {
                provisionInfo.setCommandResult("cancel");
                ProvisionInfoControl.getInstance().setProvisionInfo(provisionInfo.getProvisionID(), provisionInfo);
                ProvisionMessageQueue.getInstance().pushProvisionMessage(provisionInfo.getIpAddress());
            }
        }
        this.taskScheduleMap.remove(provisionInfo.getProvisionID());
    }

    public synchronized Map getTaskScheduleMap() {
        return this.taskScheduleMap;
    }

    public static ProvisionCommandTaskScheduleControl getInstance() {
        return SingletonResource.INSTANCE;
    }

    /* synthetic */ ProvisionCommandTaskScheduleControl(ProvisionCommandTaskScheduleControl provisionCommandTaskScheduleControl) {
        this();
    }

    private static class SingletonResource {
        static final ProvisionCommandTaskScheduleControl INSTANCE = new ProvisionCommandTaskScheduleControl(null);

        private SingletonResource() {
        }
    }
}

