/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.provision.gui.editor;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.net.SocketTimeoutException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import netjfwatcher.common.view.CalendarComposite;
import netjfwatcher.engine.model.action.MediaResource;
import netjfwatcher.provision.command.core.EngineFtp;
import netjfwatcher.provision.command.core.EngineTelnet;
import netjfwatcher.provision.command.core.LoginAuthAbortException;
import netjfwatcher.provision.command.core.ParserCommandFile;
import netjfwatcher.provision.command.schedule.ProvisionCommandTaskScheduleControl;
import netjfwatcher.provision.command.schedule.ProvisionCommandTaskScheduleInfo;
import netjfwatcher.provision.gui.editor.AbstractEditorProvision;
import netjfwatcher.provision.gui.editor.EditorInputProvision;
import netjfwatcher.provision.info.ProvisionInfo;
import netjfwatcher.provision.info.ProvisionInfoControl;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class EditorProvisionScheduleView
extends AbstractEditorProvision {
    public static final String TITLE_SUFFIX = " Provision Schedule View";
    private static final int[] SCROLL_COMPOSITE_SIZE = new int[]{800, 800};
    private static final int TEXT_WIDTH = 100;
    private static final int SCHEDULE_LIST_ITEM_HEIGHT = 3;
    private static final int FILE_PATH_TEXT_WIDTH_HINT = 500;
    private static final int COMMAND_TEXT_WIDTH_HINT = 500;
    private static final int COMMAND_TEXT_HEIGHT_HINT = 120;
    private static final int BUTTON_WIDTH = 150;
    private static final int BUTTON_HEIGHT = 20;
    private static final int LIST_WIDTHHINT = 300;
    private static final int HORIZONTAL_SPAN2 = 2;
    private static final int HORIZONTAL_SPAN3 = 3;
    private static final int HORIZONTAL_SPAN4 = 4;
    private static final int HORIZONTAL_SPAN8 = 8;
    private static Logger logger;
    private SubStatusLineManager statusLineManager;
    private Text idText;
    private Text nodeNameText;
    private Text ipAddressText;
    private Text groupText;
    private Text userName;
    private Text passwordText;
    private Text suPasswordText;
    private Combo nodeKindCombo;
    private Button refreshButton;
    private Button addButton;
    private Button editButton;
    private Button deleteButton;
    private Button cancelButton;
    private Button setButton;
    private Button ftpSourceFileSelectButton;
    private Button commandFileSelectButton;
    private List scheduleList;
    private Text commandFilePathText;
    private Text ftpSourceFilePathText;
    private Text ftpStoreFilePathText;
    private Text assignmentYearText;
    private Text assignmentMonthText;
    private Text assignmentDateText;
    private Combo assignmentDateHourCombo;
    private Combo assignmentDateMinuteCombo;
    private Text commandText;
    private Button testButton;
    private Button saveButton;
    private Date startDate;
    private DateFormat dateformat;
    private boolean isSortDirection = true;
    public static final int DATE_TEXT_WIDTH = 250;
    public static final int TEXT_WIDTH1 = 120;
    private ParserCommandFile commandFileParse = new ParserCommandFile();
    private String selectFileName;
    private ProvisionInfo provisionIDInfo;

    public EditorProvisionScheduleView() {
        logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        EditorInputProvision nodeViewEditorInput = (EditorInputProvision)this.getEditorInput();
        this.provisionIDInfo = nodeViewEditorInput.getProvisionInfo();
        this.dateformat = new SimpleDateFormat("yyyy-MM-dd (EEE) HH:mm:ss");
        ScrolledComposite scrollComposite = new ScrolledComposite(parent, 768);
        GridLayout layout = new GridLayout(1, false);
        scrollComposite.setLayout((Layout)layout);
        GridData gridData = null;
        GridLayout gridLayout0 = new GridLayout(1, true);
        Composite baseComposite0 = new Composite((Composite)scrollComposite, 0);
        baseComposite0.setLayout((Layout)gridLayout0);
        baseComposite0.setLayoutData((Object)new GridData());
        GridLayout gridLayout1 = new GridLayout(1, true);
        Composite baseComposite1 = new Composite(baseComposite0, 0);
        baseComposite1.setLayout((Layout)gridLayout1);
        baseComposite1.setLayoutData((Object)new GridData());
        GridLayout gridLayout2 = new GridLayout(2, true);
        Composite baseComposite2 = new Composite(baseComposite0, 0);
        baseComposite2.setLayout((Layout)gridLayout2);
        baseComposite2.setLayoutData((Object)new GridData());
        GridLayout gridLayoutPropComp = new GridLayout(6, false);
        Composite compositeProp = new Composite(baseComposite1, 0);
        compositeProp.setLayout((Layout)gridLayoutPropComp);
        compositeProp.setLayoutData((Object)new GridData(34));
        GridLayout gridLayoutListComp2 = new GridLayout(1, false);
        Composite compositeList2 = new Composite(baseComposite2, 0);
        compositeList2.setLayout((Layout)gridLayoutListComp2);
        compositeList2.setLayoutData((Object)new GridData(34));
        GridLayout gridLayoutOperation2 = new GridLayout(1, false);
        Composite compositeOperation2 = new Composite(baseComposite2, 0);
        compositeOperation2.setLayout((Layout)gridLayoutOperation2);
        compositeOperation2.setLayoutData((Object)new GridData(34));
        GridLayout gridLayoutButtonComp2 = new GridLayout(1, false);
        Composite compositeButton2 = new Composite(compositeOperation2, 0);
        compositeButton2.setLayout((Layout)gridLayoutButtonComp2);
        compositeButton2.setLayoutData((Object)new GridData());
        GridLayout gridLayoutListComp = new GridLayout(1, false);
        Composite compositeList = new Composite(baseComposite2, 0);
        compositeList.setLayout((Layout)gridLayoutListComp);
        compositeList.setLayoutData((Object)new GridData(34));
        GridLayout gridLayoutOperation = new GridLayout(1, false);
        Composite compositeOperation = new Composite(baseComposite2, 0);
        compositeOperation.setLayout((Layout)gridLayoutOperation);
        compositeOperation.setLayoutData((Object)new GridData(34));
        GridLayout gridLayoutButtonComp = new GridLayout(1, false);
        Composite compositeButton = new Composite(compositeOperation, 0);
        compositeButton.setLayout((Layout)gridLayoutButtonComp);
        compositeButton.setLayoutData((Object)new GridData());
        GridLayout gridLayoutDateTextComp = new GridLayout(8, false);
        Composite compositeDateText = new Composite(compositeOperation, 0);
        compositeDateText.setLayout((Layout)gridLayoutDateTextComp);
        compositeDateText.setLayoutData((Object)new GridData());
        GridLayout gridLayoutCalendar = new GridLayout(1, false);
        Composite compositeCalendar = new Composite(compositeOperation, 0);
        compositeCalendar.setLayoutData((Object)new GridData(256));
        compositeCalendar.setLayout((Layout)gridLayoutCalendar);
        GridLayout gridLayoutFile = new GridLayout(4, false);
        Composite compositeFile = new Composite(baseComposite2, 0);
        compositeFile.setLayout((Layout)gridLayoutFile);
        GridData fileGridData = new GridData();
        fileGridData.horizontalSpan = 2;
        fileGridData.verticalSpan = 1;
        compositeFile.setLayoutData((Object)fileGridData);
        GridLayout gridLayoutMonitor = new GridLayout(2, false);
        Composite compositeMonitor = new Composite(baseComposite2, 0);
        compositeMonitor.setLayout((Layout)gridLayoutMonitor);
        GridData monitorGridData = new GridData();
        monitorGridData.horizontalSpan = 2;
        monitorGridData.verticalSpan = 1;
        compositeMonitor.setLayoutData((Object)monitorGridData);
        Label label = new Label(compositeProp, 0);
        label.setText("ID");
        GridData listGridData = new GridData();
        listGridData.horizontalSpan = 1;
        listGridData.verticalSpan = 1;
        label.setLayoutData((Object)listGridData);
        this.idText = new Text(compositeProp, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 100;
        this.idText.setLayoutData((Object)gridData);
        this.refreshButton = new Button(compositeProp, 0);
        this.refreshButton.setText(" Refresh");
        this.refreshButton.setSize(150, 20);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        this.refreshButton.setLayoutData((Object)gridData);
        this.addButton = new Button(compositeProp, 0);
        this.addButton.setText(" Add  ");
        this.addButton.setSize(150, 20);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        this.addButton.setLayoutData((Object)gridData);
        this.editButton = new Button(compositeProp, 0);
        this.editButton.setText(" Edit  ");
        this.editButton.setSize(150, 20);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        this.editButton.setLayoutData((Object)gridData);
        this.deleteButton = new Button(compositeProp, 0);
        this.deleteButton.setText(" Delete");
        this.deleteButton.setSize(150, 20);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        this.deleteButton.setLayoutData((Object)gridData);
        label = new Label(compositeProp, 0);
        label.setText("Node Name");
        listGridData = new GridData();
        listGridData.horizontalSpan = 1;
        listGridData.verticalSpan = 1;
        label.setLayoutData((Object)listGridData);
        this.nodeNameText = new Text(compositeProp, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 100;
        this.nodeNameText.setLayoutData((Object)gridData);
        label = new Label(compositeProp, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(compositeProp, 0);
        label.setText("IP Address");
        listGridData = new GridData();
        listGridData.horizontalSpan = 1;
        listGridData.verticalSpan = 1;
        label.setLayoutData((Object)listGridData);
        this.ipAddressText = new Text(compositeProp, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 100;
        this.ipAddressText.setLayoutData((Object)gridData);
        label = new Label(compositeProp, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(compositeProp, 0);
        label.setText("Group");
        listGridData = new GridData();
        listGridData.horizontalSpan = 1;
        listGridData.verticalSpan = 1;
        label.setLayoutData((Object)listGridData);
        this.groupText = new Text(compositeProp, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 100;
        this.groupText.setLayoutData((Object)gridData);
        label = new Label(compositeProp, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.setNodeKind(compositeProp);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.nodeKindCombo.setLayoutData((Object)gridData);
        this.nodeKindCombo.setVisibleItemCount(15);
        label = new Label(compositeProp, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(compositeProp, 0);
        label.setText("User Name");
        listGridData = new GridData();
        listGridData.horizontalSpan = 1;
        listGridData.verticalSpan = 1;
        label.setLayoutData((Object)listGridData);
        this.userName = new Text(compositeProp, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 100;
        this.userName.setLayoutData((Object)gridData);
        label = new Label(compositeProp, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(compositeProp, 0);
        label.setText("Password");
        listGridData = new GridData();
        listGridData.horizontalSpan = 1;
        listGridData.verticalSpan = 1;
        label.setLayoutData((Object)listGridData);
        this.passwordText = new Text(compositeProp, 0x400800);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 100;
        this.passwordText.setLayoutData((Object)gridData);
        label = new Label(compositeProp, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(compositeProp, 0);
        label.setText("su Password");
        listGridData = new GridData();
        listGridData.horizontalSpan = 1;
        listGridData.verticalSpan = 1;
        label.setLayoutData((Object)listGridData);
        this.suPasswordText = new Text(compositeProp, 0x400800);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 100;
        this.suPasswordText.setLayoutData((Object)gridData);
        label = new Label(compositeProp, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(compositeList, 0);
        label.setText("Schedule");
        listGridData = new GridData();
        listGridData.horizontalSpan = 1;
        listGridData.verticalSpan = 1;
        label.setLayoutData((Object)listGridData);
        this.scheduleList = new List(compositeList, 2820);
        GridData data = new GridData(34);
        data.horizontalSpan = 1;
        data.verticalSpan = 10;
        data.widthHint = 300;
        data.heightHint = this.scheduleList.getItemHeight() * 3;
        this.scheduleList.setLayoutData((Object)data);
        this.ftpSourceFileSelectButton = new Button(compositeFile, 0);
        this.ftpSourceFileSelectButton.setSize(150, 20);
        this.ftpSourceFileSelectButton.setText("FTP Source File Browser");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        this.ftpSourceFileSelectButton.setLayoutData((Object)gridData);
        label = new Label(compositeFile, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(compositeFile, 0);
        label.setText("FTP Source File");
        listGridData = new GridData();
        listGridData.horizontalSpan = 1;
        listGridData.verticalSpan = 1;
        label.setLayoutData((Object)listGridData);
        this.ftpSourceFilePathText = new Text(compositeFile, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.verticalSpan = 1;
        gridData.widthHint = 500;
        this.ftpSourceFilePathText.setLayoutData((Object)gridData);
        label = new Label(compositeFile, 0);
        label.setText("FTP Store Path/File");
        listGridData = new GridData();
        listGridData.horizontalSpan = 1;
        listGridData.verticalSpan = 1;
        label.setLayoutData((Object)listGridData);
        this.ftpStoreFilePathText = new Text(compositeFile, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.verticalSpan = 1;
        gridData.widthHint = 500;
        this.ftpStoreFilePathText.setLayoutData((Object)gridData);
        this.commandFileSelectButton = new Button(compositeFile, 0);
        this.commandFileSelectButton.setSize(150, 20);
        this.commandFileSelectButton.setText("Telnet Command File Browser");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        this.commandFileSelectButton.setLayoutData((Object)gridData);
        this.saveButton = new Button(compositeFile, 0);
        this.saveButton.setText("Telnet Command File Save");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        this.saveButton.setLayoutData((Object)gridData);
        this.testButton = new Button(compositeFile, 0);
        this.testButton.setText("Test");
        this.testButton.setLayoutData((Object)new GridData());
        this.testButton.setVisible(false);
        label = new Label(compositeFile, 0);
        label.setText("Telnet Command File");
        listGridData = new GridData();
        listGridData.horizontalSpan = 1;
        listGridData.verticalSpan = 1;
        label.setLayoutData((Object)listGridData);
        this.commandFilePathText = new Text(compositeFile, 2048);
        data = new GridData();
        data.horizontalSpan = 3;
        data.verticalSpan = 1;
        data.widthHint = 500;
        this.commandFilePathText.setLayoutData((Object)data);
        this.commandText = new Text(compositeMonitor, 2626);
        this.commandText.setText("");
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        gridData.widthHint = 500;
        gridData.heightHint = 120;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.commandText.setLayoutData((Object)gridData);
        label = new Label(compositeButton, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.cancelButton = new Button(compositeButton, 0);
        this.cancelButton.setSize(150, 20);
        this.cancelButton.setText(" Cancel ");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        this.cancelButton.setLayoutData((Object)gridData);
        this.setButton = new Button(compositeButton, 0);
        this.setButton.setSize(150, 20);
        this.setButton.setText(" Set     ");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        this.setButton.setLayoutData((Object)gridData);
        this.assignmentYearText = new Text(compositeDateText, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 40;
        this.assignmentYearText.setLayoutData((Object)gridData);
        this.assignmentMonthText = new Text(compositeDateText, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 20;
        this.assignmentMonthText.setLayoutData((Object)gridData);
        label = new Label(compositeDateText, 0);
        label.setText("/");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.assignmentDateText = new Text(compositeDateText, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 20;
        this.assignmentDateText.setLayoutData((Object)gridData);
        this.assignmentDateHourCombo = new Combo(compositeDateText, 8);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        this.assignmentDateHourCombo.setLayoutData((Object)gridData);
        this.setHourCombo(this.assignmentDateHourCombo);
        this.assignmentDateHourCombo.setVisibleItemCount(15);
        this.assignmentDateHourCombo.select(0);
        label = new Label(compositeDateText, 0);
        label.setText(":");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.assignmentDateMinuteCombo = new Combo(compositeDateText, 8);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        this.assignmentDateMinuteCombo.setLayoutData((Object)gridData);
        this.setMinuteCombo(this.assignmentDateMinuteCombo);
        this.assignmentDateMinuteCombo.setVisibleItemCount(15);
        this.assignmentDateMinuteCombo.select(0);
        CalendarComposite calendarComposite = new CalendarComposite();
        calendarComposite.setYearText(this.assignmentYearText);
        calendarComposite.setMonthText(this.assignmentMonthText);
        calendarComposite.setDateText(this.assignmentDateText);
        calendarComposite.createCalendarView(compositeCalendar);
        this.assignmentYearText.setText(calendarComposite.getCalendarTable().getTodaysYY());
        this.assignmentMonthText.setText(calendarComposite.getCalendarTable().getTodaysMM());
        this.assignmentDateText.setText(calendarComposite.getCalendarTable().getTodaysDD());
        scrollComposite.setContent((Control)baseComposite0);
        scrollComposite.setMinSize(SCROLL_COMPOSITE_SIZE[0], SCROLL_COMPOSITE_SIZE[1]);
        scrollComposite.setExpandHorizontal(true);
        scrollComposite.setExpandVertical(true);
        this.setText();
        this.setListener();
        this.getTaskSchedule();
        this.setCommandTextView();
    }

    private void setListener() {
        this.refreshButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                EditorProvisionScheduleView.this.refreshButton.setEnabled(false);
                if (EditorProvisionScheduleView.this.provisionIDInfo != null) {
                    EditorProvisionScheduleView.this.provisionIDInfo = ProvisionInfoControl.getInstance().getProvisionInfo(EditorProvisionScheduleView.this.provisionIDInfo.getProvisionID());
                    EditorProvisionScheduleView.this.setText();
                    EditorProvisionScheduleView.this.getTaskSchedule();
                    EditorProvisionScheduleView.this.setCommandTextView();
                }
                EditorProvisionScheduleView.this.refreshButton.setEnabled(true);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.addButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                EditorProvisionScheduleView.this.addButton.setEnabled(false);
                if (EditorProvisionScheduleView.this.idText.getText().equals("")) {
                    MessageDialog.openError((Shell)EditorProvisionScheduleView.this.getSite().getShell(), (String)"Error", (String)"Invalid ID");
                    EditorProvisionScheduleView.this.idText.setFocus();
                    EditorProvisionScheduleView.this.addButton.setEnabled(true);
                    return;
                }
                try {
                    Integer.parseInt(EditorProvisionScheduleView.this.idText.getText());
                }
                catch (Exception e) {
                    MessageDialog.openError((Shell)EditorProvisionScheduleView.this.getSite().getShell(), (String)"Error", (String)("Invalid ID=" + EditorProvisionScheduleView.this.idText.getText() + " " + e.getMessage()));
                    EditorProvisionScheduleView.this.idText.setFocus();
                    EditorProvisionScheduleView.this.addButton.setEnabled(true);
                    return;
                }
                if (EditorProvisionScheduleView.this.ipAddressText.getText().equals("")) {
                    MessageDialog.openError((Shell)EditorProvisionScheduleView.this.getSite().getShell(), (String)"Error", (String)"Invalid IP Address");
                    EditorProvisionScheduleView.this.ipAddressText.setFocus();
                    EditorProvisionScheduleView.this.addButton.setEnabled(true);
                    return;
                }
                Map provisionMap = ProvisionInfoControl.getInstance().getProvisionInfoHashMap();
                if (provisionMap.containsKey(EditorProvisionScheduleView.this.idText.getText())) {
                    MessageDialog.openError((Shell)EditorProvisionScheduleView.this.getSite().getShell(), (String)"Error", (String)("Already ID=" + EditorProvisionScheduleView.this.idText.getText()));
                    EditorProvisionScheduleView.this.idText.setFocus();
                } else {
                    EditorProvisionScheduleView.this.setProvision();
                }
                EditorProvisionScheduleView.this.addButton.setEnabled(true);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.editButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                EditorProvisionScheduleView.this.editButton.setEnabled(false);
                Map provisionMap = ProvisionInfoControl.getInstance().getProvisionInfoHashMap();
                if (provisionMap.containsKey(EditorProvisionScheduleView.this.idText.getText())) {
                    EditorProvisionScheduleView.this.setProvision();
                } else {
                    MessageDialog.openError((Shell)EditorProvisionScheduleView.this.getSite().getShell(), (String)"Error", (String)("Not found ID. ID=" + EditorProvisionScheduleView.this.idText.getText()));
                    EditorProvisionScheduleView.this.idText.setFocus();
                }
                EditorProvisionScheduleView.this.editButton.setEnabled(true);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.deleteButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                EditorProvisionScheduleView.this.deleteButton.setEnabled(false);
                ProvisionInfoControl.getInstance().deleteProvisionInfo(EditorProvisionScheduleView.this.idText.getText());
                EditorProvisionScheduleView.this.deleteButton.setEnabled(true);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.setButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                EditorProvisionScheduleView.this.setButton.setEnabled(false);
                EditorProvisionScheduleView.this.scheduleList.removeAll();
                EditorProvisionScheduleView.this.getSelectDate();
                EditorProvisionScheduleView.this.setButton.setEnabled(true);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.commandFileSelectButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                EditorProvisionScheduleView.this.commandFileSelectButton.setEnabled(false);
                FileDialog openDialog = new FileDialog(EditorProvisionScheduleView.this.getEditorSite().getShell(), 4096);
                String[] fileExt = new String[]{"*.*"};
                openDialog.setFilterExtensions(fileExt);
                openDialog.setFilterPath("./provision/");
                String openFileName = openDialog.open();
                if (openFileName != null) {
                    EditorProvisionScheduleView.this.commandFilePathText.setText(openFileName);
                }
                EditorProvisionScheduleView.this.commandFileSelectButton.setEnabled(true);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.ftpSourceFileSelectButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                EditorProvisionScheduleView.this.ftpSourceFileSelectButton.setEnabled(false);
                FileDialog openDialog = new FileDialog(EditorProvisionScheduleView.this.getEditorSite().getShell(), 4096);
                String[] fileExt = new String[]{"*.*"};
                openDialog.setFilterExtensions(fileExt);
                openDialog.setFilterPath("./provision/");
                String openFileName = openDialog.open();
                if (openFileName != null) {
                    EditorProvisionScheduleView.this.ftpSourceFilePathText.setText(openFileName);
                    EditorProvisionScheduleView.this.ftpStoreFilePathText.setText("./");
                }
                EditorProvisionScheduleView.this.ftpSourceFileSelectButton.setEnabled(true);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.cancelButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                EditorProvisionScheduleView.this.cancelButton.setEnabled(false);
                int selectListIndex = EditorProvisionScheduleView.this.scheduleList.getSelectionIndex();
                if (selectListIndex >= 0) {
                    EditorProvisionScheduleView.this.scheduleList.removeAll();
                    EditorProvisionScheduleView.this.startDate = null;
                    Map scheduleMap = ProvisionCommandTaskScheduleControl.getInstance().getTaskScheduleMap();
                    ProvisionCommandTaskScheduleInfo taskInfo = (ProvisionCommandTaskScheduleInfo)scheduleMap.get(EditorProvisionScheduleView.this.provisionIDInfo.getProvisionID());
                    if (taskInfo != null) {
                        EditorProvisionScheduleView.this.cancelTaskSchedule(taskInfo);
                        EditorProvisionScheduleView.this.provisionIDInfo.setStartDate(null);
                        EditorProvisionScheduleView.this.getTaskSchedule();
                    }
                }
                EditorProvisionScheduleView.this.cancelButton.setEnabled(true);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.saveButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                EditorProvisionScheduleView.this.saveButton.setEnabled(false);
                EditorProvisionScheduleView.this.saveCommandFile();
                EditorProvisionScheduleView.this.saveButton.setEnabled(true);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.testButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                EditorProvisionScheduleView.this.testButton.setEnabled(false);
                EditorProvisionScheduleView.this.test();
                EditorProvisionScheduleView.this.testButton.setEnabled(true);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
    }

    private void setText() {
        if (this.provisionIDInfo != null) {
            this.idText.setText(this.provisionIDInfo.getProvisionID());
            this.nodeNameText.setText(this.provisionIDInfo.getNodeName());
            this.ipAddressText.setText(this.provisionIDInfo.getIpAddress());
            this.groupText.setText(this.provisionIDInfo.getGroup());
            if (this.provisionIDInfo.getUserName() != null) {
                this.userName.setText(this.provisionIDInfo.getUserName());
            }
            if (this.provisionIDInfo.getPassword() != null) {
                this.passwordText.setText(this.provisionIDInfo.getPassword());
            }
            if (this.provisionIDInfo.getSuPpassword() != null) {
                this.suPasswordText.setText(this.provisionIDInfo.getSuPpassword());
            }
            this.nodeKindCombo.setText(this.provisionIDInfo.getNodeKind());
            if (this.provisionIDInfo.getCommandFile() != null) {
                this.commandFilePathText.setText(this.provisionIDInfo.getCommandFile());
            }
            if (this.provisionIDInfo.getFtpSourceFile() != null) {
                this.ftpSourceFilePathText.setText(this.provisionIDInfo.getFtpSourceFile());
            }
            if (this.provisionIDInfo.getFtpStoreFile() != null) {
                this.ftpStoreFilePathText.setText(this.provisionIDInfo.getFtpStoreFile());
            }
            if (this.provisionIDInfo.getStartDate() != null) {
                this.scheduleList.removeAll();
                this.scheduleList.add(this.dateformat.format(this.provisionIDInfo.getStartDate()), 0);
                this.startDate = this.provisionIDInfo.getStartDate();
            }
        }
    }

    private void setNodeKind(Composite composite2) {
        Label label = new Label(composite2, 0);
        label.setText("Node Kind");
        GridData gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.nodeKindCombo = new Combo(composite2, 12);
        HashMap nodeIconMap = MediaResource.getInstance().getIconDataList();
        for (String key : nodeIconMap.keySet()) {
            this.nodeKindCombo.add(key);
        }
        this.nodeKindCombo.select(0);
    }

    private void setProvision() {
        ProvisionInfo provisionInfo = this.createProvisionInfo();
        ProvisionInfoControl.getInstance().setProvisionInfo(this.idText.getText(), provisionInfo);
    }

    private ProvisionInfo createProvisionInfo() {
        ProvisionInfo provisionInfo = new ProvisionInfo();
        provisionInfo.setProvisionID(this.idText.getText());
        provisionInfo.setNodeName(this.nodeNameText.getText());
        provisionInfo.setIpAddress(this.ipAddressText.getText());
        provisionInfo.setGroup(this.groupText.getText());
        provisionInfo.setNodeKind(this.nodeKindCombo.getText());
        provisionInfo.setUserName(this.userName.getText());
        provisionInfo.setPassword(this.passwordText.getText());
        provisionInfo.setSuPpassword(this.suPasswordText.getText());
        provisionInfo.setCommandFile(this.commandFilePathText.getText());
        provisionInfo.setFtpSourceFile(this.ftpSourceFilePathText.getText());
        provisionInfo.setFtpStoreFile(this.ftpStoreFilePathText.getText());
        provisionInfo.setStartDate(this.startDate);
        return provisionInfo;
    }

    private void setCommandTextView() {
        this.commandText.setText("");
        if (this.provisionIDInfo != null && this.provisionIDInfo.getCommandFile() != null) {
            try {
                ArrayList parseCommandList = this.commandFileParse.parse(this.provisionIDInfo.getCommandFile());
                if (parseCommandList == null) {
                    return;
                }
                int i = 0;
                while (i < parseCommandList.size()) {
                    this.commandText.append(String.valueOf((String)parseCommandList.get(i)) + System.getProperty("line.separator"));
                    ++i;
                }
            }
            catch (Exception e) {
                logger.warning("Exception " + e.getMessage());
            }
        }
    }

    private void saveCommandFile() {
        boolean ok;
        BufferedWriter bufferedWriter;
        OutputStreamWriter fileWriter;
        File selectCommandFile;
        block26: {
            block27: {
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        FileDialog openDialog = new FileDialog(EditorProvisionScheduleView.this.getEditorSite().getShell(), 4096);
                        if (!EditorProvisionScheduleView.this.commandFilePathText.getText().equals("")) {
                            openDialog.setFilterPath(EditorProvisionScheduleView.this.commandFilePathText.getText());
                        } else {
                            openDialog.setFilterPath("./provision/");
                        }
                        EditorProvisionScheduleView.this.selectFileName = openDialog.open();
                    }
                });
                if (this.selectFileName == null || this.selectFileName.equals("")) {
                    return;
                }
                selectCommandFile = new File(this.selectFileName);
                if (selectCommandFile.exists() && !MessageDialog.openConfirm((Shell)this.getEditorSite().getShell(), (String)"Confirmation", (String)(selectCommandFile + " has already existed." + System.getProperty("line.separator") + "Are you sure you want to over write it?"))) {
                    return;
                }
                fileWriter = null;
                bufferedWriter = null;
                ok = true;
                if (selectCommandFile != null) break block26;
                if (bufferedWriter == null) break block27;
                try {
                    bufferedWriter.close();
                }
                catch (Exception e1) {
                    logger.warning("Exception " + e1.getMessage());
                }
            }
            if (fileWriter != null) {
                try {
                    fileWriter.close();
                }
                catch (Exception e2) {
                    logger.warning("Exception " + e2.getMessage());
                }
            }
            return;
        }
        try {
            try {
                fileWriter = new FileWriter(selectCommandFile);
                bufferedWriter = new BufferedWriter(fileWriter);
                String commandString = this.commandText.getText();
                Pattern pattern = Pattern.compile(System.getProperty("line.separator"));
                String[] commandStrArray = pattern.split(commandString);
                if (commandStrArray != null) {
                    int i = 0;
                    while (i < commandStrArray.length) {
                        bufferedWriter.write(commandStrArray[i]);
                        ++i;
                    }
                }
            }
            catch (Exception exception) {
                ok = false;
            }
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.close();
                }
                catch (Exception e1) {
                    logger.warning("Exception " + e1.getMessage());
                }
            }
            if (fileWriter != null) {
                try {
                    fileWriter.close();
                }
                catch (Exception e2) {
                    logger.warning("Exception " + e2.getMessage());
                }
            }
        }
        if (ok) {
            MessageDialog.openInformation((Shell)this.getEditorSite().getShell(), (String)"Information", (String)("Successfully saved." + System.getProperty("line.separator") + selectCommandFile));
            this.commandFilePathText.setText(this.selectFileName);
        }
    }

    private void setHourCombo(Combo combo) {
        int i = 0;
        while (i < 24) {
            String work = Integer.toString(i);
            if (work.length() == 1) {
                work = "0" + work;
            }
            combo.add(work);
            ++i;
        }
    }

    private void setMinuteCombo(Combo combo) {
        int i = 0;
        while (i < 60) {
            String work = Integer.toString(i);
            if (work.length() == 1) {
                work = "0" + work;
            }
            combo.add(work);
            ++i;
        }
    }

    private void getTaskSchedule() {
        if (this.provisionIDInfo == null) {
            return;
        }
        Map taskSchduleMap = ProvisionCommandTaskScheduleControl.getInstance().getTaskScheduleMap();
        ProvisionCommandTaskScheduleInfo taskScheduleInfo = (ProvisionCommandTaskScheduleInfo)taskSchduleMap.get(this.provisionIDInfo.getProvisionID());
        ProvisionInfo info = null;
        if (taskScheduleInfo != null) {
            info = taskScheduleInfo.getProvisionInfo();
        }
        if (info != null && info.getStartDate() != null && !info.getStartDate().equals("")) {
            this.scheduleList.removeAll();
            this.scheduleList.add(this.dateformat.format(info.getStartDate()), 0);
        } else if (this.provisionIDInfo.getStartDate() != null) {
            this.scheduleList.removeAll();
            this.scheduleList.add(this.dateformat.format(this.provisionIDInfo.getStartDate()), 0);
        } else {
            this.scheduleList.removeAll();
        }
    }

    private String getDateStr(int dateData) {
        String work = Integer.toString(dateData);
        if (work.length() == 1) {
            work = "0" + work;
        }
        return work;
    }

    private void getSelectDate() {
        int indexStartHH = this.assignmentDateHourCombo.getSelectionIndex();
        int indexStartMin = this.assignmentDateMinuteCombo.getSelectionIndex();
        int startYY = 0;
        try {
            startYY = Integer.parseInt(this.assignmentYearText.getText());
        }
        catch (NumberFormatException numberFormatException) {
            MessageDialog.openError((Shell)this.getSite().getShell(), (String)"Error", (String)"Illegal Date  !");
            this.assignmentYearText.setFocus();
            return;
        }
        int startMM = 0;
        try {
            startMM = Integer.parseInt(this.assignmentMonthText.getText());
        }
        catch (NumberFormatException numberFormatException) {
            MessageDialog.openError((Shell)this.getSite().getShell(), (String)"Error", (String)"Illegal Date  !");
            this.assignmentMonthText.setFocus();
            return;
        }
        int startDD = 0;
        try {
            startDD = Integer.parseInt(this.assignmentDateText.getText());
        }
        catch (NumberFormatException numberFormatException) {
            MessageDialog.openError((Shell)this.getSite().getShell(), (String)"Error", (String)"Illegal Date  !");
            this.assignmentDateText.setFocus();
            return;
        }
        int startHH = 0;
        try {
            startHH = Integer.parseInt(this.assignmentDateHourCombo.getItem(indexStartHH));
        }
        catch (NumberFormatException numberFormatException) {
            MessageDialog.openError((Shell)this.getSite().getShell(), (String)"Error", (String)"Illegal Date  !");
            this.assignmentDateHourCombo.setFocus();
            return;
        }
        int startMIN = 0;
        try {
            startMIN = Integer.parseInt(this.assignmentDateMinuteCombo.getItem(indexStartMin));
        }
        catch (NumberFormatException numberFormatException) {
            MessageDialog.openError((Shell)this.getSite().getShell(), (String)"Error", (String)"Illegal Date  !");
            this.assignmentDateMinuteCombo.setFocus();
            return;
        }
        Calendar cal = Calendar.getInstance();
        cal.set(startYY, startMM - 1, startDD, startHH, startMIN, 0);
        this.startDate = cal.getTime();
        this.scheduleList.add(this.dateformat.format(this.startDate), 0);
    }

    private void test() {
        ProvisionInfo testProvisionInfo;
        String commandString = this.commandText.getText();
        Pattern pattern = Pattern.compile(System.getProperty("line.separator"));
        String[] commandStrArray = pattern.split(commandString);
        ArrayList<String> commandList = new ArrayList<String>();
        if (commandStrArray != null) {
            int i = 0;
            while (i < commandStrArray.length) {
                commandList.add(commandStrArray[i]);
                ++i;
            }
        }
        if (!(testProvisionInfo = this.createProvisionInfo()).getFtpSourceFile().equals("") && !testProvisionInfo.getFtpStoreFile().equals("")) {
            try {
                EngineFtp testFtp = new EngineFtp(testProvisionInfo);
                testFtp.putFile();
            }
            catch (LoginAuthAbortException e) {
                MessageDialog.openError((Shell)this.getSite().getShell(), (String)"Error", (String)("LoginAuthAbortException " + e.getMessage()));
            }
            catch (Exception e) {
                MessageDialog.openError((Shell)this.getSite().getShell(), (String)"Error", (String)("Exception " + e.getMessage()));
            }
        }
        if (!testProvisionInfo.getCommandFile().equals("")) {
            EngineTelnet telnet = new EngineTelnet(testProvisionInfo);
            try {
                telnet.start(true, commandList);
            }
            catch (SocketTimeoutException e) {
                MessageDialog.openError((Shell)this.getSite().getShell(), (String)"Error", (String)("SocketTimeoutException " + e.getMessage()));
            }
            catch (Exception e) {
                MessageDialog.openError((Shell)this.getSite().getShell(), (String)"Error", (String)("Exception " + e.getMessage()));
            }
        }
    }

    private void cancelTaskSchedule(ProvisionCommandTaskScheduleInfo taskInfo) {
        if (taskInfo != null) {
            ProvisionCommandTaskScheduleControl.getInstance().cancelTaskSchedule(taskInfo);
        }
    }

    public void setFocus() {
    }

    protected void setStatusLine() {
    }
}

