/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.provision.model.action;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.provision.command.core.LoggingProvision;
import netjfwatcher.provision.command.schedule.ProvisionCommandTaskScheduleControl;
import netjfwatcher.provision.command.schedule.ProvisionCommandTaskScheduleInfo;
import netjfwatcher.provision.info.ProvisionInfo;
import netjfwatcher.provision.info.ProvisionInfoControl;
import netjfwatcher.provision.model.action.ProvisionFileParse;
import netjfwatcher.provision.model.action.ProvisionImportParseAbortException;
import netjfwatcher.provision.model.action.ProvisionStartStopStatus;
import netjfwatcher.provision.nodemaneger.list.ProvisionMessageQueue;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public abstract class ActionBuilderProvisionNodeList {
    private static Logger logger;
    private IEditorPart editorNodeConfigView;
    private IAction showProvisionTableAction = new ActionShowProvisionListTable();
    private IAction importNodeListAction = new ActionImportProvisionListFile();
    private IAction importNodeListActionSocket = new ActionImportProvisionListFileSocket();
    private IAction exportNodeListAction = new ActionExportProvisionListFile();
    private IAction clearProvisionNodeListAction = new ActionRemoveProvisionNodeList();
    private final Bundle bundle = NetJFWatcherPlugin.getInstance().getBundle();

    public ActionBuilderProvisionNodeList() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public IAction getActionImportNodeListFile() {
        return this.importNodeListAction;
    }

    public IAction getActionImportNodeListFileSocket() {
        return this.importNodeListActionSocket;
    }

    public IAction getActionExportNodeListFile() {
        return this.exportNodeListAction;
    }

    public IAction getActionShowProvisionTable() {
        return this.showProvisionTableAction;
    }

    public IAction getActionRemoveProvisionNodeListTable() {
        return this.clearProvisionNodeListAction;
    }

    protected void refreshProvisionTable() {
    }

    private ArrayList getNodeList() {
        ArrayList nodeList = null;
        Iterator it = null;
        Map provisionMap = ProvisionInfoControl.getInstance().getProvisionInfoHashMap();
        for (String key : provisionMap.keySet()) {
            ProvisionInfo info = (ProvisionInfo)provisionMap.get(key);
            if (info == null) continue;
            nodeList.add(info);
        }
        return nodeList;
    }

    private void exportNodeInfo(boolean isSocket) {
        Shell shell = new Shell();
        FileDialog openDialog = new FileDialog(shell, 8192);
        String[] fileExt = new String[]{"*.xml"};
        openDialog.setFilterExtensions(fileExt);
        openDialog.setFilterPath("./provision/");
        String xmlFile = openDialog.open();
        logger.info("XML file name : " + xmlFile);
        shell.dispose();
        if (xmlFile == null) {
            return;
        }
        ProvisionFileParse outProvision = new ProvisionFileParse();
        outProvision.outputXMLFile(xmlFile);
    }

    private abstract class AbstractProvisionTableListAction
    extends Action {
        private AbstractProvisionTableListAction() {
        }

        public final void run() {
            this.doTask();
        }

        protected abstract void doTask();
    }

    protected class ActionShowProvisionListTable
    extends AbstractProvisionTableListAction {
        protected ActionShowProvisionListTable() {
        }

        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL((URL)ActionBuilderProvisionNodeList.this.bundle.getEntry("icons/reload.gif"));
        }

        public String getText() {
            return "Show Provision Table";
        }

        public String getToolTipText() {
            return "Show Provision Table";
        }

        protected void doTask() {
            ActionBuilderProvisionNodeList.this.refreshProvisionTable();
        }
    }

    protected class ActionImportProvisionListFile
    extends AbstractProvisionTableListAction {
        protected ActionImportProvisionListFile() {
        }

        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL((URL)ActionBuilderProvisionNodeList.this.bundle.getEntry("icons/import_wiz.gif"));
        }

        public String getText() {
            return "Import Provision File";
        }

        public String getToolTipText() {
            return "Import Provision File";
        }

        protected void doTask() {
            Shell shell = new Shell();
            FileDialog openDialog = new FileDialog(shell, 4096);
            String[] fileExt = new String[]{"*.xml"};
            openDialog.setFilterExtensions(fileExt);
            openDialog.setFilterPath("./provision");
            final String openFileName = openDialog.open();
            if (openFileName == null || openFileName.equals("")) {
                if (shell != null) {
                    shell.dispose();
                }
                return;
            }
            BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    try {
                        ProvisionFileParse parseFileInstance = new ProvisionFileParse();
                        parseFileInstance.parseProvisionFile(openFileName);
                    }
                    catch (ProvisionImportParseAbortException e) {
                        logger.warning("ProvisionImportParseAbortException " + e.getMessage());
                        Shell shell = new Shell();
                        MessageDialog.openWarning((Shell)shell, (String)"Provision Import File.", (String)("Abort Parse Provision Import File. " + e.getMessage()));
                        if (shell != null) {
                            shell.dispose();
                        }
                        return;
                    }
                    catch (Exception e) {
                        logger.warning("Exception " + e.getMessage());
                        Shell shell = new Shell();
                        MessageDialog.openWarning((Shell)shell, (String)"Provision Import File.", (String)("Abort Parse Provision Import File. " + e.getMessage()));
                        if (shell != null) {
                            shell.dispose();
                        }
                        return;
                    }
                }
            });
            if (shell != null) {
                shell.dispose();
            }
        }
    }

    protected class ActionImportProvisionListFileSocket
    extends ActionImportProvisionListFile {
        protected ActionImportProvisionListFileSocket() {
        }

        protected void doTask() {
        }
    }

    protected class ActionExportProvisionListFile
    extends AbstractProvisionTableListAction {
        protected ActionExportProvisionListFile() {
        }

        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL((URL)ActionBuilderProvisionNodeList.this.bundle.getEntry("icons/export_wiz.gif"));
        }

        public String getText() {
            return "Export Provision File";
        }

        public String getToolTipText() {
            return "Export Provision File";
        }

        protected void doTask() {
            ActionBuilderProvisionNodeList.this.exportNodeInfo(false);
        }
    }

    private final class ActionRemoveProvisionNodeList
    extends AbstractProvisionTableListAction {
        private ActionRemoveProvisionNodeList() {
        }

        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL((URL)ActionBuilderProvisionNodeList.this.bundle.getEntry("icons/clear.gif"));
        }

        public String getText() {
            return "Clear Provision";
        }

        public String getToolTipText() {
            return "Clear Provision";
        }

        protected void doTask() {
            if (ProvisionStartStopStatus.getInstance().isRunProvision()) {
                Shell shell = new Shell();
                MessageDialog.openWarning((Shell)shell, (String)"Provision Status", (String)"Provision Running.");
                if (shell != null) {
                    shell.dispose();
                }
                return;
            }
            LoggingProvision.getInstance().stopLog();
            Map provisionMap = ProvisionInfoControl.getInstance().getProvisionInfoHashMap();
            Map taskScheduleMap = ProvisionCommandTaskScheduleControl.getInstance().getTaskScheduleMap();
            Iterator it = null;
            for (String provisionIDKey : provisionMap.keySet()) {
                ProvisionCommandTaskScheduleInfo taskScheduleInfo = (ProvisionCommandTaskScheduleInfo)taskScheduleMap.get(provisionIDKey);
                if (taskScheduleInfo == null) continue;
                ProvisionCommandTaskScheduleControl.getInstance().cancelTaskSchedule(taskScheduleInfo);
                ProvisionMessageQueue.getInstance().pushProvisionMessage(provisionIDKey);
            }
            ProvisionInfoControl.getInstance().deleteAllProvisionInfo();
            ActionBuilderProvisionNodeList.this.refreshProvisionTable();
        }
    }
}

