/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.provision.model.action;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.common.view.AbstractNodeTreeView;
import netjfwatcher.common.view.INodeTreeNode;
import netjfwatcher.common.view.NodeTreeGroup;
import netjfwatcher.engine.model.action.MediaResource;
import netjfwatcher.engine.resourceconfig.ClientEngineInfo;
import netjfwatcher.engine.socket.ConnectionNodeInformation;
import netjfwatcher.engine.socket.EngineConnectException;
import netjfwatcher.provision.info.ProvisionInfo;
import netjfwatcher.provision.info.ProvisionInfoControl;
import netjfwatcher.provision.model.action.ProvisionNodeTree;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.osgi.framework.Bundle;

public class ActionBuilderProvisionNodeTree
extends Action {
    private static Logger logger = null;
    private HashMap nodeIconImageMap = new HashMap();
    private TreeViewer nodeListTreeViewer;
    private AbstractNodeTreeView nodeTreeView;
    private SubStatusLineManager statusLineManager;
    private Composite parentComposite;
    private NodeTreeGroup nodeTreeGroupRoot;
    private IEditorPart editorNodeConfigView;
    private ArrayList nodeInfoListSocket = new ArrayList();
    private HashMap groupMap = new HashMap();
    private final Bundle bundle = NetJFWatcherPlugin.getInstance().getBundle();
    private IAction reloadProvisionNodeTree = new ActionReloadProvisionNodeTree();
    private IAction reloadProvisionNodeTreeSocket = new ActionReloadProvisionNodeTreeSocket();
    private IAction sortProvisionNodeTree = new ActionSortProvisionNodeTree();
    private IAction sortProvisionNodeTreeSocket = new ActionSortProvisionNodeTreeSocket();

    public ActionBuilderProvisionNodeTree() {
        logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    }

    public ActionBuilderProvisionNodeTree(AbstractNodeTreeView nodeTreeView, TreeViewer nodeListTreeViewer, Composite parentComposite, NodeTreeGroup nodeTreeGroupRoot) {
        logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
        this.nodeTreeView = nodeTreeView;
        this.nodeListTreeViewer = nodeListTreeViewer;
        this.parentComposite = parentComposite;
        this.nodeTreeGroupRoot = nodeTreeGroupRoot;
    }

    public TreeViewer getViewer() {
        return this.nodeListTreeViewer;
    }

    public IAction actionReloadProvisionNodeTree() {
        return this.reloadProvisionNodeTree;
    }

    public IAction actionReloadProvisionNodeTreeSocket() {
        return this.reloadProvisionNodeTreeSocket;
    }

    public IAction actionSortProvisionNodeTree() {
        return this.sortProvisionNodeTree;
    }

    public IAction actionSortProvisionNodeTreeSocket() {
        return this.sortProvisionNodeTreeSocket;
    }

    private void createNodeTree(ProvisionInfo provisionInfo, final boolean isSortDirectionTreeView) {
        String group = provisionInfo.getGroup();
        NodeTreeGroup nodetreeGroup = null;
        if (this.groupMap.containsKey(group)) {
            nodetreeGroup = (NodeTreeGroup)this.groupMap.get(group);
        } else {
            nodetreeGroup = new NodeTreeGroup(group);
            this.nodeTreeGroupRoot.addChild((INodeTreeNode)nodetreeGroup);
            this.groupMap.put(group, nodetreeGroup);
        }
        String provisionIDName = "ID=" + provisionInfo.getProvisionID() + " " + provisionInfo.getNodeName() + "(" + provisionInfo.getIpAddress() + ")";
        Image nodeIconImage = null;
        nodeIconImage = this.createNodeIconImage(provisionInfo.getNodeKind());
        nodetreeGroup.addChild((INodeTreeNode)new ProvisionNodeTree(provisionIDName, provisionInfo, nodeIconImage));
        this.nodeListTreeViewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                String name2;
                String name1;
                int cat2;
                int cat1 = this.category(e1);
                if (cat1 != (cat2 = this.category(e2))) {
                    return cat1 - cat2;
                }
                if (viewer == null || !(viewer instanceof ContentViewer)) {
                    name1 = e1.toString();
                    name2 = e2.toString();
                } else {
                    IBaseLabelProvider prov = ((ContentViewer)viewer).getLabelProvider();
                    if (prov instanceof ILabelProvider) {
                        ILabelProvider lprov = (ILabelProvider)prov;
                        name1 = lprov.getText(e1);
                        name2 = lprov.getText(e2);
                    } else {
                        name1 = e1.toString();
                        name2 = e2.toString();
                    }
                }
                if (name1 == null) {
                    name1 = "";
                }
                if (name2 == null) {
                    name2 = "";
                }
                if (isSortDirectionTreeView) {
                    return this.collator.compare(name1, name2);
                }
                return this.collator.compare(name2, name1);
            }
        });
        this.nodeListTreeViewer.expandAll();
        this.nodeListTreeViewer.refresh();
    }

    private Image createNodeIconImage(String nodeKind) {
        String nodeIconFileName = MediaResource.getInstance().getNodeIconFullFileName(nodeKind);
        Image nodeIconImage = null;
        if (!this.nodeIconImageMap.containsKey(nodeIconFileName)) {
            Display display = this.parentComposite.getDisplay();
            URL url = null;
            url = this.bundle.getEntry(nodeIconFileName);
            if (url == null) {
                logger.severe("Npt found icon file : " + nodeIconFileName);
            } else {
                try {
                    nodeIconImage = new Image((Device)display, url.openStream());
                    this.nodeIconImageMap.put(nodeIconFileName, nodeIconImage);
                }
                catch (IOException e) {
                    logger.warning("Abort create image " + e.getMessage() + " for " + nodeIconFileName);
                    e.printStackTrace();
                }
            }
        } else {
            nodeIconImage = (Image)this.nodeIconImageMap.get(nodeIconFileName);
        }
        return nodeIconImage;
    }

    protected void setStatusLine(int groupNo, int nodeNo) {
        this.statusLineManager = (SubStatusLineManager)this.nodeTreeView.getViewSite().getActionBars().getStatusLineManager();
        this.statusLineManager.setVisible(true);
        this.statusLineManager.setMessage("Node Tree View Group count=" + groupNo + " Node count=" + nodeNo);
    }

    public INodeTreeNode getNodeBase() {
        IStructuredSelection selectElement = (IStructuredSelection)this.getViewer().getSelection();
        INodeTreeNode node = (INodeTreeNode)selectElement.getFirstElement();
        if (node == null) {
            node = (INodeTreeNode)this.getViewer().getInput();
        }
        return node;
    }

    public NodeTreeGroup setNodeGroupBase(INodeTreeNode node) {
        NodeTreeGroup baseNodeGroup = null;
        if (node != null) {
            baseNodeGroup = node.getParent();
        }
        if (node instanceof NodeTreeGroup) {
            baseNodeGroup = (NodeTreeGroup)node;
        }
        return baseNodeGroup;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        HashMap list = this.nodeIconImageMap;
        Iterator it = null;
        for (String key : list.keySet()) {
            Image nodeIconImage = (Image)list.get(key);
            if (nodeIconImage == null) continue;
            nodeIconImage.dispose();
        }
    }

    protected abstract class AbstractProvisionNodeAction
    extends Action {
        protected AbstractProvisionNodeAction() {
        }

        public final void run() {
            NodeTreeGroup baseNodeGroup = null;
            INodeTreeNode node = ActionBuilderProvisionNodeTree.this.getNodeBase();
            baseNodeGroup = ActionBuilderProvisionNodeTree.this.setNodeGroupBase(node);
            this.doTask(baseNodeGroup, node);
        }

        protected abstract void doTask(NodeTreeGroup var1, INodeTreeNode var2);

        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL((URL)ActionBuilderProvisionNodeTree.this.bundle.getEntry("icons/reload.gif"));
        }

        public String getText() {
            return "Provision Node Tree reload";
        }

        public String getToolTipText() {
            return "Provision Node Tree reload";
        }
    }

    public final class ActionReloadProvisionNodeTree
    extends AbstractProvisionNodeAction {
        protected void doTask(NodeTreeGroup group, INodeTreeNode node) {
            this.setNodeTree();
        }

        public void setNodeTree() {
            Iterator it = null;
            for (String groupName : ActionBuilderProvisionNodeTree.this.groupMap.keySet()) {
                NodeTreeGroup nodeTreeGroup = (NodeTreeGroup)ActionBuilderProvisionNodeTree.this.groupMap.get(groupName);
                if (nodeTreeGroup == null) continue;
                NodeTreeGroup parentNodeTreeGroup = nodeTreeGroup.getParent();
                parentNodeTreeGroup.removeChildAll();
            }
            ActionBuilderProvisionNodeTree.this.groupMap.clear();
            ArrayList<ProvisionInfo> nodeList = new ArrayList<ProvisionInfo>();
            Iterator provisionIt = null;
            Map provisionMap = ProvisionInfoControl.getInstance().getProvisionInfoHashMap();
            for (String key : provisionMap.keySet()) {
                ProvisionInfo info = (ProvisionInfo)provisionMap.get(key);
                if (info == null) continue;
                nodeList.add(info);
            }
            if (nodeList == null) {
                return;
            }
            if (nodeList.size() == 0) {
                ActionBuilderProvisionNodeTree.this.nodeListTreeViewer.refresh();
                return;
            }
            int i = 0;
            while (i < nodeList.size()) {
                ProvisionInfo provisionInfo = (ProvisionInfo)nodeList.get(i);
                ActionBuilderProvisionNodeTree.this.createNodeTree(provisionInfo, true);
                ++i;
            }
            ActionBuilderProvisionNodeTree.this.setStatusLine(ActionBuilderProvisionNodeTree.this.groupMap.size(), nodeList.size());
        }
    }

    public final class ActionReloadProvisionNodeTreeSocket
    extends AbstractProvisionNodeAction {
        protected void doTask(NodeTreeGroup group, INodeTreeNode node) {
            this.setNodeTree();
        }

        public void setNodeTree() {
            Iterator it = null;
            for (String groupName : ActionBuilderProvisionNodeTree.this.groupMap.keySet()) {
                NodeTreeGroup nodeTreeGroup = (NodeTreeGroup)ActionBuilderProvisionNodeTree.this.groupMap.get(groupName);
                if (nodeTreeGroup == null) continue;
                NodeTreeGroup parentNodeTreeGroup = nodeTreeGroup.getParent();
                parentNodeTreeGroup.removeChildAll();
            }
            ActionBuilderProvisionNodeTree.this.groupMap.clear();
            String engineAddress = ClientEngineInfo.getClientEngineInfoInstance().getEngineAddress();
            ConnectionNodeInformation connectNodeInfo = new ConnectionNodeInformation(engineAddress);
            try {
                ArrayList nodeList = connectNodeInfo.getNodeInformationList(null, null);
                String[] nodeIPAddress = new String[nodeList.size()];
                String[] nodeName = new String[nodeList.size()];
                if (nodeList.size() == 0) {
                    ActionBuilderProvisionNodeTree.this.nodeListTreeViewer.refresh();
                    return;
                }
                ActionBuilderProvisionNodeTree.this.nodeInfoListSocket.clear();
                int i = 0;
                while (i < nodeList.size()) {
                    ProvisionInfo nodeInfo = (ProvisionInfo)nodeList.get(i);
                    ActionBuilderProvisionNodeTree.this.createNodeTree(nodeInfo, true);
                    ActionBuilderProvisionNodeTree.this.nodeInfoListSocket.add(nodeInfo);
                    nodeIPAddress[i] = nodeInfo.getIpAddress();
                    nodeName[i] = nodeInfo.getNodeName();
                    ++i;
                }
                ActionBuilderProvisionNodeTree.this.setStatusLine(ActionBuilderProvisionNodeTree.this.groupMap.size(), nodeList.size());
            }
            catch (EngineConnectException e) {
                Shell shell = new Shell();
                MessageDialog.openError((Shell)shell, (String)"Provision Node List import error", (String)e.getMessage());
                logger.warning("Provision Node List import error" + e.getMessage());
                shell.dispose();
                e.printStackTrace();
            }
            catch (IOException e) {
                Shell shell = new Shell();
                MessageDialog.openError((Shell)shell, (String)"Provision Node List import error", (String)e.getMessage());
                logger.warning("Provision Node List import error" + e.getMessage());
                shell.dispose();
                e.printStackTrace();
            }
        }
    }

    protected abstract class AbstractProvisionNodeSortAction
    extends AbstractProvisionNodeAction {
        protected AbstractProvisionNodeSortAction() {
        }

        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL((URL)ActionBuilderProvisionNodeTree.this.bundle.getEntry("icons/sort_obj.gif"));
        }

        public String getText() {
            return "Provision Node Tree sort";
        }

        public String getToolTipText() {
            return "Provision Node Tree sort";
        }
    }

    protected final class ActionSortProvisionNodeTree
    extends AbstractProvisionNodeSortAction {
        private String sortDirection0 = "asc";
        private String sortDirection1 = "asc";
        private boolean isSortToggle = true;

        protected ActionSortProvisionNodeTree() {
        }

        protected void doTask(NodeTreeGroup group, INodeTreeNode node) {
            if (this.isSortToggle) {
                this.sortDirection0 = "asc";
                this.sortDirection1 = "asc";
                this.isSortToggle = false;
            } else {
                this.sortDirection0 = "desc";
                this.sortDirection1 = "desc";
                this.isSortToggle = true;
            }
            Iterator it = null;
            for (String groupName : ActionBuilderProvisionNodeTree.this.groupMap.keySet()) {
                NodeTreeGroup nodeTreeGroup = (NodeTreeGroup)ActionBuilderProvisionNodeTree.this.groupMap.get(groupName);
                if (nodeTreeGroup == null) continue;
                NodeTreeGroup parentNodeTreeGroup = nodeTreeGroup.getParent();
                if (node instanceof NodeTreeGroup) {
                    parentNodeTreeGroup = (NodeTreeGroup)node;
                }
                parentNodeTreeGroup.removeChildAll();
            }
            ActionBuilderProvisionNodeTree.this.nodeTreeGroupRoot.removeChildAll();
            ActionBuilderProvisionNodeTree.this.groupMap.clear();
            this.setProvisionNodeTree();
        }

        protected void setProvisionNodeTree() {
            ArrayList<ProvisionInfo> provisionNodeList = new ArrayList<ProvisionInfo>();
            Iterator provisionIt = null;
            Map provisionMap = ProvisionInfoControl.getInstance().getProvisionInfoHashMap();
            for (String key : provisionMap.keySet()) {
                ProvisionInfo info = (ProvisionInfo)provisionMap.get(key);
                if (info == null) continue;
                provisionNodeList.add(info);
            }
            if (provisionNodeList == null) {
                return;
            }
            int i = 0;
            while (i < provisionNodeList.size()) {
                ProvisionInfo nodeInfo = (ProvisionInfo)provisionNodeList.get(i);
                ActionBuilderProvisionNodeTree.this.createNodeTree(nodeInfo, this.isSortToggle);
                ++i;
            }
        }
    }

    protected final class ActionSortProvisionNodeTreeSocket
    extends AbstractProvisionNodeSortAction {
        private boolean isSortToggle = true;

        protected ActionSortProvisionNodeTreeSocket() {
        }

        protected void doTask(NodeTreeGroup group, INodeTreeNode node) {
            this.isSortToggle = !this.isSortToggle;
            Iterator it = null;
            for (String groupName : ActionBuilderProvisionNodeTree.this.groupMap.keySet()) {
                NodeTreeGroup nodeTreeGroup = (NodeTreeGroup)ActionBuilderProvisionNodeTree.this.groupMap.get(groupName);
                if (nodeTreeGroup == null) continue;
                NodeTreeGroup parentNodeTreeGroup = nodeTreeGroup.getParent();
                if (node instanceof NodeTreeGroup) {
                    parentNodeTreeGroup = (NodeTreeGroup)node;
                }
                parentNodeTreeGroup.removeChildAll();
            }
            ActionBuilderProvisionNodeTree.this.nodeTreeGroupRoot.removeChildAll();
            ActionBuilderProvisionNodeTree.this.groupMap.clear();
            int i = 0;
            while (i < ActionBuilderProvisionNodeTree.this.nodeInfoListSocket.size()) {
                ProvisionInfo nodeInfo = (ProvisionInfo)ActionBuilderProvisionNodeTree.this.nodeInfoListSocket.get(i);
                ActionBuilderProvisionNodeTree.this.createNodeTree(nodeInfo, this.isSortToggle);
                ++i;
            }
        }
    }
}

