/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.provision.model.action;

import java.net.URL;
import java.util.logging.Logger;
import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.provision.gui.editor.EditorInputProvision;
import netjfwatcher.provision.gui.editor.EditorProvisionCommandFileView;
import netjfwatcher.provision.gui.editor.EditorProvisionScheduleView;
import netjfwatcher.provision.info.ProvisionInfo;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public class ActionBuilderProvisionNodeView
extends Action {
    private static IEditorPart editorNodeConfigView;
    private static Logger logger;
    private final Bundle bundle = NetJFWatcherPlugin.getInstance().getBundle();
    private IAction provisionScheduleViewAction = new ActionProvisionScheduleView();
    private IAction provisionScheduleViewSocketAction = new ActionProvisionScheduleViewSocket();
    private IAction provisionFileViewAction = new ActionProvisionFileView();
    private IAction provisionFileViewActionSocket = new ActionProvisionFileViewSocket();

    public ActionBuilderProvisionNodeView() {
        logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    }

    public IAction getActionProvisionScheduleView() {
        return this.provisionScheduleViewAction;
    }

    public IAction getActionProvisionScheduleViewSocket() {
        return this.provisionScheduleViewSocketAction;
    }

    public IAction getActionProvisionFileView() {
        return this.provisionFileViewAction;
    }

    public IAction getActionProvisionFileViewSocket() {
        return this.provisionFileViewActionSocket;
    }

    private abstract class AbstractProvisionNodeAction
    extends Action {
        private AbstractProvisionNodeAction() {
        }

        public final void run() {
            this.doTask();
        }

        protected abstract void doTask();

        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL((URL)ActionBuilderProvisionNodeView.this.bundle.getEntry("icons/file_obj.gif"));
        }

        public String getText() {
            return "Provision Node Schedule View";
        }

        public String getToolTipText() {
            return "Provision Node Schedule View";
        }
    }

    public final class ActionProvisionScheduleView
    extends AbstractProvisionNodeAction {
        private ProvisionInfo provisionInfo;

        protected void doTask() {
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            String nodeName = this.provisionInfo != null ? "ID=" + this.provisionInfo.getProvisionID() + " " + this.provisionInfo.getNodeName() + "(" + this.provisionInfo.getIpAddress() + ")" : "New ID ";
            try {
                activePage.openEditor((IEditorInput)new EditorInputProvision(String.valueOf(nodeName) + " Provision Schedule View", this.provisionInfo, false), EditorProvisionScheduleView.class.getName());
            }
            catch (PartInitException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }

        public void setNodeInfo(ProvisionInfo provisionInfo) {
            this.provisionInfo = provisionInfo;
        }
    }

    public final class ActionProvisionScheduleViewSocket
    extends AbstractProvisionNodeAction {
        private ProvisionInfo provisionInfo;

        protected void doTask() {
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            String nodeName = "ID=" + this.provisionInfo.getProvisionID() + " " + this.provisionInfo.getNodeName() + "(" + this.provisionInfo.getIpAddress() + ")";
            try {
                activePage.openEditor((IEditorInput)new EditorInputProvision(String.valueOf(nodeName) + " Provision Schedule View", this.provisionInfo, true), EditorProvisionScheduleView.class.getName());
            }
            catch (PartInitException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }

        public void setNodeInfo(ProvisionInfo provisionInfo) {
            this.provisionInfo = provisionInfo;
        }
    }

    public class ActionProvisionFileView
    extends AbstractProvisionNodeAction {
        protected ProvisionInfo provisionInfo;

        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL((URL)ActionBuilderProvisionNodeView.this.bundle.getEntry("icons/file_obj.gif"));
        }

        public String getText() {
            return "Provision Telnet Command File View";
        }

        public String getToolTipText() {
            return "Provision Telnet Command File View";
        }

        protected void doTask() {
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            if (this.provisionInfo == null) {
                this.provisionInfo = new ProvisionInfo();
                this.provisionInfo.setIpAddress(null);
            }
            try {
                if (editorNodeConfigView != null) {
                    activePage.closeEditor(editorNodeConfigView, false);
                    editorNodeConfigView = null;
                }
                editorNodeConfigView = activePage.openEditor((IEditorInput)new EditorInputProvision(" Provision File View", this.provisionInfo, false), EditorProvisionCommandFileView.class.getName());
            }
            catch (PartInitException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }

        public void setProvisionInfo(ProvisionInfo provisionInfo) {
            this.provisionInfo = provisionInfo;
        }
    }

    public class ActionProvisionFileViewSocket
    extends ActionProvisionFileView {
        protected void doTask() {
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            if (this.provisionInfo == null) {
                this.provisionInfo = new ProvisionInfo();
                this.provisionInfo.setIpAddress(null);
            }
            try {
                if (editorNodeConfigView != null) {
                    activePage.closeEditor(editorNodeConfigView, false);
                    editorNodeConfigView = null;
                }
                editorNodeConfigView = activePage.openEditor((IEditorInput)new EditorInputProvision(" Provision File View", this.provisionInfo, true), EditorProvisionCommandFileView.class.getName());
            }
            catch (PartInitException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }
    }
}

