/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.provision.model.action;

import java.net.URL;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.provision.command.core.LoggingProvision;
import netjfwatcher.provision.command.schedule.ProvisionCommandTaskScheduleControl;
import netjfwatcher.provision.command.schedule.ProvisionCommandTaskScheduleInfo;
import netjfwatcher.provision.info.ProvisionInfo;
import netjfwatcher.provision.info.ProvisionInfoControl;
import netjfwatcher.provision.model.action.ProvisionStartStopStatus;
import netjfwatcher.provision.nodemaneger.list.ProvisionMessageQueue;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public class ActionBuilderProvisionStartStop {
    private static Logger logger;
    private IAction startProvision = new ActionStartProvision();
    private IAction stopProvision = new ActionStopProvision();
    private final Bundle bundle = NetJFWatcherPlugin.getInstance().getBundle();

    public ActionBuilderProvisionStartStop() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public IAction getActionStartProvision() {
        return this.startProvision;
    }

    public IAction getActionStopProvision() {
        return this.stopProvision;
    }

    private abstract class AbstractEngineAction
    extends Action {
        private AbstractEngineAction() {
        }

        public final void run() {
            this.doTask();
        }

        protected abstract void doTask();
    }

    private final class ActionStartProvision
    extends AbstractEngineAction {
        private ActionStartProvision() {
        }

        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL((URL)ActionBuilderProvisionStartStop.this.bundle.getEntry("icons/engine.gif"));
        }

        public String getText() {
            return "Provision start";
        }

        public String getToolTipText() {
            return "Provision start";
        }

        protected void doTask() {
            this.startProvision();
        }

        private void startProvision() {
            final Shell shell = new Shell();
            if (ProvisionStartStopStatus.getInstance().isRunProvision()) {
                MessageDialog.openWarning((Shell)shell, (String)"Provision Timer.", (String)"Already Start Provision Timer.");
                if (shell != null) {
                    shell.dispose();
                }
                return;
            }
            ProvisionStartStopStatus.getInstance().setRunProvision(true);
            BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    ActionStartProvision.this.startProvision(shell);
                }
            });
            if (shell != null) {
                shell.dispose();
            }
        }

        private void startProvision(Shell shell) {
            LoggingProvision.getInstance().startLog();
            Map provisionMap = ProvisionInfoControl.getInstance().getProvisionInfoHashMap();
            Iterator it = null;
            for (String key : provisionMap.keySet()) {
                ProvisionInfo provisionInfo = (ProvisionInfo)provisionMap.get(key);
                if (provisionInfo == null) continue;
                provisionInfo.setCommandResult("waiting...");
                ProvisionInfoControl.getInstance().setProvisionInfo(provisionInfo.getProvisionID(), provisionInfo);
                ProvisionMessageQueue.getInstance().pushProvisionMessage(provisionInfo.getIpAddress());
                Date setStartDate = null;
                setStartDate = provisionInfo.getStartDate() != null ? provisionInfo.getStartDate() : Calendar.getInstance().getTime();
                ProvisionCommandTaskScheduleControl.getInstance().setTaskSchedule(provisionInfo, setStartDate);
            }
        }
    }

    private final class ActionStopProvision
    extends AbstractEngineAction {
        private ActionStopProvision() {
        }

        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL((URL)ActionBuilderProvisionStartStop.this.bundle.getEntry("icons/engine_stop.gif"));
        }

        public String getText() {
            return "Provision stop";
        }

        public String getToolTipText() {
            return "Provision stop";
        }

        protected void doTask() {
            ProvisionStartStopStatus.getInstance().setRunProvision(false);
            Shell shell = new Shell();
            BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    ActionStopProvision.this.stopProvision();
                }
            });
            if (shell != null) {
                shell.dispose();
            }
        }

        private void stopProvision() {
            LoggingProvision.getInstance().stopLog();
            Map provisionMap = ProvisionInfoControl.getInstance().getProvisionInfoHashMap();
            Map taskScheduleMap = ProvisionCommandTaskScheduleControl.getInstance().getTaskScheduleMap();
            Iterator it = null;
            for (String provisionIDKey : provisionMap.keySet()) {
                ProvisionCommandTaskScheduleInfo taskScheduleInfo = (ProvisionCommandTaskScheduleInfo)taskScheduleMap.get(provisionIDKey);
                if (taskScheduleInfo == null) continue;
                ProvisionCommandTaskScheduleControl.getInstance().cancelTaskSchedule(taskScheduleInfo);
                ProvisionMessageQueue.getInstance().pushProvisionMessage(provisionIDKey);
            }
        }
    }
}

