/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.provision.model.action;

import java.util.logging.Logger;
import netjfwatcher.common.view.NodeTreeGroup;
import netjfwatcher.provision.gui.editor.EditorInputProvision;
import netjfwatcher.provision.gui.editor.EditorProvisionScheduleView;
import netjfwatcher.provision.info.ProvisionInfo;
import netjfwatcher.provision.info.ProvisionInfoControl;
import netjfwatcher.provision.model.action.ProvisionNodeTree;
import netjfwatcher.socketclient.NetworkClientNodeTreeView;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class ListenerProvisionNodeListTree
implements ISelectionChangedListener {
    private static Logger logger = null;
    private boolean isSocket;

    public ListenerProvisionNodeListTree(boolean isSocket) {
        logger = Logger.getLogger(this.getClass().getName());
        this.isSocket = isSocket;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        StructuredSelection ss = (StructuredSelection)event.getSelection();
        logger.info("Tree node  select : " + ss.getFirstElement());
        if (ss.getFirstElement() instanceof NodeTreeGroup) {
            logger.info("NodeTreeGroup ");
            return;
        }
        if (!(ss.getFirstElement() instanceof ProvisionNodeTree)) {
            logger.info("No NodeTree ");
            return;
        }
        ProvisionNodeTree entry = (ProvisionNodeTree)((Object)ss.getFirstElement());
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        ProvisionInfo provisionInfo = ProvisionInfoControl.getInstance().getProvisionInfo(entry.getProvisionInfo().getProvisionID());
        String nodeName = "ID=" + provisionInfo.getProvisionID() + " " + provisionInfo.getNodeName() + "(" + provisionInfo.getIpAddress() + ")";
        try {
            activePage.openEditor((IEditorInput)new EditorInputProvision(String.valueOf(nodeName) + " Provision Schedule View", provisionInfo, false), EditorProvisionScheduleView.class.getName());
        }
        catch (PartInitException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
        }
        try {
            if (!this.isSocket) {
                activePage.openEditor((IEditorInput)new EditorInputProvision(String.valueOf(nodeName) + " Provision Schedule View", provisionInfo, this.isSocket), EditorProvisionScheduleView.class.getName());
            } else {
                activePage.openEditor((IEditorInput)new EditorInputProvision(String.valueOf(nodeName) + " Provision Schedule View" + NetworkClientNodeTreeView.getTitleSuffixEngineAddress(), provisionInfo, this.isSocket), EditorProvisionScheduleView.class.getName());
            }
        }
        catch (PartInitException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
        }
    }
}

