/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.provision.nodemaneger.list;

import java.io.IOException;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.common.view.AbstractTableView;
import netjfwatcher.common.view.TableListViewColor;
import netjfwatcher.engine.model.action.ActionBuilderEditorsPartClose;
import netjfwatcher.engine.model.action.MediaResource;
import netjfwatcher.engine.resource.SystemResourceConfig;
import netjfwatcher.engine.view.editorpart.common.TableColumnControlTableListener;
import netjfwatcher.provision.info.ProvisionInfo;
import netjfwatcher.provision.info.ProvisionInfoControl;
import netjfwatcher.provision.model.action.ActionBuilderProvisionNodeList;
import netjfwatcher.provision.model.action.ActionBuilderProvisionNodeView;
import netjfwatcher.provision.model.action.ActionBuilderProvisionStartStop;
import netjfwatcher.provision.nodemaneger.list.ProvisionNodeListTableViewContentProvider;
import netjfwatcher.provision.nodemaneger.list.ProvisionNodeListTableViewLabelProvider;
import netjfwatcher.provision.nodemaneger.list.ProvisionTableTimerProcessor;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public class ProvisionNodeListTableView
extends AbstractTableView {
    protected static final int COUNT_TEXT_WIDTH = 100;
    protected static boolean isCol0Direction = false;
    protected static boolean isCol1Direction = true;
    protected static boolean isCol2Direction = true;
    protected static boolean isCol3Direction = true;
    protected static boolean isCol4Direction = true;
    protected static boolean isCol5Direction = true;
    protected static boolean isCol6Direction = true;
    protected static boolean isCol7Direction = true;
    private static Logger logger = null;
    protected static int[] imageColumn = new int[]{2};
    protected static Text nodeCountText;
    protected static Button refreshButton;
    private static final float COLUMN0_NO = 0.05f;
    private static final float COLUMN1_ID = 0.05f;
    private static final float COLUMN2_NAME = 0.1f;
    private static final float COLUMN3_GROUP = 0.1f;
    private static final float COLUMN4_ADDRESS = 0.1f;
    private static final float COLUMN5_START_DATE = 0.1f;
    private static final float COLUMN6_COMMAND_FILE = 0.1f;
    private static final float COLUMN7_COMMAND_RESULT = 0.2f;
    protected Display display;
    protected Table table;
    protected Color textBackColor;
    protected TableViewer viewer;
    protected TableColumn col0;
    protected TableColumn col1;
    protected TableColumn col2;
    protected TableColumn col3;
    protected TableColumn col4;
    protected TableColumn col5;
    protected TableColumn col6;
    protected TableColumn col7;
    protected HashMap provisionInfoIDMap = new HashMap();
    protected final Bundle bundle = NetJFWatcherPlugin.getInstance().getBundle();
    private ActionBuilderProvisionStartStop provisionStartStop = new ActionBuilderProvisionStartStop();
    protected ProvisionTableListAction provisionTableListAction = new ProvisionTableListAction();
    protected ActionBuilderProvisionNodeView actionProvisionNodeOperation = new ActionBuilderProvisionNodeView();
    protected ActionBuilderEditorsPartClose actionBuilderEditorPart = new ActionBuilderEditorsPartClose();
    protected SubStatusLineManager statusLineManager;
    protected String selectID;
    private static Color WHITE_COLOR;
    private static Color BLACK_COLOR;
    private static Color RED_COLOR;
    private static Color BLUE_COLOR;
    private static Color GREEN_COLOR;
    private DateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd (EEE) HH:mm:ss");
    protected HashMap nodeIconImageMap = new HashMap();
    private static final int PROVISION_TIMER = 1000;
    private ProvisionTableTimerProcessor timerProcessor;

    static {
        WHITE_COLOR = new Color(null, 255, 255, 255);
        BLACK_COLOR = new Color(null, 0, 0, 0);
        RED_COLOR = new Color(null, 255, 0, 0);
        BLUE_COLOR = new Color(null, 0, 0, 255);
        GREEN_COLOR = new Color(null, 0, 128, 0);
    }

    public ProvisionNodeListTableView() {
        logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
        this.textBackColor = WHITE_COLOR;
    }

    public void setFocus() {
    }

    public TableViewer getViewer() {
        return this.viewer;
    }

    public void createPartControl(Composite parent) {
        this.display = parent.getDisplay();
        this.createTable(parent);
        this.viewer = new TableViewer(this.table);
        this.viewer.setUseHashlookup(true);
        this.viewer.setContentProvider((IContentProvider)new ProvisionNodeListTableViewContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ProvisionNodeListTableViewLabelProvider());
        this.createContextMenu();
        this.setToolBarActions();
        this.setProvisionTableListView(false);
        this.setStatusLine();
        this.table.addSelectionListener((SelectionListener)new TableColumnControlTableListener(this.table, 5));
        this.table.addSelectionListener((SelectionListener)new TableColumnControlTableListener(this.table, 7));
        this.table.addSelectionListener((SelectionListener)new TableColumnControlTableListener(this.table, 6));
        this.startTimer();
    }

    protected int computeCol0Width() {
        return (int)((float)this.getSite().getShell().getSize().x * 0.05f);
    }

    protected int computeCol1Width() {
        return (int)((float)this.getSite().getShell().getSize().x * 0.05f);
    }

    protected int computeCol2Width() {
        return (int)((float)this.getSite().getShell().getSize().x * 0.1f);
    }

    protected int computeCol3Width() {
        return (int)((float)this.getSite().getShell().getSize().x * 0.1f);
    }

    protected int computeCol4Width() {
        return (int)((float)this.getSite().getShell().getSize().x * 0.1f);
    }

    protected int computeCol5Width() {
        return (int)((float)this.getSite().getShell().getSize().x * 0.1f);
    }

    protected int computeCol6Width() {
        return (int)((float)this.getSite().getShell().getSize().x * 0.1f);
    }

    protected int computeCol7Width() {
        return (int)((float)this.getSite().getShell().getSize().x * 0.2f);
    }

    protected void createTable(Composite parent) {
        this.statusLineManager = (SubStatusLineManager)this.getViewSite().getActionBars().getStatusLineManager();
        this.statusLineManager.setVisible(true);
        int snmpPort = SystemResourceConfig.getInstance().getResourceFileParse().getResourceInfo().getSnmpPort();
        this.statusLineManager.setMessage("Snmp Port=" + snmpPort);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        parent.setLayout((Layout)gridLayout);
        Composite operationContainer = new Composite(parent, 0);
        operationContainer.setLayout((Layout)new RowLayout(256));
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        operationContainer.setLayoutData((Object)data);
        Label nodeCountLabel = new Label(operationContainer, 0);
        nodeCountLabel.setText("Node Count");
        nodeCountText = new Text(operationContainer, 133128);
        nodeCountText.setLayoutData((Object)new RowData(100, -1));
        nodeCountText.setEditable(false);
        nodeCountText.setEnabled(false);
        nodeCountText.setBackground(this.textBackColor);
        refreshButton = new Button(operationContainer, 0);
        refreshButton.setText("Refresh");
        GridData data2 = new GridData();
        data2.horizontalAlignment = 4;
        data2.verticalAlignment = 4;
        data2.grabExcessHorizontalSpace = true;
        data2.grabExcessVerticalSpace = true;
        this.table = new Table(parent, 68354);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        this.table.setLayoutData((Object)data2);
        this.col0 = new TableColumn(this.table, 0x1000000);
        this.col0.setText(ProvisionNodeListTableViewLabelProvider.NODE_LIST_TABLE_COLUMNS[0]);
        this.col0.setWidth(this.computeCol0Width());
        this.col1 = new TableColumn(this.table, 0x1000000);
        this.col1.setText(ProvisionNodeListTableViewLabelProvider.NODE_LIST_TABLE_COLUMNS[1]);
        this.col1.setWidth(this.computeCol1Width());
        this.col2 = new TableColumn(this.table, 0x1000000);
        this.col2.setText(ProvisionNodeListTableViewLabelProvider.NODE_LIST_TABLE_COLUMNS[2]);
        this.col2.setWidth(this.computeCol2Width());
        this.col3 = new TableColumn(this.table, 0x1000000);
        this.col3.setText(ProvisionNodeListTableViewLabelProvider.NODE_LIST_TABLE_COLUMNS[3]);
        this.col3.setWidth(this.computeCol3Width());
        this.col4 = new TableColumn(this.table, 0x1000000);
        this.col4.setText(ProvisionNodeListTableViewLabelProvider.NODE_LIST_TABLE_COLUMNS[4]);
        this.col4.setWidth(this.computeCol4Width());
        this.col5 = new TableColumn(this.table, 0x1000000);
        this.col5.setText(ProvisionNodeListTableViewLabelProvider.NODE_LIST_TABLE_COLUMNS[5]);
        this.col5.setWidth(this.computeCol5Width());
        this.col6 = new TableColumn(this.table, 0x1000000);
        this.col6.setText(ProvisionNodeListTableViewLabelProvider.NODE_LIST_TABLE_COLUMNS[6]);
        this.col6.setWidth(this.computeCol6Width());
        this.col7 = new TableColumn(this.table, 0x1000000);
        this.col7.setText(ProvisionNodeListTableViewLabelProvider.NODE_LIST_TABLE_COLUMNS[7]);
        this.col7.setWidth(this.computeCol7Width());
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent event) {
            }

            public void controlResized(ControlEvent event) {
                ProvisionNodeListTableView.this.setResizedTableColumnWidth();
            }
        });
        this.col0.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                isCol0Direction = ProvisionNodeListTableView.this.sortIntegerTable(ProvisionNodeListTableView.this.table, 0, isCol0Direction, imageColumn);
            }
        });
        this.col1.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                isCol1Direction = ProvisionNodeListTableView.this.sortIntegerTable(ProvisionNodeListTableView.this.table, 1, isCol1Direction, imageColumn);
            }
        });
        this.col2.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                isCol2Direction = ProvisionNodeListTableView.this.sortIntegerTable(ProvisionNodeListTableView.this.table, 2, isCol2Direction, imageColumn);
            }
        });
        this.col3.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                isCol3Direction = ProvisionNodeListTableView.this.sortTable(ProvisionNodeListTableView.this.table, 3, isCol3Direction, imageColumn);
            }
        });
        this.col4.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                isCol4Direction = ProvisionNodeListTableView.this.sortTable(ProvisionNodeListTableView.this.table, 4, isCol4Direction, imageColumn);
            }
        });
        this.col5.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                isCol5Direction = ProvisionNodeListTableView.this.sortTable(ProvisionNodeListTableView.this.table, 5, isCol5Direction, imageColumn);
            }
        });
        this.col6.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                isCol6Direction = ProvisionNodeListTableView.this.sortTable(ProvisionNodeListTableView.this.table, 6, isCol6Direction, imageColumn);
            }
        });
        this.col7.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                isCol7Direction = ProvisionNodeListTableView.this.sortTable(ProvisionNodeListTableView.this.table, 7, isCol7Direction, imageColumn);
            }
        });
        refreshButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                refreshButton.setEnabled(false);
                ProvisionNodeListTableView.this.setProvisionTableListView(true);
                refreshButton.setEnabled(true);
                ProvisionNodeListTableView.this.setStatusLine();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
    }

    protected TableItem setTableItem(Table paraTable, TableItem item, String[] strs) {
        Color obj0 = item.getForeground();
        Color obj1 = item.getBackground();
        Color obj = item.getForeground(7);
        Image image1 = item.getImage(2);
        item.dispose();
        item = new TableItem(paraTable, 0);
        item.setText(strs);
        item.setData((Object)strs);
        item.setForeground(obj0);
        item.setBackground(obj1);
        item.setForeground(7, obj);
        item.setImage(2, image1);
        return item;
    }

    private void createContextMenu() {
        MenuManager mm = new MenuManager();
        mm.setRemoveAllWhenShown(true);
        mm.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ProvisionNodeListTableView.this.fillContextMenu(manager);
            }
        });
        Menu menu = mm.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(mm, (ISelectionProvider)this.viewer);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IContributionItem)new GroupMarker("additions"));
        manager.add(this.provisionTableListAction.getActionShowProvisionTable());
        manager.add(this.provisionTableListAction.getActionImportNodeListFile());
        manager.add(this.provisionTableListAction.getActionExportNodeListFile());
        if (this.table.getSelectionIndex() >= 0 && this.table.getSelection() != null) {
            TableItem[] item = this.table.getSelection();
            String[] provisionIDInfo = (String[])item[0].getData();
            this.selectID = provisionIDInfo[1];
            ProvisionInfo targetNodeInfo = (ProvisionInfo)this.provisionInfoIDMap.get(this.selectID);
            ((ActionBuilderProvisionNodeView.ActionProvisionScheduleView)this.actionProvisionNodeOperation.getActionProvisionScheduleView()).setNodeInfo(targetNodeInfo);
            manager.add(this.actionProvisionNodeOperation.getActionProvisionScheduleView());
            ((ActionBuilderProvisionNodeView.ActionProvisionFileView)this.actionProvisionNodeOperation.getActionProvisionFileView()).setProvisionInfo(targetNodeInfo);
            manager.add(this.actionProvisionNodeOperation.getActionProvisionFileView());
        }
    }

    private void setToolBarActions() {
        IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        toolBarManager.add(this.provisionTableListAction.getActionShowProvisionTable());
        toolBarManager.add(this.provisionStartStop.getActionStartProvision());
        toolBarManager.add(this.provisionStartStop.getActionStopProvision());
        toolBarManager.add(this.provisionTableListAction.getActionImportNodeListFile());
        toolBarManager.add(this.provisionTableListAction.getActionExportNodeListFile());
        toolBarManager.add(this.provisionTableListAction.getActionRemoveProvisionNodeListTable());
        toolBarManager.add(this.actionBuilderEditorPart.actionCloseAllEditors());
    }

    public void setProvisionTableListView(boolean isProvisionList) {
        this.table.removeAll();
        this.viewer.refresh();
        this.provisionInfoIDMap.clear();
        ArrayList provisionInfoList = null;
        if (isProvisionList) {
            provisionInfoList = this.getProvisionList();
        }
        if (provisionInfoList == null) {
            nodeCountText.setText("0");
            return;
        }
        nodeCountText.setText(Integer.toString(provisionInfoList.size()));
        int i = 0;
        while (i < provisionInfoList.size()) {
            ProvisionInfo provisionInfo = (ProvisionInfo)provisionInfoList.get(i);
            this.provisionInfoIDMap.put(provisionInfo.getProvisionID(), provisionInfo);
            String[] tableCellArray = new String[ProvisionNodeListTableViewLabelProvider.NODE_LIST_TABLE_COLUMNS.length];
            tableCellArray[0] = Integer.toString(i + 1);
            tableCellArray[1] = provisionInfo.getProvisionID();
            tableCellArray[2] = provisionInfo.getNodeName();
            tableCellArray[3] = provisionInfo.getGroup();
            tableCellArray[4] = provisionInfo.getIpAddress();
            tableCellArray[5] = provisionInfo.getStartDate() != null ? this.dateformat.format(provisionInfo.getStartDate()) : "";
            StringBuffer fileState = new StringBuffer("");
            boolean isSetTelnetFile = false;
            if (provisionInfo.getCommandFile() != null && !provisionInfo.getCommandFile().equals("")) {
                fileState.append("telnet=" + provisionInfo.getCommandFile());
                isSetTelnetFile = true;
            }
            if (provisionInfo.getFtpSourceFile() != null && !provisionInfo.getFtpSourceFile().equals("")) {
                if (isSetTelnetFile) {
                    fileState.append("/");
                }
                fileState.append("ftp source=" + provisionInfo.getFtpSourceFile());
            }
            tableCellArray[6] = fileState.toString();
            tableCellArray[7] = provisionInfo.getCommandResult() != null && !provisionInfo.getCommandResult().equals("") ? provisionInfo.getCommandResult() : "";
            TableItem item = new TableItem(this.table, 0);
            item.setText(tableCellArray);
            item.setData((Object)tableCellArray);
            Image nodeIconImage = this.createNodeIconImage(provisionInfo.getNodeKind());
            item.setImage(2, nodeIconImage);
            if (i % 2 == 0) {
                item.setBackground(TableListViewColor.getInstance().getNodeListOddBackgroundColor());
                item.setForeground(TableListViewColor.getInstance().getNodeListOddForgroundColor());
            } else {
                item.setBackground(TableListViewColor.getInstance().getNodeListEvenBackgroundColor());
                item.setForeground(TableListViewColor.getInstance().getNodeListEvenForgroundColor());
            }
            if (provisionInfo.getCommandResult() != null) {
                if (provisionInfo.getCommandResult().indexOf("abort") >= 0) {
                    item.setForeground(7, RED_COLOR);
                } else if (provisionInfo.getCommandResult().indexOf("login fail") >= 0) {
                    item.setForeground(7, RED_COLOR);
                } else if (provisionInfo.getCommandResult().equals("cancel")) {
                    item.setForeground(7, GREEN_COLOR);
                } else if (provisionInfo.getCommandResult().equals("complete")) {
                    item.setForeground(7, BLACK_COLOR);
                } else if (provisionInfo.getCommandResult().equals("waiting...")) {
                    item.setForeground(7, BLUE_COLOR);
                }
            } else {
                item.setForeground(7, BLACK_COLOR);
            }
            ++i;
        }
    }

    protected Image createNodeIconImage(String nodeKind) {
        String node16IconFileName = MediaResource.getInstance().getNodeIcon16FileName(nodeKind);
        Image nodeIconImage = null;
        if (!this.nodeIconImageMap.containsKey(node16IconFileName)) {
            URL url = null;
            url = this.bundle.getEntry(node16IconFileName);
            if (url == null) {
                logger.severe("Npt found icon file : " + node16IconFileName);
            } else {
                try {
                    nodeIconImage = new Image((Device)this.display, url.openStream());
                    this.nodeIconImageMap.put(node16IconFileName, nodeIconImage);
                }
                catch (IOException e) {
                    logger.warning("Abort create image " + e.getMessage() + " for " + node16IconFileName);
                    e.printStackTrace();
                }
            }
        } else {
            nodeIconImage = (Image)this.nodeIconImageMap.get(node16IconFileName);
        }
        return nodeIconImage;
    }

    public ArrayList getProvisionList() {
        ArrayList<ProvisionInfo> provisionList = new ArrayList<ProvisionInfo>();
        Iterator it = null;
        Map provisionMap = ProvisionInfoControl.getInstance().getProvisionInfoHashMap();
        for (String key : provisionMap.keySet()) {
            ProvisionInfo provisionInfo = (ProvisionInfo)provisionMap.get(key);
            if (provisionInfo == null) continue;
            provisionList.add(provisionInfo);
        }
        return provisionList;
    }

    protected void setStatusLine() {
        this.statusLineManager = (SubStatusLineManager)this.getViewSite().getActionBars().getStatusLineManager();
        this.statusLineManager.setVisible(true);
        this.statusLineManager.setMessage("Node List View Node count=" + this.provisionInfoIDMap.size());
    }

    protected void setResizedTableColumnWidth() {
        if (this.getSite().getPage().isPartVisible(this.getSite().getPart()) && this.getSite().getShell() != null) {
            this.getSite().getShell().getSize();
        }
    }

    private void startTimer() {
        ProvisionTableTimerProcessor.getInstance().setDisplay(this.display);
        ProvisionTableTimerProcessor.getInstance().setTable(this);
        this.timerProcessor = ProvisionTableTimerProcessor.getInstance();
        this.display.timerExec(1000, (Runnable)this.timerProcessor);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        HashMap list = this.nodeIconImageMap;
        Iterator it = null;
        for (String key : list.keySet()) {
            Image nodeIconImage = (Image)list.get(key);
            if (nodeIconImage == null) continue;
            nodeIconImage.dispose();
        }
        if (this.table != null) {
            this.table.dispose();
        }
        this.display.timerExec(-1, (Runnable)this.timerProcessor);
    }

    protected final class ProvisionTableListAction
    extends ActionBuilderProvisionNodeList {
        protected ProvisionTableListAction() {
        }

        protected void refreshProvisionTable() {
            ProvisionNodeListTableView.this.setProvisionTableListView(true);
        }
    }
}

