/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.provision.nodemaneger.list;

import java.util.logging.Logger;
import netjfwatcher.common.view.AbstractNodeTreeView;
import netjfwatcher.common.view.NodeTreeGroup;
import netjfwatcher.provision.info.ProvisionInfo;
import netjfwatcher.provision.info.ProvisionInfoControl;
import netjfwatcher.provision.model.action.ActionBuilderProvisionNodeTree;
import netjfwatcher.provision.model.action.ActionBuilderProvisionNodeView;
import netjfwatcher.provision.model.action.ListenerProvisionNodeListTree;
import netjfwatcher.provision.model.action.ProvisionNodeTree;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TreeItem;

public class ProvisionNodeTreeView
extends AbstractNodeTreeView {
    private static Logger logger = null;
    protected ActionBuilderProvisionNodeTree actionProvisionNodeTree;
    protected ActionBuilderProvisionNodeView actionProvisionNodeOperation = new ActionBuilderProvisionNodeView();

    public ProvisionNodeTreeView() {
        logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    }

    protected void initShow() {
    }

    public void createContextMenu() {
        this.actionProvisionNodeTree = new ActionBuilderProvisionNodeTree(this, this.nodeListTreeViewer, this.parentComposite, this.nodeTreeGroupRoot);
        MenuManager mm = new MenuManager();
        mm.setRemoveAllWhenShown(true);
        mm.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ProvisionNodeTreeView.this.fillContextMenu(manager);
            }
        });
        Menu menu = mm.createContextMenu(this.nodeListTreeViewer.getControl());
        this.nodeListTreeViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(mm, (ISelectionProvider)this.nodeListTreeViewer);
    }

    protected void setToolBarActions() {
        IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        toolBarManager.add(this.actionProvisionNodeTree.actionReloadProvisionNodeTree());
        toolBarManager.add(this.actionProvisionNodeTree.actionSortProvisionNodeTree());
        toolBarManager.add(this.actionProvisionNodeOperation.getActionProvisionScheduleView());
        toolBarManager.add(this.actionBuilderEditorPart.actionCloseAllEditors());
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IContributionItem)new GroupMarker("additions"));
        manager.add(this.actionProvisionNodeTree.actionReloadProvisionNodeTree());
        manager.add(this.actionProvisionNodeTree.actionSortProvisionNodeTree());
        if (this.nodeListTreeViewer.getTree().getSelection() != null) {
            TreeItem[] treeItem = this.nodeListTreeViewer.getTree().getSelection();
            if (treeItem != null && treeItem.length > 0) {
                int nodeTreeSelectNo = 0;
                while (nodeTreeSelectNo < treeItem.length) {
                    if (treeItem[nodeTreeSelectNo].getData() instanceof NodeTreeGroup) {
                        this.nodeListTreeViewer.getTree().deselectAll();
                    } else if (treeItem[nodeTreeSelectNo].getData() instanceof ProvisionNodeTree) {
                        ProvisionInfo targetProvisionNodeInfo = ProvisionInfoControl.getInstance().getProvisionInfo(((ProvisionNodeTree)((Object)treeItem[nodeTreeSelectNo].getData())).getProvisionInfo().getProvisionID());
                        ((ActionBuilderProvisionNodeView.ActionProvisionScheduleView)this.actionProvisionNodeOperation.getActionProvisionScheduleView()).setNodeInfo(targetProvisionNodeInfo);
                        manager.add(this.actionProvisionNodeOperation.getActionProvisionScheduleView());
                        ((ActionBuilderProvisionNodeView.ActionProvisionFileView)this.actionProvisionNodeOperation.getActionProvisionFileView()).setProvisionInfo(targetProvisionNodeInfo);
                        manager.add(this.actionProvisionNodeOperation.getActionProvisionFileView());
                    } else {
                        this.nodeListTreeViewer.getTree().deselectAll();
                    }
                    ++nodeTreeSelectNo;
                }
            } else {
                manager.add(this.actionBuilderNodeOperation.getActionNodeOperation());
            }
        }
    }

    protected void setupNodeTreeViewListener() {
        this.nodeListTreeViewer.addSelectionChangedListener((ISelectionChangedListener)new ListenerProvisionNodeListTree(false));
    }
}

