/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.provisionlog.gui.action;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Logger;
import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.provisionlog.gui.treenode.IProvisionLogTreeNode;
import netjfwatcher.provisionlog.gui.treenode.ProvisionLogNodeTree;
import netjfwatcher.provisionlog.gui.treenode.ProvisionLogNodeTreeGroup;
import netjfwatcher.provisionlog.gui.treeview.AbstractProvisionLogNodeTreeView;
import netjfwatcher.provisionlog.gui.treeview.ProvisionLogNodeTreeViewSorter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Bundle;

public class ActionBuilderNodeTree
extends Action {
    private static Logger logger = null;
    private HashMap nodeIconImageMap = new HashMap();
    private TreeViewer provisionLogNodeTreeViewer;
    private AbstractProvisionLogNodeTreeView nodeTreeView;
    private SubStatusLineManager statusLineManager;
    private Composite parentComposite;
    private ProvisionLogNodeTreeGroup nodeTreeGroupRoot;
    private Image fileObjImage;
    private HashMap groupMap = new HashMap();
    private final Bundle bundle = NetJFWatcherPlugin.getInstance().getBundle();
    private IAction reloadNodeTreeDatabase = new ActionReloadNodeTree();
    private IAction sortNodeTreeDatabase = new ActionSortNodeTreeDatabase();
    private IAction actionRemoveProvisionLogFile = new ActionRemoveProvisionLogFile();

    public ActionBuilderNodeTree() {
        logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
        this.createLogNodeIconImage();
    }

    public ActionBuilderNodeTree(AbstractProvisionLogNodeTreeView nodeTreeView, TreeViewer nodeListTreeViewer, Composite parentComposite, ProvisionLogNodeTreeGroup nodeTreeGroupRoot) {
        logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
        this.nodeTreeView = nodeTreeView;
        this.provisionLogNodeTreeViewer = nodeListTreeViewer;
        this.parentComposite = parentComposite;
        this.nodeTreeGroupRoot = nodeTreeGroupRoot;
        this.createLogNodeIconImage();
    }

    public TreeViewer getViewer() {
        return this.provisionLogNodeTreeViewer;
    }

    public IAction actionReloadNodeTreeDatabase() {
        return this.reloadNodeTreeDatabase;
    }

    public IAction actionSortNodeTreeDatabase() {
        return this.sortNodeTreeDatabase;
    }

    public IAction getActionRemoveProvisionLogFile() {
        return this.actionRemoveProvisionLogFile;
    }

    public void createNodeTree(final boolean isSortDirectionTreeView) {
        File fleDir = new File("./provision/log/");
        File[] fileList = fleDir.listFiles();
        if (fileList != null) {
            int fileCount = 0;
            while (fileCount < fileList.length) {
                if (fileList[fileCount].isDirectory()) {
                    ProvisionLogNodeTreeGroup logNodeTreeGroup = null;
                    String group = fileList[fileCount].getName();
                    if (this.groupMap.containsKey(group)) {
                        logNodeTreeGroup = (ProvisionLogNodeTreeGroup)this.groupMap.get(group);
                    } else {
                        logNodeTreeGroup = new ProvisionLogNodeTreeGroup(group);
                        this.nodeTreeGroupRoot.addChild(logNodeTreeGroup);
                        this.groupMap.put(group, logNodeTreeGroup);
                    }
                    this.nodeTreeGroupRoot.addChild(logNodeTreeGroup);
                } else if (fileList[fileCount].isFile()) {
                    this.nodeTreeGroupRoot.addChild(new ProvisionLogNodeTree(fileList[fileCount].getName(), fileList[fileCount].getName(), fileList[fileCount], this.fileObjImage));
                }
                ++fileCount;
            }
        }
        this.provisionLogNodeTreeViewer.setSorter((ViewerSorter)new ProvisionLogNodeTreeViewSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                String name2;
                String name1;
                int cat2;
                int cat1 = this.category(e1);
                if (cat1 != (cat2 = this.category(e2))) {
                    return cat1 - cat2;
                }
                if (viewer == null || !(viewer instanceof ContentViewer)) {
                    name1 = e1.toString();
                    name2 = e2.toString();
                } else {
                    IBaseLabelProvider prov = ((ContentViewer)viewer).getLabelProvider();
                    if (prov instanceof ILabelProvider) {
                        ILabelProvider lprov = (ILabelProvider)prov;
                        name1 = lprov.getText(e1);
                        name2 = lprov.getText(e2);
                    } else {
                        name1 = e1.toString();
                        name2 = e2.toString();
                    }
                }
                if (name1 == null) {
                    name1 = "";
                }
                if (name2 == null) {
                    name2 = "";
                }
                if (isSortDirectionTreeView) {
                    return this.collator.compare(name1, name2);
                }
                return this.collator.compare(name2, name1);
            }
        });
        this.provisionLogNodeTreeViewer.expandAll();
        this.provisionLogNodeTreeViewer.refresh();
    }

    protected void setStatusLine(int groupNo, int nodeNo) {
        this.statusLineManager = (SubStatusLineManager)this.nodeTreeView.getViewSite().getActionBars().getStatusLineManager();
        this.statusLineManager.setVisible(true);
        this.statusLineManager.setMessage("Node Tree View Group count=" + groupNo + " Node count=" + nodeNo);
    }

    public IProvisionLogTreeNode getNodeBase() {
        IStructuredSelection selectElement = (IStructuredSelection)this.getViewer().getSelection();
        IProvisionLogTreeNode node = (IProvisionLogTreeNode)selectElement.getFirstElement();
        if (node == null) {
            node = (IProvisionLogTreeNode)this.getViewer().getInput();
        }
        return node;
    }

    public ProvisionLogNodeTreeGroup setNodeGroupBase(IProvisionLogTreeNode node) {
        ProvisionLogNodeTreeGroup baseNodeGroup = null;
        if (node != null) {
            baseNodeGroup = node.getParent();
        }
        if (node instanceof ProvisionLogNodeTreeGroup) {
            baseNodeGroup = (ProvisionLogNodeTreeGroup)node;
        }
        return baseNodeGroup;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        HashMap list = this.nodeIconImageMap;
        Iterator it = null;
        for (String key : list.keySet()) {
            Image nodeIconImage = (Image)list.get(key);
            if (nodeIconImage == null) continue;
            nodeIconImage.dispose();
        }
    }

    private void createLogNodeIconImage() {
        String logNodeFileImageName = "icons/file_obj.gif";
        this.fileObjImage = null;
        Display display = this.parentComposite.getDisplay();
        URL url = null;
        url = this.bundle.getEntry(logNodeFileImageName);
        if (url == null) {
            logger.severe("Not found icon file : " + logNodeFileImageName);
        } else {
            try {
                this.fileObjImage = new Image((Device)display, url.openStream());
            }
            catch (IOException e) {
                logger.warning("Abort create image " + e.getMessage() + " for " + logNodeFileImageName);
                e.printStackTrace();
            }
        }
    }

    protected abstract class AbstractNodeAction
    extends Action {
        protected AbstractNodeAction() {
        }

        public final void run() {
            ProvisionLogNodeTreeGroup baseNodeGroup = null;
            IProvisionLogTreeNode node = ActionBuilderNodeTree.this.getNodeBase();
            baseNodeGroup = ActionBuilderNodeTree.this.setNodeGroupBase(node);
            this.doTask(baseNodeGroup, node);
        }

        protected abstract void doTask(ProvisionLogNodeTreeGroup var1, IProvisionLogTreeNode var2);

        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL((URL)ActionBuilderNodeTree.this.bundle.getEntry("icons/reload.gif"));
        }

        public String getText() {
            return "Provision Log Tree reload";
        }

        public String getToolTipText() {
            return "Provision Log Tree reload";
        }
    }

    public final class ActionReloadNodeTree
    extends AbstractNodeAction {
        protected void doTask(ProvisionLogNodeTreeGroup group, IProvisionLogTreeNode node) {
            ActionBuilderNodeTree.this.nodeTreeGroupRoot.removeChildAll();
            ActionBuilderNodeTree.this.groupMap.clear();
            this.setNodeTree();
        }

        public void setNodeTree() {
            ActionBuilderNodeTree.this.createNodeTree(true);
        }
    }

    protected abstract class AbstractNodeSortAction
    extends AbstractNodeAction {
        protected AbstractNodeSortAction() {
        }

        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL((URL)ActionBuilderNodeTree.this.bundle.getEntry("icons/sort_obj.gif"));
        }

        public String getText() {
            return "Provision Log Tree sort";
        }

        public String getToolTipText() {
            return "Provision Log Tree sort";
        }
    }

    protected final class ActionSortNodeTreeDatabase
    extends AbstractNodeSortAction {
        private boolean isSortToggle = true;

        protected ActionSortNodeTreeDatabase() {
        }

        protected void doTask(ProvisionLogNodeTreeGroup group, IProvisionLogTreeNode node) {
            this.isSortToggle = !this.isSortToggle;
            Iterator it = null;
            for (String groupName : ActionBuilderNodeTree.this.groupMap.keySet()) {
                ProvisionLogNodeTreeGroup nodeTreeGroup = (ProvisionLogNodeTreeGroup)ActionBuilderNodeTree.this.groupMap.get(groupName);
                if (nodeTreeGroup == null) continue;
                ProvisionLogNodeTreeGroup parentNodeTreeGroup = nodeTreeGroup.getParent();
                if (node instanceof ProvisionLogNodeTreeGroup) {
                    parentNodeTreeGroup = (ProvisionLogNodeTreeGroup)node;
                }
                parentNodeTreeGroup.removeChildAll();
            }
            ActionBuilderNodeTree.this.nodeTreeGroupRoot.removeChildAll();
            ActionBuilderNodeTree.this.groupMap.clear();
            this.setNodeTree();
        }

        protected void setNodeTree() {
            ActionBuilderNodeTree.this.createNodeTree(this.isSortToggle);
        }
    }

    public final class ActionRemoveProvisionLogFile
    extends AbstractNodeAction {
        private IProvisionLogTreeNode provisionLogNodeTree;

        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL((URL)ActionBuilderNodeTree.this.bundle.getEntry("icons/remove_exc.gif"));
        }

        public String getText() {
            return "Remove Provision Log File";
        }

        public String getToolTipText() {
            return "Remove Provision Log File";
        }

        protected void doTask(ProvisionLogNodeTreeGroup group, IProvisionLogTreeNode node) {
            this.openEditor();
        }

        public void openEditor() {
            if (this.provisionLogNodeTree instanceof ProvisionLogNodeTree) {
                File logFile = this.provisionLogNodeTree.getFile();
                logFile.delete();
            } else {
                boolean cfr_ignored_0 = this.provisionLogNodeTree instanceof ProvisionLogNodeTreeGroup;
            }
            ActionBuilderNodeTree.this.nodeTreeGroupRoot.removeChildAll();
            ActionBuilderNodeTree.this.groupMap.clear();
            ActionBuilderNodeTree.this.createNodeTree(true);
        }

        public void setProvisionLogNodeTree(IProvisionLogTreeNode provisionLogNodeTree) {
            this.provisionLogNodeTree = provisionLogNodeTree;
        }
    }
}

