/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.provisionlog.gui.treeview;

import java.io.File;
import java.util.logging.Logger;
import netjfwatcher.provision.gui.editor.EditorInputProvision;
import netjfwatcher.provision.gui.editor.EditorProvisionLogFileView;
import netjfwatcher.provision.info.ProvisionInfo;
import netjfwatcher.provisionlog.gui.treenode.ProvisionLogNodeTree;
import netjfwatcher.provisionlog.gui.treenode.ProvisionLogNodeTreeGroup;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class ProvisionLogNodeTreeListener
implements ISelectionChangedListener {
    private static IWorkbenchPage activePage;
    private IEditorPart editorPart;
    private static Logger logger;

    static {
        logger = null;
    }

    public ProvisionLogNodeTreeListener() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public void selectionChanged(SelectionChangedEvent event) {
        StructuredSelection ss = (StructuredSelection)event.getSelection();
        if (!(ss.getFirstElement() instanceof ProvisionLogNodeTreeGroup) && !(ss.getFirstElement() instanceof ProvisionLogNodeTree)) {
            return;
        }
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (this.editorPart != null) {
            activePage.closeEditor(this.editorPart, false);
            this.editorPart = null;
        }
        try {
            if (ss.getFirstElement() instanceof ProvisionLogNodeTree) {
                ProvisionLogNodeTree entry = (ProvisionLogNodeTree)ss.getFirstElement();
                File logFile = entry.getFile();
                ProvisionInfo provisionInfo = new ProvisionInfo();
                provisionInfo.setLogFile(logFile);
                this.editorPart = activePage.openEditor((IEditorInput)new EditorInputProvision(String.valueOf(entry.getFileName()) + " Provision Log File View", provisionInfo, false), EditorProvisionLogFileView.class.getName());
            }
        }
        catch (PartInitException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
        }
    }
}

