/*
 * Created on 2007/01/10
 *
 *
 * Copyright(c) 2007 Yoshimasa Matsumoto
 */
package netjfwatcher.provision.command.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Logger;

import netjfwatcher.provision.info.ProvisionInfo;

import org.apache.commons.net.ftp.FTP;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;

public class EngineFtp {

	private ProvisionInfo provisionInfo;

	private static Logger logger;

	public EngineFtp(ProvisionInfo provisionInfo) {
		logger = Logger.getLogger(this.getClass().getName());
		this.provisionInfo = provisionInfo;
	}

	public void putFile() throws LoginAuthAbortException, Exception {
		if (provisionInfo.getFtpSourceFile() == null
				|| provisionInfo.getFtpStoreFile() == null) {
			return;
		}
		FileInputStream istream = null;

		// FTPClient̐
		FTPClient ftpclient = new FTPClient();

		try {
			// T[oɐڑ
			ftpclient.connect(provisionInfo.getIpAddress());// server_name
			int reply = ftpclient.getReplyCode();
			if (!FTPReply.isPositiveCompletion(reply)) {
				logger.warning("connect fail");
				LoggingProvision.getInstance().writeLogFile(
						provisionInfo.getProvisionID(), provisionInfo.getIpAddress(), "connect fail");
				throw new LoginAuthAbortException("connect fail");
			}

			// OC
			if (ftpclient.login(provisionInfo.getUserName(), provisionInfo
					.getPassword()) == false) {// [UApX[h
				logger.warning("login fail");
				LoggingProvision.getInstance().writeLogFile(
						provisionInfo.getProvisionID(), provisionInfo.getIpAddress(), "login fail");
				throw new LoginAuthAbortException("login fail");
			}

			ftpclient.setFileType(FTP.BINARY_FILE_TYPE);
			istream = new FileInputStream(provisionInfo.getFtpSourceFile());
			ftpclient.storeFile(provisionInfo.getFtpStoreFile(), istream);
			logger.info("FTP source=" + provisionInfo.getFtpSourceFile()
					+ " store=" + provisionInfo.getFtpStoreFile());
			LoggingProvision.getInstance().writeLogFile(
					provisionInfo.getProvisionID(), provisionInfo.getIpAddress(),
					"FTP source=" + provisionInfo.getFtpSourceFile()
							+ " store=" + provisionInfo.getFtpStoreFile());
		} catch (Exception e) {

			logger.warning("Exception " + e.getMessage());
			LoggingProvision.getInstance()
					.writeLogFile(provisionInfo.getProvisionID(), provisionInfo.getIpAddress(),
							"Exception " + e.getMessage());
			throw e;
		} finally {

			if (istream != null) {
				try {
					istream.close();
				} catch (Exception e) {
					e.printStackTrace();
					logger.warning("Exception " + e.getMessage());
				}
			}

			if (ftpclient.isConnected()) {
				try {
					ftpclient.logout();
					ftpclient.disconnect();
				} catch (Exception e) {
					e.printStackTrace();
					logger.warning("Exception " + e.getMessage());
				}
			}

		}
	}

	public void getDataFiles(String server, String username, String password,
			String folder, String destinationFolder, Calendar start,
			Calendar end) {
		try {
			// Connect and logon to FTP Server
			FTPClient ftp = new FTPClient();
			ftp.connect(server);
			ftp.login(username, password);

			System.out.println("Connected to " + server + ".");
			System.out.print(ftp.getReplyString());

			// List the files in the directory
			ftp.changeWorkingDirectory(folder);
			FTPFile[] files = ftp.listFiles();
			System.out.println("Number of files in dir: " + files.length);

			DateFormat df = DateFormat.getDateInstance(DateFormat.SHORT);
			for (int i = 0; i < files.length; i++) {
				Date fileDate = files[i].getTimestamp().getTime();
				if (fileDate.compareTo(start.getTime()) >= 0
						&& fileDate.compareTo(end.getTime()) <= 0) {
					// Download a file from the FTP Server
					System.out.print(df.format(files[i].getTimestamp()
							.getTime()));
					System.out.println("\t" + files[i].getName());

					File file = new File(destinationFolder + File.separator
							+ files[i].getName());
					FileOutputStream fos = new FileOutputStream(file);
					ftp.retrieveFile(files[i].getName(), fos);
					fos.close();
					file.setLastModified(fileDate.getTime());
				}
			}

			// Logout from the FTP Server and disconnect
			ftp.logout();
			ftp.disconnect();

		} catch (Exception e) {
			e.printStackTrace();
			logger.warning("Exception " + e.getMessage());
		}
	}

}
