/*
 * Created on 2007/01/10
 *
 *
 * Copyright(c) 2007 Yoshimasa Matsumoto
 */
package netjfwatcher.provision.command.core;

import java.io.InputStream;
import java.io.PrintStream;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.logging.Logger;

import netjfwatcher.provision.info.ProvisionInfo;
import netjfwatcher.provision.preference.ProvisionPreference;

import org.apache.commons.net.telnet.TelnetClient;

public class EngineTelnet {

	private TelnetClient telnet = new TelnetClient();

	private ProvisionInfo provisionInfo;

	private ParserCommandFile commandFile = new ParserCommandFile();

	private InputStream inStream;

	private PrintStream outStream;

	private static final String SEND = "[send]";

	private static final String RECEIVE = "[receive]";

	private char prompt = '$';

	private static Logger logger;

	/* Thread sleep */
	private static final int WAIT_SLEEP_TIME = 5000;

	public EngineTelnet(ProvisionInfo provisionInfo) {
		logger = Logger.getLogger(this.getClass().getName());
		this.provisionInfo = provisionInfo;
	}

	public void start(boolean isTest, ArrayList testCommandList)
			throws LoginAuthAbortException, SocketTimeoutException, Exception {

		String server;
		String user;
		String password;

		if (provisionInfo == null) {
			return;
		}
		server = provisionInfo.getIpAddress();
		user = provisionInfo.getUserName();
		password = provisionInfo.getPassword();

		ArrayList commandList = null;
		try {
			if (isTest) {
				commandList = testCommandList;
			} else {
				commandList = commandFile.parse(provisionInfo.getCommandFile());
			}
			if (commandList == null) {
				return;
			}

			// Connect to the specified server
			telnet.connect(server, ProvisionPreference.TELNET_PORT);
			telnet.setSoTimeout(ProvisionPreference.TELNET_SOTIMEOUT);

			// Get input and output stream references
			inStream = telnet.getInputStream();
			outStream = new PrintStream(telnet.getOutputStream());

			// Log the user on
			logger.info("user " + user);
			logger.info("password " + password);
			logger.info("response " + readUntil("login: ", null, null));
			write(user);
			logger.info("response "
					+ readUntil("Password: ", "login: ", "incorrect"));
			write(password);

			// Advance to a prompt
			String response = readUntil(prompt + " ", "incorrect", null);
			logger.info("response " + response);
			if (response.equals("incorrect")) {
				logger.warning("NG Response " + response);

				LoggingProvision.getInstance()
						.writeLogFile(provisionInfo.getProvisionID(),
								provisionInfo.getIpAddress(),
								"Abort login " + response);
				throw new LoginAuthAbortException("login fail");

			}
			String rootPassword = provisionInfo.getSuPpassword();
			if (rootPassword != null && !rootPassword.equals("")) {
				if(!loginSu(rootPassword)) {
					throw new LoginAuthAbortException("su logins fail");
				}
			}
			for (int i = 0; i < commandList.size(); i++) {
				String command = (String) commandList.get(i);
				this.sendCommand(command);
			}

		} catch (SocketTimeoutException e) {
			logger.warning(" SocketTimeoutException " + e.getMessage());

			LoggingProvision.getInstance().writeLogFile(
					provisionInfo.getProvisionID(),
					provisionInfo.getIpAddress(),
					"SocketTimeoutException " + e.getMessage());

			throw e;
		} catch (Exception e) {
			logger.warning(" Exception " + e.getMessage());

			LoggingProvision.getInstance()
					.writeLogFile(provisionInfo.getProvisionID(),
							provisionInfo.getIpAddress(),
							"Exception " + e.getMessage());

			throw e;
		} finally {

			if (inStream != null) {
				inStream.close();
				inStream = null;
			}
			if (outStream != null) {
				outStream.close();
				outStream = null;
			}
			this.disconnect();
		}
	}

	public boolean loginSu(String rootPassword) throws Exception {
		boolean isRoot = true;
		write("su");
		String response = readUntil("Password: ", "login: ", "incorrect");
		write(rootPassword);
		prompt = '#';
		response = readUntil(prompt + " ", "incorrect", null);
		if (response.indexOf(prompt) < 0) {
			isRoot = false;
			logger.warning("su login NG response " + response);

			LoggingProvision.getInstance().writeLogFile(
					provisionInfo.getProvisionID(),
					provisionInfo.getIpAddress(), "Abort su login " + response);

		}
		return isRoot;
	}

	private String readUntil(String expectPattern, String ngPattern1,
			String ngPattern2) throws SocketTimeoutException, Exception {

		char expectLastChar = expectPattern.charAt(expectPattern.length() - 1);
		char ng1LastChar = ' ';
		char ng2LastChar = ' ';
		if (ngPattern1 != null && ngPattern1.length() >= 1) {
			ng1LastChar = ngPattern1.charAt(ngPattern1.length() - 1);
		}
		if (ngPattern2 != null && ngPattern2.length() > 2) {
			ng2LastChar = ngPattern2.charAt(ngPattern2.length() - 1);
		}
		StringBuffer sb = new StringBuffer();
		boolean found = false;

		char ch = (char) 0x00;
		if (inStream.available() != 0) {
			ch = (char) inStream.read();
		}
		try {
			while (true) {
				if (ch != (char) 0x00) {
					// System.out.print(ch);

					sb.append(ch);
					if (ch == expectLastChar || ch == ng1LastChar
							|| ch == ng2LastChar) {
						// v
						if (sb.toString().endsWith(expectPattern)) {
							return expectPattern;
						}
						if (ngPattern1 != null) {
							if (sb.toString().endsWith(ngPattern1)) {
								return ngPattern1;
							}
						}
						if (ngPattern2 != null) {
							if (sb.toString().endsWith(ngPattern2)) {
								return ngPattern2;
							}
						}
					}
				}
				if (inStream.available() == 0) {
					try {
						Thread.sleep(WAIT_SLEEP_TIME);
						ch = (char) 0x00;
					} catch (InterruptedException e) {
						logger.warning(e.getMessage());
						e.printStackTrace();
					}
					if (inStream.available() == 0) {
						throw new SocketTimeoutException(
								"Available data length=0");
					}
				} else {
					ch = (char) inStream.read();
				}

			}
		} finally {

			LoggingProvision.getInstance().writeLogFile(
					provisionInfo.getProvisionID(),
					provisionInfo.getIpAddress(), RECEIVE + sb.toString());

		}

	}

	private void write(String value) throws Exception {

		outStream.println(value);
		outStream.flush();
		logger.info(value);

		LoggingProvision.getInstance().writeLogFile(
				provisionInfo.getProvisionID(), provisionInfo.getIpAddress(),
				SEND + value);

	}

	private String sendCommand(String command) throws Exception {

		write(command);
		return readUntil(prompt + " ", "login: ", "incorrect");

	}

	private void disconnect() {
		try {
			if (telnet.isConnected()) {
				telnet.disconnect();
			}
		} catch (Exception e) {
			logger.warning("Exception " + e.getMessage());

			LoggingProvision.getInstance().writeLogFile(
					provisionInfo.getProvisionID(),
					provisionInfo.getIpAddress(), "Exception" + e.getMessage());

			e.printStackTrace();
		}
	}

}
