/*
 * Created on 2007/01/10
 *
 *
 * Copyright(c) 2007 Yoshimasa Matsumoto
 */
package netjfwatcher.provision.command.core;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Logger;

import netjfwatcher.provision.preference.ProvisionPreference;

public class LoggingProvision {

	private static FileWriter fileWriter;

	private static BufferedWriter bufferedWriter;

	private static DateFormat logMsgDateformat;

	private static DateFormat logFileDateformat;

	private static Logger logger;

	private LoggingProvision() {
		logger = Logger.getLogger(this.getClass().getName());
		logMsgDateformat = new SimpleDateFormat("yyyy-MM-dd (EEE) HH:mm:ss");
		logFileDateformat = new SimpleDateFormat("yyyy-MMdd_HHmm");
	}

	public synchronized void startLog() {
		
		File provisionLogDir = new File(
				ProvisionPreference.PROVISION_LOG_DIR + "/");
		if (!provisionLogDir.exists()) {

			if (!provisionLogDir.mkdirs()) {
				logger.warning("Abrot mkdir. " + provisionLogDir);
			}
		}
		boolean isAppend = true;
		Date logDate = Calendar.getInstance().getTime();
		String logFilename = ProvisionPreference.PROVISION_LOG_DIR
				+ logFileDateformat.format(logDate) + ".log";

		File provisionLogFile = new File(logFilename);
		if (provisionLogFile.exists()) {
			isAppend = true;
		} else {
			isAppend = false;
		}

		stopLog(); // Check Log File Resource
		// logger.info("Start provision log");

		try {

			if (provisionLogFile == null) {
				return;
			}

			fileWriter = new FileWriter(provisionLogFile, isAppend);
			bufferedWriter = new BufferedWriter(fileWriter);

		} catch (Exception e) {
			logger.warning("Exception " + e.getMessage());
		}
	}

	public synchronized void stopLog() {
		try {
			if (bufferedWriter != null || fileWriter != null) {
				logger.info("Provision log close");
			}
		} finally {

			if (bufferedWriter != null) {
				try {
					bufferedWriter.close();
					bufferedWriter = null;
				} catch (Exception e1) {
					logger.warning("Exception " + e1.getMessage());
				}
			}
			if (fileWriter != null) {
				try {
					fileWriter.close();
					fileWriter = null;
				} catch (Exception e2) {
					logger.warning("Exception " + e2.getMessage());
				}
			}
		}
	}

	public synchronized void writeLogFile(String id, String ipAddress,
			String message) {
		Date logDate = Calendar.getInstance().getTime();
		try {
			if (id == null || ipAddress == null) {
				bufferedWriter.write(logMsgDateformat.format(logDate));
			} else {
				bufferedWriter.write(logMsgDateformat.format(logDate) + " ID="
						+ id + " " + ipAddress);
			}
			bufferedWriter.write(System.getProperty("line.separator"));
			bufferedWriter.write(message);
			bufferedWriter.write(System.getProperty("line.separator"));
			bufferedWriter.flush();
		} catch (Exception e) {
			logger.warning("Exception " + e.getMessage());
		}
	}

	protected void finalize() throws Throwable {

		super.finalize();
		stopLog();
	}

	/**
	 * ̃NX̃CX^XԂ܂B<BR>
	 * iNXێĂVOgEIuWFNg Ԃ܂j<BR>
	 * 
	 * @return VOgEIuWFNgƂĂ̂̃NX CX^X
	 */
	public static LoggingProvision getInstance() {
		return SingletonResource.INSTANCE;
	}

	/**
	 * VOgEIuWFNgێNXłB<BR>
	 * 
	 */
	private static class SingletonResource {
		static final LoggingProvision INSTANCE = new LoggingProvision();
	}
}
