/*
 * Created on 2007/01/10
 *
 *
 * Copyright(c) 2007 Yoshimasa Matsumoto
 */
package netjfwatcher.provision.command.core;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class ParserCommandFile {

	private static Logger logger;
	
	public ParserCommandFile() {
		logger = Logger.getLogger(this.getClass().getName());
	}
	
	
	public ArrayList parse(String file) throws IOException {

		if(file == null || file.equals("")) {
			return null;
		}
		ArrayList commandList = new ArrayList();
		BufferedReader buffReader = null;
		FileReader fi = null;
		try {
			fi = new FileReader(file);
			buffReader = new BufferedReader(fi);
		} catch (FileNotFoundException e1) {
			logger.warning("FileNotFoundException " + e1.getMessage());
			throw e1;
		}

		try {

			String message;
			while ((message = buffReader.readLine()) != null) {
				Pattern pattern = null;
				pattern = Pattern.compile(System.getProperty("line.separator"));
				String[] commandStrArray = pattern.split(message);
				
				
				if (commandStrArray != null) {
					for (int i = 0; i < commandStrArray.length; i++) {
						commandList.add(commandStrArray[i]);
					}
				}
				
			}

		} catch (FileNotFoundException e1) {
			logger.warning("FileNotFoundException " + e1.getMessage());
			throw e1;
		} catch (IOException e) {
			logger.warning("IOException " + e.getMessage());
			throw e;
		} finally {
			if (buffReader != null) {
				try {
					buffReader.close();
				} catch (IOException e2) {
					logger.warning(e2.getMessage());
					e2.printStackTrace();
				}
			}

			if (fi != null) {
				try {
					fi.close();
				} catch (IOException e2) {
					logger.warning(e2.getMessage());
					e2.printStackTrace();
				}
			}
		}
		
		return commandList;

	}
}
