/*
 * Created on 2007/01/10
 *
 *
 * Copyright(c) 2007 Yoshimasa Matsumoto
 */
package netjfwatcher.provision.command.schedule;

import java.net.SocketTimeoutException;
import java.util.logging.Logger;

import netjfwatcher.provision.command.core.EngineFtp;
import netjfwatcher.provision.command.core.EngineTelnet;
import netjfwatcher.provision.command.core.LoginAuthAbortException;
import netjfwatcher.provision.info.ProvisionInfo;
import netjfwatcher.provision.info.ProvisionInfoControl;
import netjfwatcher.provision.nodemaneger.list.ProvisionMessageQueue;

public class ProvisionCommandTask {

	/* MO */
	private static Logger logger;

	private ProvisionInfo provisionInfo;

	public ProvisionCommandTask(ProvisionInfo provisionInfo) {
		logger = Logger.getLogger(this.getClass().getName());
		this.provisionInfo = provisionInfo;
	}

	public void executeCommand() {

		if (!provisionInfo.getFtpSourceFile().equals("")
				&& !provisionInfo.getFtpStoreFile().equals("")) {

			try {
				EngineFtp testFtp = new EngineFtp(provisionInfo);
				testFtp.putFile();

			} catch (LoginAuthAbortException e) {

				provisionInfo
						.setCommandResult(ProvisionCommandTaskPreference.STATUS_LOGIN_FAIL);
			} catch (Exception e) {
				provisionInfo
						.setCommandResult(ProvisionCommandTaskPreference.STATUS_ABORT
								+ " (" + e.getMessage() + ")");
			}
		}

		if (!provisionInfo.getCommandFile().equals("")) {
			EngineTelnet telnet = new EngineTelnet(provisionInfo);

			try {

				telnet.start(false, null);
			} catch (LoginAuthAbortException e) {

				provisionInfo
						.setCommandResult(ProvisionCommandTaskPreference.STATUS_LOGIN_FAIL);
			} catch (SocketTimeoutException e) {
				provisionInfo
						.setCommandResult(ProvisionCommandTaskPreference.STATUS_ABORT
								+ " (" + e.getMessage() + ")");

			} catch (Exception e) {
				provisionInfo
						.setCommandResult(ProvisionCommandTaskPreference.STATUS_ABORT
								+ " (" + e.getMessage() + ")");
			}
		}

		if (provisionInfo.getCommandResult().equals(
				ProvisionCommandTaskPreference.STATUS_WAIT)) {
			provisionInfo
					.setCommandResult(ProvisionCommandTaskPreference.STATUS_COMPLETE);
		}

		ProvisionInfoControl.getInstance().setProvisionInfo(
				provisionInfo.getProvisionID(), provisionInfo);
		ProvisionMessageQueue.getInstance().pushProvisionMessage(
				provisionInfo.getIpAddress());
	}

}
