/*
 * Created on 2007/01/10
 *
 *
 * Copyright(c) 2007 Yoshimasa Matsumoto
 */
package netjfwatcher.provision.command.schedule;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;

import netjfwatcher.provision.info.ProvisionInfo;
import netjfwatcher.provision.info.ProvisionInfoControl;
import netjfwatcher.provision.nodemaneger.list.ProvisionMessageQueue;

public final class ProvisionCommandTaskScheduleControl {
	// MO
	private static Logger logger = null;

	/* ^XNXPW[ێ郊Xg */
	private Map taskScheduleMap = Collections.synchronizedMap(new HashMap());

	// RXgN^privateɂĕspӂɒڃRXgN^Ăяoh~
	private ProvisionCommandTaskScheduleControl() {
		logger = Logger.getLogger(this.getClass().getName());
	}

	public synchronized void setTaskSchedule(ProvisionInfo provisionInfo,
			Date startDate) {

		Timer taskTimer = new Timer();

		/* wɎsiJnj^XNZbg */
		TimerTask threadStartTask = new ProvisionCommandTimerTask(provisionInfo);
		taskTimer.schedule(threadStartTask, startDate);

		/* ^XNXPW[𐶐āAXgɕێ */
		ProvisionCommandTaskScheduleInfo taskScheduleInfo = new ProvisionCommandTaskScheduleInfo();
		taskScheduleInfo.setTaskStartDate(startDate);
		taskScheduleInfo.setTaskTimer(taskTimer);

		taskScheduleInfo.setProvisionInfo(provisionInfo);
		taskScheduleMap.put(provisionInfo.getProvisionID(), taskScheduleInfo);

	}

	/**
	 * ^XNXPW[LZ܂B
	 * 
	 * @param taskScheduleInfo
	 *            ^XNXPW[
	 */
	public synchronized void cancelTaskSchedule(
			ProvisionCommandTaskScheduleInfo taskScheduleInfo) {
		ProvisionInfo provisionInfo = taskScheduleInfo.getProvisionInfo();
		logger.info("Cancel Provision ID=" + provisionInfo.getProvisionID());
		if (taskScheduleInfo.getTaskTimer() != null) {
			taskScheduleInfo.getTaskTimer().cancel();

			if (provisionInfo.getCommandResult().equals(
					ProvisionCommandTaskPreference.STATUS_WAIT)) {
				provisionInfo
						.setCommandResult(ProvisionCommandTaskPreference.STATUS_CAMCEL);
				ProvisionInfoControl.getInstance().setProvisionInfo(
						provisionInfo.getProvisionID(), provisionInfo);
				ProvisionMessageQueue.getInstance().pushProvisionMessage(provisionInfo.getIpAddress());
			}
		}
		taskScheduleMap.remove(provisionInfo.getProvisionID());

	}

	/**
	 * ^XNXPW[񃊃XgԂ܂B
	 * 
	 * 
	 * @return taskScheduleMap ^XNXPW[Map
	 */
	public synchronized Map getTaskScheduleMap() {
		return taskScheduleMap;
	}

	/**
	 * ̃NX̃CX^XԂ܂B<BR>
	 * iNXێĂVOgEIuWFNg Ԃ܂j<BR>
	 * 
	 * @return VOgEIuWFNgƂĂ̂̃NX CX^X
	 */
	public static ProvisionCommandTaskScheduleControl getInstance() {
		return SingletonResource.INSTANCE;
	}

	/**
	 * VOgEIuWFNgێNXłB<BR>
	 * 
	 */
	private static class SingletonResource {
		static final ProvisionCommandTaskScheduleControl INSTANCE = new ProvisionCommandTaskScheduleControl();
	}
}
