/*
 * Created on 2007/01/10
 *
 *
 * Copyright(c) 2007 Yoshimasa Matsumoto
 */
package netjfwatcher.provision.gui.editor;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.net.SocketTimeoutException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Pattern;

import netjfwatcher.common.view.CalendarComposite;
import netjfwatcher.engine.model.action.MediaResource;
import netjfwatcher.provision.command.core.EngineFtp;
import netjfwatcher.provision.command.core.EngineTelnet;
import netjfwatcher.provision.command.core.LoginAuthAbortException;
import netjfwatcher.provision.command.core.ParserCommandFile;
import netjfwatcher.provision.command.schedule.ProvisionCommandTaskScheduleControl;
import netjfwatcher.provision.command.schedule.ProvisionCommandTaskScheduleInfo;
import netjfwatcher.provision.info.ProvisionInfo;
import netjfwatcher.provision.info.ProvisionInfoControl;
import netjfwatcher.provision.preference.ProvisionPreference;

import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;

public class EditorProvisionScheduleView extends AbstractEditorProvision {
	/** View^CgSuffix */
	public static final String TITLE_SUFFIX = " Provision Schedule View";

	/* Scroll CompositeTCY */
	private static final int[] SCROLL_COMPOSITE_SIZE = { 800, 800 };

	private static final int TEXT_WIDTH = 100;

	private static final int SCHEDULE_LIST_ITEM_HEIGHT = 3;

	private static final int FILE_PATH_TEXT_WIDTH_HINT = 500;

	private static final int COMMAND_TEXT_WIDTH_HINT = 500;

	private static final int COMMAND_TEXT_HEIGHT_HINT = 120;

	/* {^ */
	private static final int BUTTON_WIDTH = 150;

	/* {^ */
	private static final int BUTTON_HEIGHT = 20;

	/* List */
	private static final int LIST_WIDTHHINT = 300;

	private static final int HORIZONTAL_SPAN2 = 2;

	private static final int HORIZONTAL_SPAN3 = 3;

	private static final int HORIZONTAL_SPAN4 = 4;

	private static final int HORIZONTAL_SPAN8 = 8;

	/* MO */
	private static Logger logger;

	/* Xe[^XC}l[W */
	private SubStatusLineManager statusLineManager;

	private Text idText;

	private Text nodeNameText;

	private Text ipAddressText;

	private Text groupText;

	private Text userName;

	private Text passwordText;

	private Text suPasswordText;

	/* m[hʕ\eLXg */
	private Combo nodeKindCombo;

	/* XV{^ */
	private Button refreshButton;

	private Button addButton;

	private Button editButton;

	private Button deleteButton;

	private Button cancelButton;

	private Button setButton;

	private Button ftpSourceFileSelectButton;

	private Button commandFileSelectButton;

	private List scheduleList;

	private Text commandFilePathText;

	private Text ftpSourceFilePathText;

	private Text ftpStoreFilePathText;

	/* ^XNXPW[ JnN */
	private Text assignmentYearText;

	/* ^XNXPW[ Jn */
	private Text assignmentMonthText;

	/* ^XNXPW[ Jn */
	private Text assignmentDateText;

	private Combo assignmentDateHourCombo;

	private Combo assignmentDateMinuteCombo;

	private Text commandText;

	private Button testButton;

	private Button saveButton;

	/* JneLXg琶Date */
	private Date startDate;

	/* XPW[\tH[}bg */
	private DateFormat dateformat;

	/* ^XNXPW[Xg */
	private boolean isSortDirection = true;

	/** f[^\eLXg */
	public static final int DATE_TEXT_WIDTH = 250;

	/** eLXg\ */
	public static final int TEXT_WIDTH1 = 120;

	private ParserCommandFile commandFileParse = new ParserCommandFile();

	private String selectFileName;

	private ProvisionInfo provisionIDInfo;

	/**
	 * EditorEBhEɃuEU\邽߂̃CX^X 𐶐܂B
	 * 
	 */
	public EditorProvisionScheduleView() {
		logger = Logger.getLogger(this.getClass().getName());

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.ISaveablePart#isSaveAsAllowed()
	 */
	public boolean isSaveAsAllowed() {
		return false;
	}

	/**
	 * EditorEBhE𐶐܂B
	 * 
	 * @param parent
	 *            Composite
	 */
	public void createPartControl(Composite parent) {

		/* ͐ݒlm[hĎ擾 */
		EditorInputProvision nodeViewEditorInput = (EditorInputProvision) getEditorInput();
		provisionIDInfo = nodeViewEditorInput.getProvisionInfo();
		dateformat = new SimpleDateFormat("yyyy-MM-dd (EEE) HH:mm:ss");

		ScrolledComposite scrollComposite = new ScrolledComposite(parent,
				SWT.H_SCROLL | SWT.V_SCROLL);

		GridLayout layout = new GridLayout(1, false);
		scrollComposite.setLayout(layout);

		GridData gridData = null;

		GridLayout gridLayout0 = new GridLayout(1, true);
		Composite baseComposite0 = new Composite(scrollComposite, SWT.NONE);
		baseComposite0.setLayout(gridLayout0);
		baseComposite0.setLayoutData(new GridData());

		GridLayout gridLayout1 = new GridLayout(1, true);
		Composite baseComposite1 = new Composite(baseComposite0, SWT.NONE);
		baseComposite1.setLayout(gridLayout1);
		baseComposite1.setLayoutData(new GridData());

		GridLayout gridLayout2 = new GridLayout(2, true);
		Composite baseComposite2 = new Composite(baseComposite0, SWT.NONE);
		baseComposite2.setLayout(gridLayout2);
		baseComposite2.setLayoutData(new GridData());

		GridLayout gridLayoutPropComp = new GridLayout(6, false);
		Composite compositeProp = new Composite(baseComposite1, SWT.NULL);
		compositeProp.setLayout(gridLayoutPropComp);
		compositeProp.setLayoutData(new GridData(
				GridData.HORIZONTAL_ALIGN_BEGINNING
						| GridData.VERTICAL_ALIGN_BEGINNING));

		GridLayout gridLayoutListComp2 = new GridLayout(1, false);
		Composite compositeList2 = new Composite(baseComposite2, SWT.NULL);
		compositeList2.setLayout(gridLayoutListComp2);
		compositeList2.setLayoutData(new GridData(
				GridData.HORIZONTAL_ALIGN_BEGINNING
						| GridData.VERTICAL_ALIGN_BEGINNING));

		GridLayout gridLayoutOperation2 = new GridLayout(1, false);
		Composite compositeOperation2 = new Composite(baseComposite2, SWT.NULL);
		compositeOperation2.setLayout(gridLayoutOperation2);
		compositeOperation2.setLayoutData(new GridData(
				GridData.HORIZONTAL_ALIGN_BEGINNING
						| GridData.VERTICAL_ALIGN_BEGINNING));

		GridLayout gridLayoutButtonComp2 = new GridLayout(1, false);
		Composite compositeButton2 = new Composite(compositeOperation2,
				SWT.NULL);
		compositeButton2.setLayout(gridLayoutButtonComp2);
		compositeButton2.setLayoutData(new GridData());

		GridLayout gridLayoutListComp = new GridLayout(1, false);
		Composite compositeList = new Composite(baseComposite2, SWT.NULL);
		compositeList.setLayout(gridLayoutListComp);
		compositeList.setLayoutData(new GridData(
				GridData.HORIZONTAL_ALIGN_BEGINNING
						| GridData.VERTICAL_ALIGN_BEGINNING));

		GridLayout gridLayoutOperation = new GridLayout(1, false);
		Composite compositeOperation = new Composite(baseComposite2, SWT.NULL);
		compositeOperation.setLayout(gridLayoutOperation);
		compositeOperation.setLayoutData(new GridData(
				GridData.HORIZONTAL_ALIGN_BEGINNING
						| GridData.VERTICAL_ALIGN_BEGINNING));

		GridLayout gridLayoutButtonComp = new GridLayout(1, false);
		Composite compositeButton = new Composite(compositeOperation, SWT.NULL);
		compositeButton.setLayout(gridLayoutButtonComp);
		compositeButton.setLayoutData(new GridData());

		GridLayout gridLayoutDateTextComp = new GridLayout(HORIZONTAL_SPAN8,
				false);
		Composite compositeDateText = new Composite(compositeOperation,
				SWT.NULL);
		compositeDateText.setLayout(gridLayoutDateTextComp);
		compositeDateText.setLayoutData(new GridData());

		GridLayout gridLayoutCalendar = new GridLayout(1, false);
		Composite compositeCalendar = new Composite(compositeOperation,
				SWT.NONE);
		compositeCalendar.setLayoutData(new GridData(
				GridData.HORIZONTAL_ALIGN_FILL));
		compositeCalendar.setLayout(gridLayoutCalendar);

		GridLayout gridLayoutFile = new GridLayout(HORIZONTAL_SPAN4, false);
		Composite compositeFile = new Composite(baseComposite2, SWT.NULL);
		compositeFile.setLayout(gridLayoutFile);
		GridData fileGridData = new GridData();
		fileGridData.horizontalSpan = HORIZONTAL_SPAN2;
		fileGridData.verticalSpan = 1;
		compositeFile.setLayoutData(fileGridData);

		GridLayout gridLayoutMonitor = new GridLayout(2, false);
		Composite compositeMonitor = new Composite(baseComposite2, SWT.NULL);
		compositeMonitor.setLayout(gridLayoutMonitor);
		GridData monitorGridData = new GridData();
		monitorGridData.horizontalSpan = HORIZONTAL_SPAN2;
		monitorGridData.verticalSpan = 1;
		compositeMonitor.setLayoutData(monitorGridData);

		Label label = new Label(compositeProp, SWT.NONE);
		label.setText("ID");
		GridData listGridData = new GridData();
		listGridData.horizontalSpan = 1;
		listGridData.verticalSpan = 1;
		label.setLayoutData(listGridData);

		idText = new Text(compositeProp, SWT.BORDER);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH;
		idText.setLayoutData(gridData);

		refreshButton = new Button(compositeProp, SWT.NONE);
		refreshButton.setText(" Refresh");
		refreshButton.setSize(BUTTON_WIDTH, BUTTON_HEIGHT);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		refreshButton.setLayoutData(gridData);

		addButton = new Button(compositeProp, SWT.NONE);
		addButton.setText(" Add  ");
		addButton.setSize(BUTTON_WIDTH, BUTTON_HEIGHT);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		addButton.setLayoutData(gridData);

		editButton = new Button(compositeProp, SWT.NONE);
		editButton.setText(" Edit  ");
		editButton.setSize(BUTTON_WIDTH, BUTTON_HEIGHT);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		editButton.setLayoutData(gridData);

		deleteButton = new Button(compositeProp, SWT.NONE);
		deleteButton.setText(" Delete");
		deleteButton.setSize(BUTTON_WIDTH, BUTTON_HEIGHT);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		deleteButton.setLayoutData(gridData);

		label = new Label(compositeProp, SWT.NONE);
		label.setText("Node Name");
		listGridData = new GridData();
		listGridData.horizontalSpan = 1;
		listGridData.verticalSpan = 1;
		label.setLayoutData(listGridData);

		nodeNameText = new Text(compositeProp, SWT.BORDER);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH;
		nodeNameText.setLayoutData(gridData);

		/* Dummy column */
		label = new Label(compositeProp, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = HORIZONTAL_SPAN4;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		label = new Label(compositeProp, SWT.NONE);
		label.setText("IP Address");
		listGridData = new GridData();
		listGridData.horizontalSpan = 1;
		listGridData.verticalSpan = 1;
		label.setLayoutData(listGridData);

		ipAddressText = new Text(compositeProp, SWT.BORDER);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH;
		ipAddressText.setLayoutData(gridData);

		/* Dummy column */
		label = new Label(compositeProp, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = HORIZONTAL_SPAN4;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		label = new Label(compositeProp, SWT.NONE);
		label.setText("Group");
		listGridData = new GridData();
		listGridData.horizontalSpan = 1;
		listGridData.verticalSpan = 1;
		label.setLayoutData(listGridData);

		groupText = new Text(compositeProp, SWT.BORDER);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH;
		groupText.setLayoutData(gridData);

		/* Dummy column */
		label = new Label(compositeProp, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = HORIZONTAL_SPAN4;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		/* m[hComboBoxZbg */
		setNodeKind(compositeProp);

		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH1;
		nodeKindCombo.setLayoutData(gridData);
		nodeKindCombo.setVisibleItemCount(15);

		/* Dummy column */
		label = new Label(compositeProp, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = HORIZONTAL_SPAN4;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		label = new Label(compositeProp, SWT.NONE);
		label.setText("User Name");
		listGridData = new GridData();
		listGridData.horizontalSpan = 1;
		listGridData.verticalSpan = 1;
		label.setLayoutData(listGridData);

		userName = new Text(compositeProp, SWT.BORDER);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH;
		userName.setLayoutData(gridData);

		/* Dummy column */
		label = new Label(compositeProp, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = HORIZONTAL_SPAN4;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		label = new Label(compositeProp, SWT.NONE);
		label.setText("Password");
		listGridData = new GridData();
		listGridData.horizontalSpan = 1;
		listGridData.verticalSpan = 1;
		label.setLayoutData(listGridData);

		passwordText = new Text(compositeProp, SWT.BORDER | SWT.PASSWORD);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH;
		passwordText.setLayoutData(gridData);

		/* Dummy column */
		label = new Label(compositeProp, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = HORIZONTAL_SPAN4;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		label = new Label(compositeProp, SWT.NONE);
		label.setText("su Password");
		listGridData = new GridData();
		listGridData.horizontalSpan = 1;
		listGridData.verticalSpan = 1;
		label.setLayoutData(listGridData);

		suPasswordText = new Text(compositeProp, SWT.BORDER | SWT.PASSWORD);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH;
		suPasswordText.setLayoutData(gridData);

		/* Dummy column */
		label = new Label(compositeProp, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = HORIZONTAL_SPAN4;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		/*
		 * XPW[\Xg
		 */
		label = new Label(compositeList, SWT.NONE);
		label.setText("Schedule");
		listGridData = new GridData();
		listGridData.horizontalSpan = 1;
		listGridData.verticalSpan = 1;
		label.setLayoutData(listGridData);
		scheduleList = new List(compositeList, SWT.SINGLE | SWT.BORDER
				| SWT.V_SCROLL | SWT.H_SCROLL);
		GridData data = new GridData(GridData.VERTICAL_ALIGN_BEGINNING
				| GridData.HORIZONTAL_ALIGN_BEGINNING);
		data.horizontalSpan = 1; // Xp
		data.verticalSpan = 10; // Xp
		data.widthHint = LIST_WIDTHHINT;
		data.heightHint = scheduleList.getItemHeight()
				* SCHEDULE_LIST_ITEM_HEIGHT;
		scheduleList.setLayoutData(data);

		ftpSourceFileSelectButton = new Button(compositeFile, SWT.NONE);
		ftpSourceFileSelectButton.setSize(BUTTON_WIDTH, BUTTON_HEIGHT);
		ftpSourceFileSelectButton.setText("FTP Source File Browser");
		gridData = new GridData();
		gridData.horizontalSpan = HORIZONTAL_SPAN2;
		gridData.verticalSpan = 1;
		ftpSourceFileSelectButton.setLayoutData(gridData);

		/* Dummy column */
		label = new Label(compositeFile, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = HORIZONTAL_SPAN2;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		label = new Label(compositeFile, SWT.NONE);
		label.setText("FTP Source File");
		listGridData = new GridData();
		listGridData.horizontalSpan = 1;
		listGridData.verticalSpan = 1;
		label.setLayoutData(listGridData);

		ftpSourceFilePathText = new Text(compositeFile, SWT.BORDER);
		gridData = new GridData();
		gridData.horizontalSpan = 3;
		gridData.verticalSpan = 1;
		gridData.widthHint = FILE_PATH_TEXT_WIDTH_HINT;
		ftpSourceFilePathText.setLayoutData(gridData);

		label = new Label(compositeFile, SWT.NONE);
		label.setText("FTP Store Path/File");
		listGridData = new GridData();
		listGridData.horizontalSpan = 1;
		listGridData.verticalSpan = 1;
		label.setLayoutData(listGridData);

		ftpStoreFilePathText = new Text(compositeFile, SWT.BORDER);
		gridData = new GridData();
		gridData.horizontalSpan = HORIZONTAL_SPAN3;
		gridData.verticalSpan = 1;
		gridData.widthHint = FILE_PATH_TEXT_WIDTH_HINT;
		ftpStoreFilePathText.setLayoutData(gridData);

		commandFileSelectButton = new Button(compositeFile, SWT.NONE);
		commandFileSelectButton.setSize(BUTTON_WIDTH, BUTTON_HEIGHT);
		commandFileSelectButton.setText("Telnet Command File Browser");
		gridData = new GridData();
		gridData.horizontalSpan = HORIZONTAL_SPAN2;
		gridData.verticalSpan = 1;
		commandFileSelectButton.setLayoutData(gridData);

		saveButton = new Button(compositeFile, SWT.NULL);
		saveButton.setText("Telnet Command File Save");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		saveButton.setLayoutData(gridData);

		/* Test{^͔Visible */
		testButton = new Button(compositeFile, SWT.NULL);
		testButton.setText("Test");
		testButton.setLayoutData(new GridData());
		testButton.setVisible(false);

		label = new Label(compositeFile, SWT.NONE);
		label.setText("Telnet Command File");
		listGridData = new GridData();
		listGridData.horizontalSpan = 1;
		listGridData.verticalSpan = 1;
		label.setLayoutData(listGridData);
		commandFilePathText = new Text(compositeFile, SWT.BORDER);
		data = new GridData();
		data.horizontalSpan = HORIZONTAL_SPAN3;
		data.verticalSpan = 1;
		data.widthHint = FILE_PATH_TEXT_WIDTH_HINT;
		commandFilePathText.setLayoutData(data);

		commandText = new Text(compositeMonitor, SWT.MULTI | SWT.BORDER
				| SWT.V_SCROLL | SWT.WRAP);
		commandText.setText("");
		gridData = new GridData(GridData.FILL_HORIZONTAL);
		gridData.horizontalSpan = 2;
		gridData.widthHint = COMMAND_TEXT_WIDTH_HINT;
		gridData.heightHint = COMMAND_TEXT_HEIGHT_HINT;

		gridData.grabExcessHorizontalSpace = true;
		gridData.grabExcessVerticalSpace = true;

		commandText.setLayoutData(gridData);

		/* Dummy column */
		label = new Label(compositeButton, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		cancelButton = new Button(compositeButton, SWT.NONE);

		cancelButton.setSize(BUTTON_WIDTH, BUTTON_HEIGHT);
		cancelButton.setText(" Cancel ");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		cancelButton.setLayoutData(gridData);

		setButton = new Button(compositeButton, SWT.NONE);

		setButton.setSize(BUTTON_WIDTH, BUTTON_HEIGHT);
		setButton.setText(" Set     ");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		setButton.setLayoutData(gridData);

		assignmentYearText = new Text(compositeDateText, SWT.BORDER);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = 40;
		assignmentYearText.setLayoutData(gridData);

		assignmentMonthText = new Text(compositeDateText, SWT.BORDER);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = 20;
		assignmentMonthText.setLayoutData(gridData);

		label = new Label(compositeDateText, SWT.NONE);
		label.setText("/");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		assignmentDateText = new Text(compositeDateText, SWT.BORDER);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = 20;
		assignmentDateText.setLayoutData(gridData);

		assignmentDateHourCombo = new Combo(compositeDateText, SWT.READ_ONLY);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		// gridData.widthHint = 20;
		assignmentDateHourCombo.setLayoutData(gridData);
		setHourCombo(assignmentDateHourCombo);
		assignmentDateHourCombo.setVisibleItemCount(15);
		assignmentDateHourCombo.select(0);

		label = new Label(compositeDateText, SWT.NONE);
		label.setText(":");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		assignmentDateMinuteCombo = new Combo(compositeDateText, SWT.READ_ONLY);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		assignmentDateMinuteCombo.setLayoutData(gridData);
		setMinuteCombo(assignmentDateMinuteCombo);
		assignmentDateMinuteCombo.setVisibleItemCount(15);
		assignmentDateMinuteCombo.select(0);

		CalendarComposite calendarComposite = new CalendarComposite();
		calendarComposite.setYearText(assignmentYearText);
		calendarComposite.setMonthText(assignmentMonthText);
		calendarComposite.setDateText(assignmentDateText);
		calendarComposite.createCalendarView(compositeCalendar);

		assignmentYearText.setText(calendarComposite.getCalendarTable()
				.getTodaysYY());
		assignmentMonthText.setText(calendarComposite.getCalendarTable()
				.getTodaysMM());
		assignmentDateText.setText(calendarComposite.getCalendarTable()
				.getTodaysDD());

		/*
		 * Scroll compositeZbg
		 */
		scrollComposite.setContent(baseComposite0);
		scrollComposite.setMinSize(SCROLL_COMPOSITE_SIZE[0],
				SCROLL_COMPOSITE_SIZE[1]);
		scrollComposite.setExpandHorizontal(true);
		scrollComposite.setExpandVertical(true);

		setText();

		setListener();

		getTaskSchedule();

		setCommandTextView();

	}

	private void setListener() {
		/*
		 * XV{^Listener
		 */
		refreshButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {

				refreshButton.setEnabled(false);
				if (provisionIDInfo != null) {
					provisionIDInfo = ProvisionInfoControl.getInstance()
							.getProvisionInfo(provisionIDInfo.getProvisionID());
					setText();
					getTaskSchedule();
					setCommandTextView();
				}

				refreshButton.setEnabled(true);
			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});

		addButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {

				addButton.setEnabled(false);
				if (idText.getText().equals("")) {
					MessageDialog.openError(getSite().getShell(), "Error",
							"Invalid ID");
					idText.setFocus();
					addButton.setEnabled(true);
					return;
				}
				try {
					Integer.parseInt(idText.getText());
				} catch (Exception e) {
					MessageDialog.openError(getSite().getShell(), "Error",
							"Invalid ID=" + idText.getText() + " "
									+ e.getMessage());
					idText.setFocus();
					addButton.setEnabled(true);
					return;
				}
				if (ipAddressText.getText().equals("")) {
					MessageDialog.openError(getSite().getShell(), "Error",
							"Invalid IP Address");
					ipAddressText.setFocus();
					addButton.setEnabled(true);
					return;
				}
				Map provisionMap = ProvisionInfoControl.getInstance()
						.getProvisionInfoHashMap();
				if (provisionMap.containsKey(idText.getText())) {
					MessageDialog.openError(getSite().getShell(), "Error",
							"Already ID=" + idText.getText());
					idText.setFocus();
				} else {
					setProvision();
				}
				addButton.setEnabled(true);
			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});

		editButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {

				editButton.setEnabled(false);
				Map provisionMap = ProvisionInfoControl.getInstance()
						.getProvisionInfoHashMap();
				if (provisionMap.containsKey(idText.getText())) {
					setProvision();
				} else {
					MessageDialog.openError(getSite().getShell(), "Error",
							"Not found ID. ID=" + idText.getText());
					idText.setFocus();

				}
				editButton.setEnabled(true);
			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});

		deleteButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {

				deleteButton.setEnabled(false);
				ProvisionInfoControl.getInstance().deleteProvisionInfo(
						idText.getText());
				deleteButton.setEnabled(true);
			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});

		/*
		 * XPW[Zbg{^Listener
		 */
		setButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {
				setButton.setEnabled(false);
				scheduleList.removeAll();
				getSelectDate();

				setButton.setEnabled(true);

			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});

		commandFileSelectButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {
				commandFileSelectButton.setEnabled(false);

				FileDialog openDialog = new FileDialog(getEditorSite()
						.getShell(), SWT.OPEN);
				String[] fileExt = new String[1];
				fileExt[0] = "*.*";
				openDialog.setFilterExtensions(fileExt);
				openDialog.setFilterPath(ProvisionPreference.PROVISION_DIR);

				String openFileName = openDialog.open();

				if (openFileName != null) {
					commandFilePathText.setText(openFileName);
				}

				commandFileSelectButton.setEnabled(true);
			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});

		ftpSourceFileSelectButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {
				ftpSourceFileSelectButton.setEnabled(false);

				FileDialog openDialog = new FileDialog(getEditorSite()
						.getShell(), SWT.OPEN);
				String[] fileExt = new String[1];
				fileExt[0] = "*.*";
				openDialog.setFilterExtensions(fileExt);
				openDialog.setFilterPath(ProvisionPreference.PROVISION_DIR);

				String openFileName = openDialog.open();

				if (openFileName != null) {
					ftpSourceFilePathText.setText(openFileName);
					ftpStoreFilePathText.setText("./");

				}

				ftpSourceFileSelectButton.setEnabled(true);
			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});

		/*
		 * XPW[LZ{^Listener
		 */
		cancelButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {
				cancelButton.setEnabled(false);

				int selectListIndex = scheduleList.getSelectionIndex();

				if (selectListIndex >= 0) {

					scheduleList.removeAll();
					startDate = null;
					Map scheduleMap = ProvisionCommandTaskScheduleControl
							.getInstance().getTaskScheduleMap();
					ProvisionCommandTaskScheduleInfo taskInfo = (ProvisionCommandTaskScheduleInfo) scheduleMap
							.get(provisionIDInfo.getProvisionID());
					if (taskInfo != null) {
						cancelTaskSchedule(taskInfo);
						provisionIDInfo.setStartDate(null);
						getTaskSchedule();
					}
				}

				cancelButton.setEnabled(true);
			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});

		saveButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {

				saveButton.setEnabled(false);
				saveCommandFile();
				saveButton.setEnabled(true);
			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});

		testButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {

				testButton.setEnabled(false);

				test();
				testButton.setEnabled(true);
			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});

	}

	private void setText() {
		if (provisionIDInfo != null) {
			idText.setText(provisionIDInfo.getProvisionID());
			nodeNameText.setText(provisionIDInfo.getNodeName());
			ipAddressText.setText(provisionIDInfo.getIpAddress());
			groupText.setText(provisionIDInfo.getGroup());
			if (provisionIDInfo.getUserName() != null) {
				userName.setText(provisionIDInfo.getUserName());
			}
			if (provisionIDInfo.getPassword() != null) {
				passwordText.setText(provisionIDInfo.getPassword());
			}
			if (provisionIDInfo.getSuPpassword() != null) {
				suPasswordText.setText(provisionIDInfo.getSuPpassword());
			}
			nodeKindCombo.setText(provisionIDInfo.getNodeKind());
			if (provisionIDInfo.getCommandFile() != null) {
				commandFilePathText.setText(provisionIDInfo.getCommandFile());
			}

			if (provisionIDInfo.getFtpSourceFile() != null) {
				ftpSourceFilePathText.setText(provisionIDInfo
						.getFtpSourceFile());
			}
			if (provisionIDInfo.getFtpStoreFile() != null) {
				ftpStoreFilePathText.setText(provisionIDInfo.getFtpStoreFile());
			}

			if (provisionIDInfo.getStartDate() != null) {
				scheduleList.removeAll();
				scheduleList.add(dateformat.format(provisionIDInfo
						.getStartDate()), 0);
				startDate = provisionIDInfo
				.getStartDate();
			}
		}
	}

	/*
	 * m[hComboBoxZbg܂B
	 * 
	 * @param composite2 Composite
	 */
	private void setNodeKind(Composite composite2) {
		Label label = new Label(composite2, SWT.NONE);
		label.setText("Node Kind");

		GridData gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		nodeKindCombo = new Combo(composite2, SWT.DROP_DOWN | SWT.READ_ONLY);

		HashMap nodeIconMap = MediaResource.getInstance().getIconDataList();
		Iterator it;

		for (it = nodeIconMap.keySet().iterator(); it.hasNext();) {
			String key = (String) it.next();
			nodeKindCombo.add(key);
		}

		nodeKindCombo.select(0);
	}

	private void setProvision() {

		ProvisionInfo provisionInfo = createProvisionInfo();
		ProvisionInfoControl.getInstance().setProvisionInfo(idText.getText(),
				provisionInfo);
	}

	private ProvisionInfo createProvisionInfo() {
		ProvisionInfo provisionInfo = new ProvisionInfo();
		provisionInfo.setProvisionID(idText.getText());
		provisionInfo.setNodeName(nodeNameText.getText());
		provisionInfo.setIpAddress(ipAddressText.getText());
		provisionInfo.setGroup(groupText.getText());
		provisionInfo.setNodeKind(nodeKindCombo.getText());
		provisionInfo.setUserName(userName.getText());
		provisionInfo.setPassword(passwordText.getText());
		provisionInfo.setSuPpassword(suPasswordText.getText());

		provisionInfo.setCommandFile(commandFilePathText.getText());
		provisionInfo.setFtpSourceFile(ftpSourceFilePathText.getText());
		provisionInfo.setFtpStoreFile(ftpStoreFilePathText.getText());

		provisionInfo.setStartDate(startDate);

		return provisionInfo;
	}

	private void setCommandTextView() {

		// System.out.println(provisionIDInfo.getCommandFile());
		commandText.setText("");
		if (provisionIDInfo != null && provisionIDInfo.getCommandFile() != null) {
			try {
				ArrayList parseCommandList = commandFileParse
						.parse(provisionIDInfo.getCommandFile());
				if (parseCommandList == null) {
					return;
				}
				for (int i = 0; i < parseCommandList.size(); i++) {
					commandText.append((String) parseCommandList.get(i)
							+ System.getProperty("line.separator"));
				}
			} catch (Exception e) {
				logger.warning("Exception " + e.getMessage());
			}
		}
	}

	private void saveCommandFile() {

		Display.getDefault().syncExec(new Runnable() {
			public void run() {
				FileDialog openDialog = new FileDialog(getEditorSite()
						.getShell(), SWT.OPEN);
				if (!commandFilePathText.getText().equals("")) {
					openDialog.setFilterPath(commandFilePathText.getText());
				} else {
					openDialog.setFilterPath(ProvisionPreference.PROVISION_DIR);
				}
				selectFileName = openDialog.open();

			}
		});

		if (selectFileName == null || selectFileName.equals("")) {
			return;
		}

		File selectCommandFile = new File(selectFileName);
		if (selectCommandFile.exists()) {
			if (!MessageDialog.openConfirm(getEditorSite().getShell(),
					"Confirmation", selectCommandFile + " has already existed."
							+ System.getProperty("line.separator")
							+ "Are you sure you want to over write it?")) {
				return;
			}
		}
		FileWriter fileWriter = null;
		BufferedWriter bufferedWriter = null;
		boolean ok = true;
		try {

			if (selectCommandFile == null) {
				return;
			}

			fileWriter = new FileWriter(selectCommandFile);
			bufferedWriter = new BufferedWriter(fileWriter);

			String commandString = commandText.getText();

			Pattern pattern;
			String[] commandStrArray;
			pattern = Pattern.compile(System.getProperty("line.separator"));
			commandStrArray = pattern.split(commandString);

			if (commandStrArray != null) {
				for (int i = 0; i < commandStrArray.length; i++) {
					bufferedWriter.write(commandStrArray[i]);
				}
			}

		} catch (Exception ee) {
			ok = false;
		} finally {

			if (bufferedWriter != null) {
				try {
					bufferedWriter.close();
				} catch (Exception e1) {
					logger.warning("Exception " + e1.getMessage());
				}
			}
			if (fileWriter != null) {
				try {
					fileWriter.close();
				} catch (Exception e2) {
					logger.warning("Exception " + e2.getMessage());
				}
			}
		}

		if (ok) {

			MessageDialog.openInformation(getEditorSite().getShell(),
					"Information", "Successfully saved."
							+ System.getProperty("line.separator")
							+ selectCommandFile);

			commandFilePathText.setText(selectFileName);

		}
	}

	/*
	 * Hour Combo Boxݒ肵܂B
	 * 
	 */
	private void setHourCombo(Combo combo) {
		for (int i = 0; i < 24; i++) {
			String work = Integer.toString(i);

			if (work.length() == 1) {
				work = "0" + work;
			}

			combo.add(work);
		}
	}

	/*
	 * Minute Combo Boxݒ肵܂B
	 * 
	 * @param combo Combo
	 */
	private void setMinuteCombo(Combo combo) {
		for (int i = 0; i < 60; i++) {
			String work = Integer.toString(i);

			if (work.length() == 1) {
				work = "0" + work;
			}

			combo.add(work);
		}
	}

	/*
	 * ^XNXPW[[h܂B
	 * 
	 */
	private void getTaskSchedule() {
		if (provisionIDInfo == null) {
			return;
		}
		Map taskSchduleMap = ProvisionCommandTaskScheduleControl.getInstance()
				.getTaskScheduleMap();

		ProvisionCommandTaskScheduleInfo taskScheduleInfo = (ProvisionCommandTaskScheduleInfo) taskSchduleMap
				.get(provisionIDInfo.getProvisionID());
		ProvisionInfo info = null;
		if (taskScheduleInfo != null) {
			info = taskScheduleInfo.getProvisionInfo();
		}
		if (info != null && info.getStartDate() != null
				&& !info.getStartDate().equals("")) {

			scheduleList.removeAll();
			scheduleList.add(dateformat.format(info.getStartDate()), 0);

		} else if (provisionIDInfo.getStartDate() != null) {
			scheduleList.removeAll();
			scheduleList.add(dateformat.format(provisionIDInfo.getStartDate()),
					0);

		} else {
			scheduleList.removeAll();
		}

	}

	private String getDateStr(int dateData) {

		String work = Integer.toString(dateData);

		if (work.length() == 1) {
			work = "0" + work;
		}

		return work;

	}

	private void getSelectDate() {
		int indexStartHH = assignmentDateHourCombo.getSelectionIndex();
		int indexStartMin = assignmentDateMinuteCombo.getSelectionIndex();

		int startYY = 0;

		try {
			startYY = Integer.parseInt(assignmentYearText.getText());
		} catch (NumberFormatException e) {
			MessageDialog.openError(getSite().getShell(), "Error",
					"Illegal Date " + " !");
			assignmentYearText.setFocus();

			return;
		}

		int startMM = 0;

		try {
			startMM = Integer.parseInt(assignmentMonthText.getText());
		} catch (NumberFormatException e) {
			MessageDialog.openError(getSite().getShell(), "Error",
					"Illegal Date " + " !");
			assignmentMonthText.setFocus();

			return;
		}

		int startDD = 0;

		try {
			startDD = Integer.parseInt(assignmentDateText.getText());
		} catch (NumberFormatException e) {
			MessageDialog.openError(getSite().getShell(), "Error",
					"Illegal Date " + " !");
			assignmentDateText.setFocus();

			return;
		}

		int startHH = 0;

		try {
			startHH = Integer.parseInt(assignmentDateHourCombo
					.getItem(indexStartHH));
		} catch (NumberFormatException e) {
			MessageDialog.openError(getSite().getShell(), "Error",
					"Illegal Date " + " !");
			assignmentDateHourCombo.setFocus();

			return;
		}

		int startMIN = 0;

		try {
			startMIN = Integer.parseInt(assignmentDateMinuteCombo
					.getItem(indexStartMin));
		} catch (NumberFormatException e) {
			MessageDialog.openError(getSite().getShell(), "Error",
					"Illegal Date " + " !");
			assignmentDateMinuteCombo.setFocus();

			return;
		}

		/* Jn */
		Calendar cal = Calendar.getInstance();
		cal.set(startYY, startMM - 1, startDD, startHH, startMIN, 0);
		startDate = cal.getTime();

		scheduleList.add(dateformat.format(startDate), 0);

	}

	private void test() {
		String commandString = commandText.getText();

		Pattern pattern;
		String[] commandStrArray;
		pattern = Pattern.compile(System.getProperty("line.separator"));
		commandStrArray = pattern.split(commandString);
		ArrayList commandList = new ArrayList();

		if (commandStrArray != null) {
			for (int i = 0; i < commandStrArray.length; i++) {
				commandList.add(commandStrArray[i]);
			}
		}

		ProvisionInfo testProvisionInfo = createProvisionInfo();

		if (!testProvisionInfo.getFtpSourceFile().equals("")
				&& !testProvisionInfo.getFtpStoreFile().equals("")) {

			try {
				EngineFtp testFtp = new EngineFtp(testProvisionInfo);
				testFtp.putFile();
			} catch (LoginAuthAbortException e) {
				MessageDialog.openError(getSite().getShell(), "Error",
						"LoginAuthAbortException " + e.getMessage());

			} catch (Exception e) {
				MessageDialog.openError(getSite().getShell(), "Error",
						"Exception " + e.getMessage());
			}
		}

		if (!testProvisionInfo.getCommandFile().equals("")) {
			EngineTelnet telnet = new EngineTelnet(testProvisionInfo);

			try {
				telnet.start(true, commandList);
			} catch (SocketTimeoutException e) {
				MessageDialog.openError(getSite().getShell(), "Error",
						"SocketTimeoutException " + e.getMessage());

			} catch (Exception e) {
				MessageDialog.openError(getSite().getShell(), "Error",
						"Exception " + e.getMessage());
			}
		}

	}

	/*
	 * ^XNXPW[LZ܂B
	 * 
	 */
	private void cancelTaskSchedule(ProvisionCommandTaskScheduleInfo taskInfo) {

		// Timer Cancel
		if (taskInfo != null) {
			ProvisionCommandTaskScheduleControl.getInstance()
					.cancelTaskSchedule(taskInfo);
		}
	}

	/**
	 * tH[JXZbgꂽ̏łB
	 */
	public void setFocus() {
	}

	/**
	 * Xe[^XC\Zbg܂B
	 * 
	 */
	protected void setStatusLine() {

	}

}
