/*
 * Created on 2007/01/10
 *
 *
 * Copyright(c) 2007 Yoshimasa Matsumoto
 */
package netjfwatcher.provision.info;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class ProvisionInfoControl {

	private Map provisionHashMap;

	private ProvisionInfoControl() {
		provisionHashMap = Collections.synchronizedMap(new LinkedHashMap());
	}

	public void setProvisionInfo(String provisionID, ProvisionInfo provisionInfo) {
		provisionHashMap.put(provisionID, provisionInfo);
	}

	public ProvisionInfo getProvisionInfo(String provisionID) {
		return (ProvisionInfo) provisionHashMap.get(provisionID);
	}

	public void deleteProvisionInfo(String provisionID) {
		provisionHashMap.remove(provisionID);
	}

	public void deleteAllProvisionInfo() {
		provisionHashMap.clear();
	}
	
	public Map getProvisionInfoHashMap() {
		return provisionHashMap;
	}
	
	/**
	 * ̃NX̃CX^XԂ܂B<BR>
	 * iNXێĂVOgEIuWFNg Ԃ܂j<BR>
	 * 
	 * @return VOgEIuWFNgƂĂ̂̃NX CX^X
	 */
	public static ProvisionInfoControl getInstance() {
		return SingletonAboutMessage.INSTANCE;
	}


	/**
	 * VOgEIuWFNgێNXłB<BR>
	 * 
	 */
	private static class SingletonAboutMessage {
		static final ProvisionInfoControl INSTANCE = new ProvisionInfoControl();
	}
}
