/*
 * Created on 2007/01/10
 *
 *
 * Copyright(c) 2007 Yoshimasa Matsumoto
 */
package netjfwatcher.provision.model.action;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;

import netjfwatcher.application.NetJFWatcherApplication;
import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.provision.command.core.LoggingProvision;
import netjfwatcher.provision.command.schedule.ProvisionCommandTaskScheduleControl;
import netjfwatcher.provision.command.schedule.ProvisionCommandTaskScheduleInfo;
import netjfwatcher.provision.info.ProvisionInfo;
import netjfwatcher.provision.info.ProvisionInfoControl;
import netjfwatcher.provision.nodemaneger.list.ProvisionMessageQueue;
import netjfwatcher.provision.preference.ProvisionPreference;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

/**
 * NodeXgViewł̃ANVNXłB
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public abstract class ActionBuilderProvisionNodeList {
	/* MO */
	private static Logger logger;

	/*
	 * m[hViewō\\EditorPartEditorPart
	 * JxɁAUEditorPartCloseĂOpen
	 */
	private IEditorPart editorNodeConfigView;

	private IAction showProvisionTableAction = new ActionShowProvisionListTable();

	private IAction importNodeListAction = new ActionImportProvisionListFile();

	private IAction importNodeListActionSocket = new ActionImportProvisionListFileSocket();

	private IAction exportNodeListAction = new ActionExportProvisionListFile();

	private IAction clearProvisionNodeListAction = new ActionRemoveProvisionNodeList();
	
	/* 摜肷邽߂PluginResource bundle */
	private final Bundle bundle = NetJFWatcherPlugin.getInstance().getBundle();

	public ActionBuilderProvisionNodeList() {
		logger = Logger.getLogger(this.getClass().getName());
	}

	public IAction getActionImportNodeListFile() {
		return importNodeListAction;
	}

	public IAction getActionImportNodeListFileSocket() {
		return importNodeListActionSocket;
	}

	public IAction getActionExportNodeListFile() {
		return exportNodeListAction;
	}

	public IAction getActionShowProvisionTable() {
		return showProvisionTableAction;
	}

	public IAction getActionRemoveProvisionNodeListTable() {
		return clearProvisionNodeListAction;
	}
	
	/**
	 * Provisionm[hListe[u\XVANVm[hꊇo^ANV Ă΂܂B
	 * ł́A܂񂪂̃NXpNXŃI[o[ChA ۂ̃m[hListe[u\XVLq܂B
	 * 
	 */
	protected void refreshProvisionTable() {
	}

	private ArrayList getNodeList() {
		ArrayList nodeList = null;
		Iterator it = null;
		Map provisionMap = ProvisionInfoControl.getInstance()
				.getProvisionInfoHashMap();
		for (it = provisionMap.keySet().iterator(); it.hasNext();) {
			String key = (String) it.next();
			ProvisionInfo info = (ProvisionInfo) provisionMap.get(key);

			if (info == null) {
				continue;
			}
			nodeList.add(info);
		}
		return nodeList;
	}

	private abstract class AbstractProvisionTableListAction extends Action {

		public final void run() {
			doTask();
		}

		protected abstract void doTask();
	}

	protected class ActionShowProvisionListTable extends
			AbstractProvisionTableListAction {

		public ImageDescriptor getImageDescriptor() {
			return ImageDescriptor.createFromURL(bundle
					.getEntry("icons/reload.gif"));
		}

		public String getText() {
			return "Show Provision Table";
		}

		public String getToolTipText() {
			return "Show Provision Table";
		}

		protected void doTask() {
			refreshProvisionTable();
		}
	}

	protected class ActionImportProvisionListFile extends
			AbstractProvisionTableListAction {

		public ImageDescriptor getImageDescriptor() {
			return ImageDescriptor.createFromURL(bundle
					.getEntry("icons/import_wiz.gif"));
		}

		public String getText() {
			return "Import Provision File";
		}

		public String getToolTipText() {
			return "Import Provision File";
		}

		protected void doTask() {
			Shell shell = new Shell();
			FileDialog openDialog = new FileDialog(shell, SWT.OPEN);
			String[] fileExt = new String[1];
			fileExt[0] = "*.xml";
			openDialog.setFilterExtensions(fileExt);
			openDialog.setFilterPath("./provision");

			final String openFileName = openDialog.open();

			if (openFileName == null || openFileName.equals("")) {
				if (shell != null) {
					shell.dispose();
				}
				return;
			}

			BusyIndicator.showWhile(PlatformUI.getWorkbench().getDisplay(),
					new Runnable() {
						public void run() {

							try {
								ProvisionFileParse parseFileInstance = new ProvisionFileParse();
								parseFileInstance
										.parseProvisionFile(openFileName);
							} catch (ProvisionImportParseAbortException e) {
								logger
										.warning("ProvisionImportParseAbortException "
												+ e.getMessage());
								Shell shell = new Shell();
								MessageDialog.openWarning(shell,
										"Provision Import File.",
										"Abort Parse Provision Import File. "
												+ e.getMessage());

								if (shell != null) {
									shell.dispose();
								}

								return;
							} catch (Exception e) {
								logger.warning("Exception " + e.getMessage());
								Shell shell = new Shell();
								MessageDialog.openWarning(shell,
										"Provision Import File.",
										"Abort Parse Provision Import File. "
												+ e.getMessage());

								if (shell != null) {
									shell.dispose();
								}

								return;
							}

						}
					});
			if (shell != null) {
				shell.dispose();
			}
		}
	}

	protected class ActionImportProvisionListFileSocket extends
			ActionImportProvisionListFile {

		protected void doTask() {

		}
	}

	protected class ActionExportProvisionListFile extends
			AbstractProvisionTableListAction {

		public ImageDescriptor getImageDescriptor() {
			return ImageDescriptor.createFromURL(bundle
					.getEntry("icons/export_wiz.gif"));
		}

		public String getText() {
			return "Export Provision File";
		}

		public String getToolTipText() {
			return "Export Provision File";
		}

		protected void doTask() {
			exportNodeInfo(false);
		}
	}

	/*
	 * Provisionm[h񃊃XgGNX|[g܂B
	 * 
	 * @param isSocket lbg[NoRō̎悷邩ۂtO
	 */
	private void exportNodeInfo(boolean isSocket) {
		Shell shell = new Shell();
		FileDialog openDialog = new FileDialog(shell, SWT.SAVE);

		String[] fileExt = new String[1];
		fileExt[0] = "*.xml";
		openDialog.setFilterExtensions(fileExt);
		openDialog.setFilterPath(ProvisionPreference.PROVISION_DIR);

		String xmlFile = openDialog.open();

		logger.info("XML file name : " + xmlFile);

		shell.dispose();

		if (xmlFile == null) {
			return;
		}

		ProvisionFileParse outProvision = new ProvisionFileParse();
		outProvision.outputXMLFile(xmlFile);

	}
	
    private final class ActionRemoveProvisionNodeList extends AbstractProvisionTableListAction {

        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL(
                bundle.getEntry("icons/clear.gif"));
        }


        public String getText() {
            return "Clear Provision";
        }


        public String getToolTipText() {
            return "Clear Provision";
        }


        protected void doTask() {
        	if(ProvisionStartStopStatus.getInstance().isRunProvision()) {
        	
        		Shell shell = new Shell();
				MessageDialog.openWarning(shell,
						"Provision Status",
						"Provision Running."
								);

				if (shell != null) {
					shell.dispose();
				}

				return;
        	} else {
        		LoggingProvision.getInstance().stopLog();

    			Map provisionMap = ProvisionInfoControl.getInstance()
    					.getProvisionInfoHashMap();

    			Map taskScheduleMap = ProvisionCommandTaskScheduleControl
    					.getInstance().getTaskScheduleMap();

    			Iterator it = null;
    			for (it = provisionMap.keySet().iterator(); it.hasNext();) {
    				String provisionIDKey = (String) it.next();
    				ProvisionCommandTaskScheduleInfo taskScheduleInfo = (ProvisionCommandTaskScheduleInfo) taskScheduleMap
    						.get(provisionIDKey);

    				if (taskScheduleInfo == null) {
    					continue;
    				}

    				ProvisionCommandTaskScheduleControl.getInstance()
    						.cancelTaskSchedule(taskScheduleInfo);
    				ProvisionMessageQueue.getInstance().pushProvisionMessage(
    						provisionIDKey);
    			}
    			ProvisionInfoControl.getInstance().deleteAllProvisionInfo();
        		refreshProvisionTable();
        	}
        }
    }
}
