/*
 * Created on 2007/01/10
 *
 *
 * Copyright(c) 2007 Yoshimasa Matsumoto
 */
package netjfwatcher.provision.model.action;

import java.util.logging.Logger;

import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.provision.gui.editor.EditorInputProvision;
import netjfwatcher.provision.gui.editor.EditorProvisionCommandFileView;
import netjfwatcher.provision.gui.editor.EditorProvisionScheduleView;
import netjfwatcher.provision.info.ProvisionInfo;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

/**
 * Provision ViewɊւANVNXłB
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class ActionBuilderProvisionNodeView extends Action {
	/*
	 * OIEditorParti[(ANVɈUClose邽)
	 */
	private static IEditorPart editorNodeConfigView;

	/* MO */
	private static Logger logger;

	/* 摜肷邽߂PluginResource bundle */
	private final Bundle bundle = NetJFWatcherPlugin.getInstance().getBundle();

	private IAction provisionScheduleViewAction = new ActionProvisionScheduleView();

	private IAction provisionScheduleViewSocketAction = new ActionProvisionScheduleViewSocket();

	private IAction provisionFileViewAction = new ActionProvisionFileView();

	private IAction provisionFileViewActionSocket = new ActionProvisionFileViewSocket();

	/**
	 * Provision ViewɊւANVNXCX^X𐶐܂B
	 * 
	 */
	public ActionBuilderProvisionNodeView() {
		logger = Logger.getLogger(this.getClass().getName());
	}

	public IAction getActionProvisionScheduleView() {
		return provisionScheduleViewAction;
	}

	public IAction getActionProvisionScheduleViewSocket() {
		return provisionScheduleViewSocketAction;
	}

	public IAction getActionProvisionFileView() {
		return provisionFileViewAction;
	}

	public IAction getActionProvisionFileViewSocket() {
		return provisionFileViewActionSocket;
	}

	private abstract class AbstractProvisionNodeAction extends Action {

		public final void run() {
			doTask();
		}

		protected abstract void doTask();

		public ImageDescriptor getImageDescriptor() {
			return ImageDescriptor.createFromURL(bundle
					.getEntry("icons/file_obj.gif"));
		}

		public String getText() {
			return "Provision Node Schedule View";
		}

		public String getToolTipText() {
			return "Provision Node Schedule View";
		}
	}

	public final class ActionProvisionScheduleView extends
			AbstractProvisionNodeAction {
		/* Provision */
		private ProvisionInfo provisionInfo;

		protected void doTask() {
			IWorkbenchPage activePage = PlatformUI.getWorkbench()
					.getActiveWorkbenchWindow().getActivePage();

			/* Tree\NodeZbg */
			String nodeName;
			if (provisionInfo != null) {
				nodeName = "ID=" + provisionInfo.getProvisionID() + " "
						+ provisionInfo.getNodeName() + "("
						+ provisionInfo.getIpAddress() + ")";
			} else {
				nodeName = "New ID" + " ";
			}
			try {

				activePage.openEditor(new EditorInputProvision(nodeName
						+ EditorProvisionScheduleView.TITLE_SUFFIX,
						provisionInfo, false),
						EditorProvisionScheduleView.class.getName());
			} catch (PartInitException e) {
				logger.warning(e.getMessage());
				e.printStackTrace();
			}
		}

		public void setNodeInfo(ProvisionInfo provisionInfo) {
			this.provisionInfo = provisionInfo;
		}
	}

	public final class ActionProvisionScheduleViewSocket extends
			AbstractProvisionNodeAction {
		/* Provision */
		private ProvisionInfo provisionInfo;

		protected void doTask() {
			IWorkbenchPage activePage = PlatformUI.getWorkbench()
					.getActiveWorkbenchWindow().getActivePage();

			/* Tree\NodeZbg */
			String nodeName = "ID=" + provisionInfo.getProvisionID() + " "
					+ provisionInfo.getNodeName() + "("
					+ provisionInfo.getIpAddress() + ")";

			try {

				activePage.openEditor(new EditorInputProvision(nodeName
						+ EditorProvisionScheduleView.TITLE_SUFFIX,
						provisionInfo, true), EditorProvisionScheduleView.class
						.getName());
			} catch (PartInitException e) {
				logger.warning(e.getMessage());
				e.printStackTrace();
			}
		}

		public void setNodeInfo(ProvisionInfo provisionInfo) {
			this.provisionInfo = provisionInfo;
		}
	}

	public class ActionProvisionFileView extends AbstractProvisionNodeAction {

		protected ProvisionInfo provisionInfo;

		public ImageDescriptor getImageDescriptor() {
			return ImageDescriptor.createFromURL(bundle
					.getEntry("icons/file_obj.gif"));
		}

		public String getText() {
			return "Provision Telnet Command File View";
		}

		public String getToolTipText() {
			return "Provision Telnet Command File View";
		}

		protected void doTask() {
			IWorkbenchPage activePage = PlatformUI.getWorkbench()
					.getActiveWorkbenchWindow().getActivePage();

			if (provisionInfo == null) {
				provisionInfo = new ProvisionInfo();
				provisionInfo.setIpAddress(null);
			}

			try {

				if (editorNodeConfigView != null) {
					activePage.closeEditor(editorNodeConfigView, false);
					editorNodeConfigView = null;
				}

				editorNodeConfigView = activePage.openEditor(
						new EditorInputProvision(
								EditorProvisionCommandFileView.TITLE_SUFFIX,
								provisionInfo, false),
						EditorProvisionCommandFileView.class.getName());
			} catch (PartInitException e) {
				logger.warning(e.getMessage());
				e.printStackTrace();
			}
		}

		public void setProvisionInfo(ProvisionInfo provisionInfo) {
			this.provisionInfo = provisionInfo;
		}
	}

	public class ActionProvisionFileViewSocket extends ActionProvisionFileView {

		protected void doTask() {
			IWorkbenchPage activePage = PlatformUI.getWorkbench()
					.getActiveWorkbenchWindow().getActivePage();

			if (provisionInfo == null) {
				provisionInfo = new ProvisionInfo();
				provisionInfo.setIpAddress(null);
			}

			try {

				if (editorNodeConfigView != null) {
					activePage.closeEditor(editorNodeConfigView, false);
					editorNodeConfigView = null;
				}

				editorNodeConfigView = activePage.openEditor(
						new EditorInputProvision(
								EditorProvisionCommandFileView.TITLE_SUFFIX,
								provisionInfo, true),
						EditorProvisionCommandFileView.class.getName());
			} catch (PartInitException e) {
				logger.warning(e.getMessage());
				e.printStackTrace();
			}
		}
	}
}
