/*
 * Created on 2007/01/10
 *
 *
 * Copyright(c) 2007 Yoshimasa Matsumoto
 */
package netjfwatcher.provision.model.action;

import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;

import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.provision.command.core.LoggingProvision;
import netjfwatcher.provision.command.schedule.ProvisionCommandTaskPreference;
import netjfwatcher.provision.command.schedule.ProvisionCommandTaskScheduleControl;
import netjfwatcher.provision.command.schedule.ProvisionCommandTaskScheduleInfo;
import netjfwatcher.provision.info.ProvisionInfo;
import netjfwatcher.provision.info.ProvisionInfoControl;
import netjfwatcher.provision.nodemaneger.list.ProvisionMessageQueue;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

/**
 * ProvisionɊւANVNXłB
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class ActionBuilderProvisionStartStop {
	/* MO */
	private static Logger logger;

	/* ProvisionNANV */
	private IAction startProvision = new ActionStartProvision();

	/* Provision~ANV */
	private IAction stopProvision = new ActionStopProvision();


	/* 摜肷邽߂PluginResource bundle */
	private final Bundle bundle = NetJFWatcherPlugin.getInstance().getBundle();

	/**
	 * ProvisionɊւANVNXCX^X ܂B
	 * 
	 */
	public ActionBuilderProvisionStartStop() {
		logger = Logger.getLogger(this.getClass().getName());
	}

	public IAction getActionStartProvision() {
		return startProvision;
	}

	public IAction getActionStopProvision() {
		return stopProvision;
	}

	/**
	 * ProvisionɊւANVNXłB
	 * 
	 * @author Yoshimasa Matsumoto
	 * @version 1.0
	 */
	private abstract class AbstractEngineAction extends Action {
		/**
		 * ANV܂B
		 */
		public final void run() {
			doTask();
		}

		/**
		 * ANV^XNłB
		 * 
		 */
		protected abstract void doTask();
	}

	/**
	 * ProvisionNANVNXłB
	 * 
	 * @author Yoshimasa Matsumoto
	 * @version 1.0
	 */
	private final class ActionStartProvision extends AbstractEngineAction {
		/**
		 * ProvisionNANṼACRImageDescriptorԂ܂B
		 * 
		 * @return ProvisionNANṼACRImageDescriptor
		 */
		public ImageDescriptor getImageDescriptor() {
			return ImageDescriptor.createFromURL(bundle
					.getEntry("icons/engine.gif"));
		}

		/**
		 * ProvisionNANVTextԂ܂B
		 * 
		 * @return ProvisionNANVText
		 */
		public String getText() {
			return "Provision start";
		}

		/**
		 * ProvisionNANVToolTipTextԂ܂B
		 * 
		 * @return ProvisionNANVToolTipText
		 * 
		 */
		public String getToolTipText() {
			return "Provision start";
		}

		/**
		 * Provision̋Ns܂B
		 * 
		 */
		protected void doTask() {
			startProvision();
		}

		/*
		 * ProvisionN܂B
		 * 
		 */
		private void startProvision() {
			final Shell shell = new Shell();

			if (ProvisionStartStopStatus.getInstance().isRunProvision()) {
				MessageDialog.openWarning(shell, "Provision Timer.",
						"Already Start Provision Timer.");

				if (shell != null) {
					shell.dispose();
				}

				return;
			}

			ProvisionStartStopStatus.getInstance().setRunProvision(true);
			BusyIndicator.showWhile(PlatformUI.getWorkbench().getDisplay(),
					new Runnable() {
						public void run() {
							// ProvisionN
							startProvision(shell);
						}
					});

			if (shell != null) {
				shell.dispose();
			}
		}

		/*
		 * ProvisionN܂B
		 * 
		 * @param shell Shell
		 */
		private void startProvision(Shell shell) {

			LoggingProvision.getInstance().startLog();

			Map provisionMap = ProvisionInfoControl.getInstance()
					.getProvisionInfoHashMap();

			Iterator it = null;
			for (it = provisionMap.keySet().iterator(); it.hasNext();) {
				String key = (String) it.next();
				ProvisionInfo provisionInfo = (ProvisionInfo) provisionMap
						.get(key);

				if (provisionInfo == null) {
					continue;
				}
				provisionInfo
						.setCommandResult(ProvisionCommandTaskPreference.STATUS_WAIT);
				ProvisionInfoControl.getInstance().setProvisionInfo(
						provisionInfo.getProvisionID(), provisionInfo);
				ProvisionMessageQueue.getInstance().pushProvisionMessage(
						provisionInfo.getIpAddress());
				Date setStartDate = null;
				if (provisionInfo.getStartDate() != null) {
					setStartDate = provisionInfo.getStartDate();
				} else {
					setStartDate = Calendar.getInstance().getTime();
				}

				ProvisionCommandTaskScheduleControl.getInstance()
						.setTaskSchedule(provisionInfo, setStartDate);
			}
		}

	}

	/**
	 * Provision~ANVNXłB
	 * 
	 * @author Yoshimasa Matsumoto
	 * @version 1.0
	 */
	private final class ActionStopProvision extends AbstractEngineAction {
		/**
		 * Provision~ANṼACRImageDescriptorԂ܂B
		 * 
		 * @return Provision~ANṼACRImageDescriptor
		 */
		public ImageDescriptor getImageDescriptor() {
			return ImageDescriptor.createFromURL(bundle
					.getEntry("icons/engine_stop.gif"));
		}

		/**
		 * Provision~ANVTextԂ܂B
		 * 
		 * @return Provision~ANVText
		 */
		public String getText() {
			return "Provision stop";
		}

		/**
		 * Provision~ANVToolTipTextԂ܂B
		 * 
		 * @return Provision~ANVToolTipText
		 * 
		 */
		public String getToolTipText() {
			return "Provision stop";
		}

		/**
		 * Provision~܂B
		 * 
		 */
		protected void doTask() {
			ProvisionStartStopStatus.getInstance().setRunProvision(false);

			final Shell shell = new Shell();

			BusyIndicator.showWhile(PlatformUI.getWorkbench().getDisplay(),
					new Runnable() {
						public void run() {

							stopProvision();

						}
					});

			if (shell != null) {
				shell.dispose();
			}
		}

		private void stopProvision() {

			LoggingProvision.getInstance().stopLog();

			Map provisionMap = ProvisionInfoControl.getInstance()
					.getProvisionInfoHashMap();

			Map taskScheduleMap = ProvisionCommandTaskScheduleControl
					.getInstance().getTaskScheduleMap();

			Iterator it = null;
			for (it = provisionMap.keySet().iterator(); it.hasNext();) {
				String provisionIDKey = (String) it.next();
				ProvisionCommandTaskScheduleInfo taskScheduleInfo = (ProvisionCommandTaskScheduleInfo) taskScheduleMap
						.get(provisionIDKey);

				if (taskScheduleInfo == null) {
					continue;
				}

				ProvisionCommandTaskScheduleControl.getInstance()
						.cancelTaskSchedule(taskScheduleInfo);
				ProvisionMessageQueue.getInstance().pushProvisionMessage(
						provisionIDKey);
			}
		}

	}
}
