/*
 * Created on 2007/01/10
 *
 *
 * Copyright(c) 2007 Yoshimasa Matsumoto
 */
package netjfwatcher.provision.model.action;

import java.util.logging.Logger;

import netjfwatcher.common.view.NodeTreeGroup;
import netjfwatcher.provision.gui.editor.EditorInputProvision;
import netjfwatcher.provision.gui.editor.EditorProvisionScheduleView;
import netjfwatcher.provision.info.ProvisionInfo;
import netjfwatcher.provision.info.ProvisionInfoControl;
import netjfwatcher.socketclient.NetworkClientNodeTreeView;

import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

/**
 * Provisionm[hTree ViewTreeIXi[NXłB IꂽTreẽm[hViewOpen܂B
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class ListenerProvisionNodeListTree implements ISelectionChangedListener {
	/* MO */
	private static Logger logger = null;

	/* lbg[NoRŏ擾邩ۂtO */
	private boolean isSocket;

	/**
	 * m[hTree ViewTreeIXi[NXCX^X𐶐܂B
	 * 
	 * @param isSocket
	 *            lbg[NoRŏ擾邩ۂtO
	 */
	public ListenerProvisionNodeListTree(boolean isSocket) {
		logger = Logger.getLogger(this.getClass().getName());
		this.isSocket = isSocket;
	}

	/**
	 * e[uViewɃtB[hꗗőIGg͒lƂĐݒ肵A ̃Cxg_@ƂWebɃANZX܂B
	 * 
	 * @param event
	 *            SelectionChangedEvent
	 */
	public void selectionChanged(SelectionChangedEvent event) {
		// IGg擾
		StructuredSelection ss = (StructuredSelection) event.getSelection();

		// m[hGroup̏ꍇɂ̓uEUopenreturn
		logger.info("Tree node  select : " + ss.getFirstElement());

		if (ss.getFirstElement() instanceof NodeTreeGroup) {
			logger.info("NodeTreeGroup ");

			return;
		} else if (!(ss.getFirstElement() instanceof ProvisionNodeTree)) {
			logger.info("No NodeTree ");

			return;
		}

		final ProvisionNodeTree entry = (ProvisionNodeTree) ss
				.getFirstElement();
		IWorkbenchPage activePage = PlatformUI.getWorkbench()
				.getActiveWorkbenchWindow().getActivePage();

		ProvisionInfo provisionInfo = ProvisionInfoControl.getInstance()
				.getProvisionInfo(entry.getProvisionInfo().getProvisionID());
		String nodeName = "ID=" + provisionInfo.getProvisionID() + " "
				+ provisionInfo.getNodeName() + "("
				+ provisionInfo.getIpAddress() + ")";

		try {

			activePage.openEditor(new EditorInputProvision(nodeName
					+ EditorProvisionScheduleView.TITLE_SUFFIX, provisionInfo,
					false), EditorProvisionScheduleView.class.getName());
		} catch (PartInitException e) {
			logger.warning(e.getMessage());
			e.printStackTrace();
		}

		try {
			if (!isSocket) {
				activePage.openEditor(new EditorInputProvision(nodeName
						+ EditorProvisionScheduleView.TITLE_SUFFIX,
						provisionInfo, isSocket),
						EditorProvisionScheduleView.class.getName());
			} else {
				activePage.openEditor(new EditorInputProvision(nodeName
						+ EditorProvisionScheduleView.TITLE_SUFFIX
						+ NetworkClientNodeTreeView
								.getTitleSuffixEngineAddress(), provisionInfo,
						isSocket), EditorProvisionScheduleView.class.getName());
			}
		} catch (PartInitException e) {
			logger.warning(e.getMessage());
			e.printStackTrace();
		}
	}
}
