/*
 * Created on 2007/01/10
 *
 *
 * Copyright(c) 2007 Yoshimasa Matsumoto
 */
package netjfwatcher.provision.model.action;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.engine.resource.XMLOutputterFormat;
import netjfwatcher.provision.info.ProvisionInfo;
import netjfwatcher.provision.info.ProvisionInfoControl;

import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;
import org.osgi.framework.Bundle;

/**
 * \[Xt@C̉͋yэXVsNXłB \[Xt@C̉͂A\[XƂĕԂ\bhȂǂ܂B
 * 
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class ProvisionFileParse {
	/** \[XXML l^O */
	public static final String XML_FILE_VALUE = "value";

	/** \[XXML conf ^O */
	public static final String ROOT = "Root";

	public static final String PROVISION = "provision";

	public static final String PROVISION_ID = "ID";

	public static final String NODE_NAME = "NodeName";

	public static final String IP_ADDRESS = "IPAddress";

	public static final String USER_NAME = "UserName";

	public static final String PASSWORD = "Password";

	public static final String SU_PASSWORD = "Su_Password";

	public static final String GROUP = "Group";

	public static final String NODE_KIND = "NodeKind";

	public static final String START_DATE = "Start_Date";

	public static final String TELNET_COMMAND_FILE = "Telnet_command_file";

	public static final String FTP_SOURCE_FILE = "Ftp_source_file";

	public static final String FTP_STORE_FILE = "Ftp_store_file";

	/* ftHg̃m[hO[v */
	private static final String DEFAULT_NODE_GROUP = "Default Group";

	/* ftHg̃m[h */
	private static final String DEFAULT_NODE_KIND = "Hub";

	/* Logging */
	private static Logger logger = null;

	public ProvisionFileParse() {
		logger = Logger.getLogger(this.getClass().getName());
	}

	/**
	 * 
	 * wfBNgt@C͂ă\[Xێ܂B
	 * 
	 * @throws ProvisionImportParseAbortException
	 *             \[X͂Ɏsꍇ
	 */
	public void parseProvisionFile(String fileName)
			throws ProvisionImportParseAbortException {

		Document doc = null;

		// jart@C邩fBNgwt@C擾邩
		// doc = getDocument(RESOURCE_XML_FILE);
		doc = getResourceFileDocumentPath(fileName);

		if (doc == null) {
			logger.severe("Resource File Doc null ");

			return;
		}

		// rootvfo
		Element root = doc.getRootElement();

		List provisionIDList = root.getChildren(PROVISION);

		Iterator iterator = provisionIDList.iterator();

		while (iterator.hasNext()) {

			Element provisionListEl = (Element) iterator.next();
			String provisionID = provisionListEl
					.getAttributeValue(PROVISION_ID);

			ProvisionInfo provisionInfo = new ProvisionInfo();
			provisionInfo.setProvisionID(provisionID);
			if (provisionListEl.getChild(NODE_NAME) != null
					&& provisionListEl.getChild(NODE_NAME).getAttributeValue(
							XML_FILE_VALUE) != null) {
				provisionInfo.setNodeName(provisionListEl.getChild(NODE_NAME)
						.getAttributeValue(XML_FILE_VALUE));
			} else {
				provisionInfo.setNodeName("");
			}
			if (provisionListEl.getChild(IP_ADDRESS) != null
					&& provisionListEl.getChild(IP_ADDRESS).getAttributeValue(
							XML_FILE_VALUE) != null) {
				provisionInfo.setIpAddress(provisionListEl.getChild(IP_ADDRESS)
						.getAttributeValue(XML_FILE_VALUE));
			} else {
				throw new ProvisionImportParseAbortException(
						"Not Found IP Address.");
			}
			if (provisionListEl.getChild(USER_NAME) != null
					&& provisionListEl.getChild(USER_NAME).getAttributeValue(
							XML_FILE_VALUE) != null) {
				provisionInfo.setUserName(provisionListEl.getChild(USER_NAME)
						.getAttributeValue(XML_FILE_VALUE));
			} else {
				provisionInfo.setUserName("");
			}

			if (provisionListEl.getChild(PASSWORD) != null
					&& provisionListEl.getChild(PASSWORD).getAttributeValue(
							XML_FILE_VALUE) != null) {
				provisionInfo.setPassword(provisionListEl.getChild(PASSWORD)
						.getAttributeValue(XML_FILE_VALUE));
			} else {
				provisionInfo.setPassword("");
			}
			if (provisionListEl.getChild(SU_PASSWORD) != null
					&& provisionListEl.getChild(SU_PASSWORD).getAttributeValue(
							XML_FILE_VALUE) != null) {
				provisionInfo.setSuPpassword(provisionListEl.getChild(
						SU_PASSWORD).getAttributeValue(XML_FILE_VALUE));
			} else {
				provisionInfo.setSuPpassword("");
			}
			if (provisionListEl.getChild(GROUP) != null
					&& provisionListEl.getChild(GROUP).getAttributeValue(
							XML_FILE_VALUE) != null) {
				provisionInfo.setGroup(provisionListEl.getChild(GROUP)
						.getAttributeValue(XML_FILE_VALUE));
			} else {
				provisionInfo.setGroup(DEFAULT_NODE_GROUP);
			}
			if (provisionListEl.getChild(NODE_KIND) != null
					&& provisionListEl.getChild(NODE_KIND).getAttributeValue(
							XML_FILE_VALUE) != null) {
				provisionInfo.setNodeKind(provisionListEl.getChild(NODE_KIND)
						.getAttributeValue(XML_FILE_VALUE));
			} else {
				provisionInfo.setNodeKind(DEFAULT_NODE_KIND);
			}
			if (provisionListEl.getChild(START_DATE) != null
					&& !provisionListEl.getChild(START_DATE).getAttributeValue(
							XML_FILE_VALUE).equals("")) {
				long startDateTime = Long.parseLong(provisionListEl.getChild(
						START_DATE).getAttributeValue(XML_FILE_VALUE));
				Date startDate = Calendar.getInstance().getTime();
				startDate.setTime(startDateTime);
				provisionInfo.setStartDate(startDate);
			}
			if (provisionListEl.getChild(TELNET_COMMAND_FILE) != null
					&& provisionListEl.getChild(TELNET_COMMAND_FILE)
							.getAttributeValue(XML_FILE_VALUE) != null) {
				provisionInfo.setCommandFile(provisionListEl.getChild(
						TELNET_COMMAND_FILE).getAttributeValue(XML_FILE_VALUE));
			} else {
				provisionInfo.setCommandFile("");
			}
			if (provisionListEl.getChild(FTP_SOURCE_FILE) != null
					&& provisionListEl.getChild(FTP_SOURCE_FILE)
							.getAttributeValue(XML_FILE_VALUE) != null) {
				provisionInfo.setFtpSourceFile(provisionListEl.getChild(
						FTP_SOURCE_FILE).getAttributeValue(XML_FILE_VALUE));
			} else {
				provisionInfo.setFtpSourceFile("");
			}
			if (provisionListEl.getChild(FTP_STORE_FILE) != null
					&& provisionListEl.getChild(FTP_STORE_FILE)
							.getAttributeValue(XML_FILE_VALUE) != null) {
				provisionInfo.setFtpStoreFile(provisionListEl.getChild(
						FTP_STORE_FILE).getAttributeValue(XML_FILE_VALUE));
			} else {
				provisionInfo.setFtpStoreFile("");
			}
			ProvisionInfoControl.getInstance().setProvisionInfo(provisionID,
					provisionInfo);

		}

	}

	/**
	 * wfBNgXMLt@C͂DocumentԂ܂B ijart@ČȂj
	 * 
	 * @param file
	 *            XMLt@C
	 * @return doc Document
	 */
	public Document getResourceFileDocumentPath(String file) {
		Document doc = null;

		File f = new File(file);
		// logger.info("Path : " + f.getAbsolutePath());

		if (f == null) {
			logger.warning("Abort create File : " + f.getAbsolutePath());

			return null;
		}

		BufferedReader d = null;

		try {
			FileReader fi = new FileReader(file);
			d = new BufferedReader(fi);
		} catch (FileNotFoundException e1) {
			logger.warning("FileNotFoundException : " + f.getPath() + " : "
					+ e1.getMessage());
			logger.warning("FileNotFoundException : " + f.getAbsolutePath()
					+ " : " + e1.getMessage());
			e1.printStackTrace();

			return null;
		}

		try {
			// FileInputStream stream = new FileInputStream(f);
			SAXBuilder builder = new SAXBuilder();
			doc = builder.build(d);
		} catch (JDOMException e) {
			logger.warning("JDOMException : " + e.getMessage());
			e.printStackTrace();
		} catch (NullPointerException e) {
			logger.warning("NullPointerException : " + e.getMessage());
			e.printStackTrace();
		} catch (IOException e) {
			logger.warning("IOException : " + e.getMessage());
			e.printStackTrace();
		}

		return doc;
	}

	/**
	 * jart@CXMLt@CE͂DocumentԂ܂B
	 * 
	 * @param file
	 *            XMLt@C
	 * @return doc Document
	 */
	protected Document getDocument(String file) {
		Document doc = null;

		URL url = null;

		try {
			logger.severe("Parse start : " + file);

			/* 摜肷邽߂PluginResource bundle */
			Bundle bundle = NetJFWatcherPlugin.getInstance().getBundle();
			url = bundle.getEntry(file);

			// logger.info("getLocation : " + bundle.getLocation());
			// logger.info("getResourcen : " + bundle.getResource(file));

			if (url == null) {
				/* bZ[W\[Xt@CȂꍇMO̎ */
				logger.severe("Resource XML file url : " + url);

				return null;
			}

			SAXBuilder builder = new SAXBuilder();
			doc = builder.build(url.openStream());
		} catch (JDOMException e) {
			logger.severe("Alert/Confirm Dialog Window Message XML file url : "
					+ url);
			e.printStackTrace();
		} catch (NullPointerException e) {
			logger.severe("Alert/Confirm Dialog Window Message XML file url : "
					+ url);
			e.printStackTrace();
		} catch (IOException e) {
			logger.severe("Alert/Confirm Dialog Window Message XML file url : "
					+ url);
			e.printStackTrace();
		}

		return doc;
	}

	public void outputXMLFile(String fileName) {
		Document dom = createDocument();

		File f = new File(fileName);
		logger.info("Path : " + f.getAbsolutePath());

		if (f == null) {
			return;
		}

		BufferedWriter bufWriter = null;

		try {
			FileWriter fi = new FileWriter(fileName);
			bufWriter = new BufferedWriter(fi);
		} catch (IOException e1) {
			e1.printStackTrace();

			return;
		}

		/*
		 * qGgeGg2wAGgԂ̉s w͂ȂiXMLt@CŌXsĂ邽߁j
		 */
		XMLOutputter outputter = XMLOutputterFormat.getInstance()
				.getXMLOutputterFormat();

		try {
			outputter.output(dom, System.out);
			outputter.output(dom, bufWriter);
		} catch (IOException e1) {
			logger.warning(e1.getMessage());
			e1.printStackTrace();
		} finally {
			if (bufWriter != null) {
				try {
					bufWriter.close();
				} catch (IOException e2) {
					logger.warning(e2.getMessage());
					e2.printStackTrace();
				}
			}
		}
	}

	private Document createDocument() {

		Element confElement = new Element(ROOT);
		Document doc = new Document(confElement);
		Map provisionMap = ProvisionInfoControl.getInstance()
				.getProvisionInfoHashMap();

		Iterator it = null;
		for (it = provisionMap.keySet().iterator(); it.hasNext();) {
			String key = (String) it.next();
			ProvisionInfo provisionInfo = (ProvisionInfo) provisionMap.get(key);

			if (provisionInfo == null) {
				continue;
			}
			Element provisionEl = new Element(PROVISION);
			confElement.addContent(provisionEl);

			Element nodeNameEl = new Element(NODE_NAME);
			Element ipAddressEl = new Element(IP_ADDRESS);
			Element userNameEl = new Element(USER_NAME);
			Element passwordEl = new Element(PASSWORD);
			Element suPasswordEl = new Element(SU_PASSWORD);
			Element groupEl = new Element(GROUP);
			Element nodeKindEl = new Element(NODE_KIND);
			Element startDateEl = new Element(START_DATE);
			Element telnetCmdFileEl = new Element(TELNET_COMMAND_FILE);
			Element ftpSrcFileEl = new Element(FTP_SOURCE_FILE);
			Element ftpDstFileEl = new Element(FTP_STORE_FILE);

			provisionEl.addContent(nodeNameEl);
			provisionEl.addContent(ipAddressEl);
			provisionEl.addContent(userNameEl);
			provisionEl.addContent(passwordEl);
			provisionEl.addContent(suPasswordEl);
			provisionEl.addContent(groupEl);
			provisionEl.addContent(nodeKindEl);
			provisionEl.addContent(startDateEl);
			provisionEl.addContent(telnetCmdFileEl);
			provisionEl.addContent(ftpSrcFileEl);
			provisionEl.addContent(ftpDstFileEl);

			provisionEl.setAttribute(new Attribute(PROVISION_ID, provisionInfo
					.getProvisionID()));
			nodeNameEl.setAttribute(new Attribute(XML_FILE_VALUE, provisionInfo
					.getNodeName()));
			ipAddressEl.setAttribute(new Attribute(XML_FILE_VALUE,
					provisionInfo.getIpAddress()));
			userNameEl.setAttribute(new Attribute(XML_FILE_VALUE, provisionInfo
					.getUserName()));
			passwordEl.setAttribute(new Attribute(XML_FILE_VALUE, provisionInfo
					.getPassword()));
			suPasswordEl.setAttribute(new Attribute(XML_FILE_VALUE,
					provisionInfo.getSuPpassword()));
			groupEl.setAttribute(new Attribute(XML_FILE_VALUE, provisionInfo
					.getGroup()));
			nodeKindEl.setAttribute(new Attribute(XML_FILE_VALUE, provisionInfo
					.getNodeKind()));
			if (provisionInfo.getStartDate() != null
					&& !provisionInfo.getStartDate().equals("")) {
				startDateEl.setAttribute(new Attribute(XML_FILE_VALUE, Long
						.toString(provisionInfo.getStartDate().getTime())));
			} else {
				startDateEl.setAttribute(new Attribute(XML_FILE_VALUE, ""));
			}
			telnetCmdFileEl.setAttribute(new Attribute(XML_FILE_VALUE,
					provisionInfo.getCommandFile()));
			ftpSrcFileEl.setAttribute(new Attribute(XML_FILE_VALUE,
					provisionInfo.getFtpSourceFile()));
			ftpDstFileEl.setAttribute(new Attribute(XML_FILE_VALUE,
					provisionInfo.getFtpStoreFile()));
		}

		return doc;
	}
}
