/*
 * Created on 2007/01/10
 *
 *
 * Copyright(c) 2007 Yoshimasa Matsumoto
 */
package netjfwatcher.provision.nodemaneger.list;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public final class ProvisionMessageQueue {
	/* L[郊Xg */
	private static List provisionMessageQueueList;

	private static final int LIMIT = 100;

	private ProvisionMessageQueue() {
		provisionMessageQueueList = Collections
				.synchronizedList(new LinkedList());
	}

	public synchronized void pushProvisionMessage(final String provisionMessage) {

		if (provisionMessageQueueList.size() > LIMIT) {
			provisionMessageQueueList.remove(0);

		}
		provisionMessageQueueList.add(provisionMessage);
	}

	public synchronized String popPortScanInfo() {
		String provisionMessage = null;

		if (provisionMessageQueueList.size() > 0) {
			provisionMessage = (String) provisionMessageQueueList.get(0);
			provisionMessageQueueList.remove(0);
		}

		return provisionMessage;
	}

	/**
	 * ̃NX̃CX^XԂ܂B<BR>
	 * iNXێĂVOgEIuWFNg Ԃ܂j<BR>
	 * 
	 * @return VOgEIuWFNgƂĂ̂̃NX CX^X
	 */
	public static ProvisionMessageQueue getInstance() {
		return SingletonResource.MESSAGE_QUEUE;
	}

	/**
	 * VOgEIuWFNgێNXłB<BR>
	 * 
	 */
	private static class SingletonResource {
		static final ProvisionMessageQueue MESSAGE_QUEUE = new ProvisionMessageQueue();
	}
}
