/*
 * Created on 2007/01/10
 *
 *
 * Copyright(c) 2007 Yoshimasa Matsumoto
 */
package netjfwatcher.provision.nodemaneger.list;

import java.io.IOException;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;

import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.common.view.AbstractTableView;
import netjfwatcher.common.view.TableListViewColor;
import netjfwatcher.engine.model.action.ActionBuilderEditorsPartClose;
import netjfwatcher.engine.model.action.MediaResource;
import netjfwatcher.engine.resource.SystemResourceConfig;
import netjfwatcher.engine.view.editorpart.common.TableColumnControlTableListener;
import netjfwatcher.provision.command.schedule.ProvisionCommandTaskPreference;
import netjfwatcher.provision.info.ProvisionInfo;
import netjfwatcher.provision.info.ProvisionInfoControl;
import netjfwatcher.provision.model.action.ActionBuilderProvisionNodeList;
import netjfwatcher.provision.model.action.ActionBuilderProvisionNodeView;
import netjfwatcher.provision.model.action.ActionBuilderProvisionStartStop;
import netjfwatcher.provision.model.action.ActionBuilderProvisionNodeView.ActionProvisionFileView;
import netjfwatcher.provision.model.action.ActionBuilderProvisionNodeView.ActionProvisionScheduleView;
import netjfwatcher.snmpmanager.model.ActionBuilderTrapReceiveTable;

import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchActionConstants;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

/**
 * m[hXge[u\ViewNXłB
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class ProvisionNodeListTableView extends AbstractTableView {
	/** m[ho^\Text */
	protected static final int COUNT_TEXT_WIDTH = 100;

	/** e[u\\[gɂJ0\[g */
	protected static boolean isCol0Direction = false;

	/** e[u\\[gɂJ1\[g */
	protected static boolean isCol1Direction = true;

	/** e[u\\[gɂJ2\[g */
	protected static boolean isCol2Direction = true;

	/** e[u\\[gɂJ3\[g */
	protected static boolean isCol3Direction = true;

	/** e[u\\[gɂJ4\[g */
	protected static boolean isCol4Direction = true;

	/** e[u\\[gɂJ5\[g */
	protected static boolean isCol5Direction = true;

	/** e[u\\[gɂJ6\[g */
	protected static boolean isCol6Direction = true;

	/** e[u\\[gɂJ6\[g */
	protected static boolean isCol7Direction = true;

	/* MO */
	private static Logger logger = null;

	/** e[uJImage܂ރJ */
	protected static int[] imageColumn = { ProvisionNodeListTableViewLabelProvider.NODE_LIST_COLUMN_NODENAME };

	/** o^m[h\Text */
	protected static Text nodeCountText;

	/** XV{^ */
	protected static Button refreshButton;

	/* m[hXge[uJ */
	private static final float COLUMN0_NO = 0.05f;

	private static final float COLUMN1_ID = 0.05f;

	private static final float COLUMN2_NAME = 0.1f;

	private static final float COLUMN3_GROUP = 0.1f;

	private static final float COLUMN4_ADDRESS = 0.1f;

	private static final float COLUMN5_START_DATE = 0.1f;

	private static final float COLUMN6_COMMAND_FILE = 0.1f;

	private static final float COLUMN7_COMMAND_RESULT = 0.2f;

	/** Display */
	protected Display display;

	/** m[hListe[u */
	protected Table table;

	/** m[heLXg\BackGroundFi[ */
	protected Color textBackColor;

	/** TableViewer */
	protected TableViewer viewer;

	protected TableColumn col0;

	protected TableColumn col1;

	protected TableColumn col2;

	protected TableColumn col3;

	protected TableColumn col4;

	protected TableColumn col5;

	protected TableColumn col6;

	protected TableColumn col7;

	/**
	 * o^m[h̊Ďm[hIP AddressKeyƂ ێMapŁAIm[h̊Ď擾E\Ɏgp
	 */
	protected HashMap provisionInfoIDMap = new HashMap();

	/** 摜肷邽߂PluginResource bundle */
	protected final Bundle bundle = NetJFWatcherPlugin.getInstance()
			.getBundle();

	private ActionBuilderProvisionStartStop provisionStartStop = new ActionBuilderProvisionStartStop();

	/** m[hXgANV */
	protected ProvisionTableListAction provisionTableListAction = new ProvisionTableListAction();

	protected ActionBuilderProvisionNodeView actionProvisionNodeOperation = new ActionBuilderProvisionNodeView();

	/** EditorPartANV */
	protected ActionBuilderEditorsPartClose actionBuilderEditorPart = new ActionBuilderEditorsPartClose();

	/** Xe[^XC}l[W */
	protected SubStatusLineManager statusLineManager;

	/** m[hXge[uőIꂽIP Address */
	protected String selectID;



	private static Color WHITE_COLOR = new Color(null, 255, 255, 255);

	private static Color BLACK_COLOR = new Color(null, 0, 0, 0);

	private static Color RED_COLOR = new Color(null, 255, 0, 0);

	private static Color BLUE_COLOR = new Color(null, 0, 0, 255);

	private static Color GREEN_COLOR = new Color(null, 0, 128, 0);

	/* XPW[\tH[}bg */
	private DateFormat dateformat = new SimpleDateFormat(
			"yyyy-MM-dd (EEE) HH:mm:ss");

	/**
	 * m[hIcon ImageIcon image filekeyƂĕێ (Icon imageQdɐ邱Ɩh~ƂƂɁA
	 * finalize()ImagejꍇɎgp)
	 */
	protected HashMap nodeIconImageMap = new HashMap();

	/* Provisionf[^\^C}[ */
	private static final int PROVISION_TIMER = 1000;

	/* Provisione[uTimer */
	private ProvisionTableTimerProcessor timerProcessor;

	/**
	 * m[hXge[u\ViewNXCX^X ܂B
	 */
	public ProvisionNodeListTableView() {
		logger = Logger.getLogger(this.getClass().getName());

		/* TextwiFZbg */
		textBackColor = WHITE_COLOR;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.IWorkbenchPart#setFocus()
	 */
	public void setFocus() {
	}

	/**
	 * e[uViewi\`̌ځjԂ܂B
	 * 
	 * @return viewer TableViewer
	 */
	public TableViewer getViewer() {
		return viewer;
	}

	/**
	 * r[ꂽƂɂ܂sꃁ\bhłB
	 * 
	 * @param parent
	 *            Composite
	 */
	public void createPartControl(Composite parent) {
		display = parent.getDisplay();
		/* Table */
		createTable(parent);
		viewer = new TableViewer(table);
		viewer.setUseHashlookup(true);

		/* ContentProviderZbg */
		viewer
				.setContentProvider(new ProvisionNodeListTableViewContentProvider());

		/* xEtHgȂǂZbg */
		viewer.setLabelProvider(new ProvisionNodeListTableViewLabelProvider());


		/* ContextMenuZbg */
		createContextMenu();

		/* ToolBarZbg */
		setToolBarActions();

		/* m[hXg擾 */
		setProvisionTableListView(false);

		/* Xe[^XCZbg */
		setStatusLine();

		/*
		 * TableōsNbNꂽꍇ̃Xi[Zbg
		 */
		table
				.addSelectionListener(new TableColumnControlTableListener(
						table,
						ProvisionNodeListTableViewLabelProvider.NODE_LIST_COLUMN_START_DATE));
		table
				.addSelectionListener(new TableColumnControlTableListener(
						table,
						ProvisionNodeListTableViewLabelProvider.NODE_LIST_COLUMN_COMMAND_RESULT));
		table
				.addSelectionListener(new TableColumnControlTableListener(
						table,
						ProvisionNodeListTableViewLabelProvider.NODE_LIST_COLUMN_COMMAND_FILE));

		startTimer();
	}



	/**
	 * J0iNode No.j̕Ԃ܂B
	 * 
	 * @return J
	 */
	protected int computeCol0Width() {
		return (int) (getSite().getShell().getSize().x * COLUMN0_NO);
	}

	protected int computeCol1Width() {
		return (int) (getSite().getShell().getSize().x * COLUMN1_ID);
	}

	protected int computeCol2Width() {
		return (int) (getSite().getShell().getSize().x * COLUMN2_NAME);
	}

	protected int computeCol3Width() {
		return (int) (getSite().getShell().getSize().x * COLUMN3_GROUP);
	}

	protected int computeCol4Width() {
		return (int) (getSite().getShell().getSize().x * COLUMN4_ADDRESS);
	}

	protected int computeCol5Width() {
		return (int) (getSite().getShell().getSize().x * COLUMN5_START_DATE);
	}

	protected int computeCol6Width() {
		return (int) (getSite().getShell().getSize().x * COLUMN6_COMMAND_FILE);
	}

	protected int computeCol7Width() {
		return (int) (getSite().getShell().getSize().x * COLUMN7_COMMAND_RESULT);
	}

	/**
	 * e[u𐶐܂B e[ůeJwb_[̃^CgAJZbg܂B
	 * 
	 * @param parent
	 *            Composite
	 */
	protected void createTable(Composite parent) {
		/* Xe[^XC\L */
		statusLineManager = (SubStatusLineManager) (getViewSite()
				.getActionBars().getStatusLineManager());
		statusLineManager.setVisible(true);

		int snmpPort = SystemResourceConfig.getInstance()
				.getResourceFileParse().getResourceInfo().getSnmpPort();
		statusLineManager.setMessage("Snmp Port=" + snmpPort);

		GridLayout gridLayout = new GridLayout();
		gridLayout.numColumns = 1;
		parent.setLayout(gridLayout);

		Composite operationContainer = new Composite(parent, SWT.NONE);
		operationContainer.setLayout(new RowLayout(SWT.HORIZONTAL));

		GridData data = new GridData();
		data.horizontalAlignment = GridData.FILL;
		data.grabExcessHorizontalSpace = true;
		operationContainer.setLayoutData(data);

		Label nodeCountLabel = new Label(operationContainer, SWT.NONE);
		nodeCountLabel.setText("Node Count");

		nodeCountText = new Text(operationContainer, SWT.BORDER | SWT.RIGHT
				| SWT.READ_ONLY);
		nodeCountText.setLayoutData(new RowData(COUNT_TEXT_WIDTH, -1));
		nodeCountText.setEditable(false);
		nodeCountText.setEnabled(false);
		nodeCountText.setBackground(textBackColor);
		refreshButton = new Button(operationContainer, SWT.NONE);
		refreshButton.setText("Refresh");

		GridData data2 = new GridData();
		data2.horizontalAlignment = GridData.FILL;
		data2.verticalAlignment = GridData.FILL;

		data2.grabExcessHorizontalSpace = true;
		data2.grabExcessVerticalSpace = true;

		table = new Table(parent, SWT.MULTI | SWT.BORDER | SWT.H_SCROLL
				| SWT.V_SCROLL | SWT.FULL_SELECTION);
		table.setLinesVisible(true);
		table.setHeaderVisible(true);

		table.setLayoutData(data2);

		/* Node No. */
		col0 = new TableColumn(table, SWT.CENTER);
		col0
				.setText(ProvisionNodeListTableViewLabelProvider.NODE_LIST_TABLE_COLUMNS[ProvisionNodeListTableViewLabelProvider.NODE_LIST_COLUMN_NO]);
		col0.setWidth(computeCol0Width());

		/* ID */
		col1 = new TableColumn(table, SWT.CENTER);
		col1
				.setText(ProvisionNodeListTableViewLabelProvider.NODE_LIST_TABLE_COLUMNS[ProvisionNodeListTableViewLabelProvider.NODE_LIST_COLUMN_ID]);
		col1.setWidth(computeCol1Width());

		/* Node */
		col2 = new TableColumn(table, SWT.CENTER);
		col2
				.setText(ProvisionNodeListTableViewLabelProvider.NODE_LIST_TABLE_COLUMNS[ProvisionNodeListTableViewLabelProvider.NODE_LIST_COLUMN_NODENAME]);
		col2.setWidth(computeCol2Width());

		/* Group */
		col3 = new TableColumn(table, SWT.CENTER);
		col3
				.setText(ProvisionNodeListTableViewLabelProvider.NODE_LIST_TABLE_COLUMNS[ProvisionNodeListTableViewLabelProvider.NODE_LIST_COLUMN_GROUP]);
		col3.setWidth(computeCol3Width());

		/* IP Address */
		col4 = new TableColumn(table, SWT.CENTER);
		col4
				.setText(ProvisionNodeListTableViewLabelProvider.NODE_LIST_TABLE_COLUMNS[ProvisionNodeListTableViewLabelProvider.NODE_LIST_COLUMN_IPADDRESS]);
		col4.setWidth(computeCol4Width());

		/* Nodeo^ */
		col5 = new TableColumn(table, SWT.CENTER);
		col5
				.setText(ProvisionNodeListTableViewLabelProvider.NODE_LIST_TABLE_COLUMNS[ProvisionNodeListTableViewLabelProvider.NODE_LIST_COLUMN_START_DATE]);
		col5.setWidth(computeCol5Width());

		/* Node`FbN */
		col6 = new TableColumn(table, SWT.CENTER);
		col6
				.setText(ProvisionNodeListTableViewLabelProvider.NODE_LIST_TABLE_COLUMNS[ProvisionNodeListTableViewLabelProvider.NODE_LIST_COLUMN_COMMAND_FILE]);
		col6.setWidth(computeCol6Width());

		/* NodeXe[^X */
		col7 = new TableColumn(table, SWT.CENTER);
		col7
				.setText(ProvisionNodeListTableViewLabelProvider.NODE_LIST_TABLE_COLUMNS[ProvisionNodeListTableViewLabelProvider.NODE_LIST_COLUMN_COMMAND_RESULT]);
		col7.setWidth(computeCol7Width());

		/**
		 * e[uړꍇ͂TCYꍇ̃Xi[łB
		 * 
		 */
		PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell()
				.addControlListener(new ControlListener() {
					public void controlMoved(ControlEvent event) {
					}

					public void controlResized(ControlEvent event) {

						setResizedTableColumnWidth();
					}
				});

		col0.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event event) {
				/* J\[gA\[gێ */
				isCol0Direction = sortIntegerTable(table, 0, isCol0Direction,
						imageColumn);
			}
		});

		col1.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event event) {
				/* J\[gA\[gێ */
				isCol1Direction = sortIntegerTable(table, 1, isCol1Direction,
						imageColumn);
			}
		});
		col2.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event event) {
				/* J\[gA\[gێ */
				isCol2Direction = sortIntegerTable(table, 2, isCol2Direction,
						imageColumn);
			}
		});

		col3.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event event) {
				/* J\[gA\[gێ */
				isCol3Direction = sortTable(table, 3, isCol3Direction,
						imageColumn);
			}
		});

		col4.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event event) {
				/* J\[gA\[gێ */
				isCol4Direction = sortTable(table, 4, isCol4Direction,
						imageColumn);
			}
		});

		col5.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event event) {
				/* J\[gA\[gێ */
				isCol5Direction = sortTable(table, 5, isCol5Direction,
						imageColumn);
			}
		});
		col6.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event event) {
				/* J\[gA\[g6ێ */
				isCol6Direction = sortTable(table, 6, isCol6Direction,
						imageColumn);
			}
		});
		col7.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event event) {
				/* J\[gA\[g6ێ */
				isCol7Direction = sortTable(table, 7, isCol7Direction,
						imageColumn);
			}
		});
		/*
		 * XV{^Xi[
		 */
		refreshButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {
				refreshButton.setEnabled(false);
				setProvisionTableListView(true);
				refreshButton.setEnabled(true);
				setStatusLine();
			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});
	}

	/*
	 * X[p[NX̃e[uColumn Clickɂ\[g\bh
	 * I[o[ChāAe[uRowForegroundABackground J[yImage\[gɂĂێ܂B
	 * 
	 * @see rctf.rssr.common.view.AbstractTableView#setTableItem
	 *      (org.eclipse.swt.widgets.Table, org.eclipse.swt.widgets. TableItem,
	 *      java.lang.String[])
	 */
	protected TableItem setTableItem(final Table paraTable, TableItem item,
			final String[] strs) {

		Object obj0 = item.getForeground();
		Object obj1 = item.getBackground();
		Object obj = item
				.getForeground(ProvisionNodeListTableViewLabelProvider.NODE_LIST_COLUMN_COMMAND_RESULT);
		Image image1 = item
				.getImage(ProvisionNodeListTableViewLabelProvider.NODE_LIST_COLUMN_NODENAME);

		item.dispose();
		item = new TableItem(paraTable, SWT.NONE);

		item.setText(strs);
		item.setData(strs);

		item.setForeground((Color) obj0);
		item.setBackground((Color) obj1);
		item
				.setForeground(
						ProvisionNodeListTableViewLabelProvider.NODE_LIST_COLUMN_COMMAND_RESULT,
						(Color) obj);
		item
				.setImage(
						ProvisionNodeListTableViewLabelProvider.NODE_LIST_COLUMN_NODENAME,
						image1);

		return item;
	}

	/**
	 * ContextMenu𐶐܂B
	 * 
	 */
	private void createContextMenu() {
		/* j[}l[W𐶐 */
		MenuManager mm = new MenuManager();
		mm.setRemoveAllWhenShown(true);

		/* j[Xi[Zbg */
		mm.addMenuListener(new IMenuListener() {
			public void menuAboutToShow(IMenuManager manager) {
				fillContextMenu(manager);
			}
		});

		/*
		 * ReLXgj[𐶐Zbg
		 */
		Menu menu = mm.createContextMenu(viewer.getControl());
		viewer.getControl().setMenu(menu);
		getSite().registerContextMenu(mm, viewer);
	}

	/**
	 * j[o[ preWindowOpenɌĂ΂܂B
	 * 
	 * @param manager
	 *            IMenuManager
	 */
	protected void fillContextMenu(IMenuManager manager) {
		manager.add(new GroupMarker(IWorkbenchActionConstants.MB_ADDITIONS));

		/* Provisionm[hList\j[ǉ */
		manager.add(provisionTableListAction.getActionShowProvisionTable());

		/* Provisionm[hImportj[ǉ */
		manager.add(provisionTableListAction.getActionImportNodeListFile());

		/* Provisionm[hExportj[ǉ */
		manager.add(provisionTableListAction.getActionExportNodeListFile());


		/*
		 * m[hListe[uI񒊏o
		 */
		if ((table.getSelectionIndex() >= 0) && (table.getSelection() != null)) {
			TableItem[] item = table.getSelection();

			String[] provisionIDInfo = (String[]) item[0].getData();
			selectID = provisionIDInfo[ProvisionNodeListTableViewLabelProvider.NODE_LIST_COLUMN_ID];

			ProvisionInfo targetNodeInfo = (ProvisionInfo) provisionInfoIDMap
					.get(selectID);

			((ActionProvisionScheduleView) actionProvisionNodeOperation
					.getActionProvisionScheduleView())
					.setNodeInfo(targetNodeInfo);
			manager.add(actionProvisionNodeOperation
					.getActionProvisionScheduleView());
			((ActionProvisionFileView) actionProvisionNodeOperation
					.getActionProvisionFileView())
					.setProvisionInfo(targetNodeInfo);
			manager.add(actionProvisionNodeOperation
					.getActionProvisionFileView());

		}

	}

	/**
	 * ToolBarANV̏s܂B
	 * 
	 */
	private void setToolBarActions() {
		IToolBarManager toolBarManager = getViewSite().getActionBars()
				.getToolBarManager();
		toolBarManager.add(provisionTableListAction
				.getActionShowProvisionTable());
		toolBarManager.add(provisionStartStop.getActionStartProvision());
		toolBarManager.add(provisionStartStop.getActionStopProvision());

		toolBarManager.add(provisionTableListAction
				.getActionImportNodeListFile());
		toolBarManager.add(provisionTableListAction
				.getActionExportNodeListFile());
		toolBarManager.add(provisionTableListAction
				.getActionRemoveProvisionNodeListTable());
		/* Editor part closeANV */
		toolBarManager.add(actionBuilderEditorPart.actionCloseAllEditors());
	}

	/**
	 * Provisione[u\̍XVs܂B
	 * 
	 * @param isProvisionList
	 *            Provision擾邩ۂtO
	 */
	public void setProvisionTableListView(boolean isProvisionList) {
		/* e[ȗSč폜ătbV */
		table.removeAll();
		viewer.refresh();

		provisionInfoIDMap.clear();

		ArrayList provisionInfoList = null;

		if (isProvisionList) {
			provisionInfoList = getProvisionList();
		}

		if (provisionInfoList != null) {
			nodeCountText.setText(Integer.toString(provisionInfoList.size()));
		} else {
			nodeCountText.setText("0");

			return;
		}

		/* m[hĎ񃊃Xge[uZbg */
		for (int i = 0; i < provisionInfoList.size(); i++) {
			ProvisionInfo provisionInfo = (ProvisionInfo) provisionInfoList
					.get(i);
			provisionInfoIDMap.put(provisionInfo.getProvisionID(),
					provisionInfo);

			String[] tableCellArray = new String[ProvisionNodeListTableViewLabelProvider.NODE_LIST_TABLE_COLUMNS.length];

			tableCellArray[ProvisionNodeListTableViewLabelProvider.NODE_LIST_COLUMN_NO] = Integer
					.toString(i + 1);
			tableCellArray[ProvisionNodeListTableViewLabelProvider.NODE_LIST_COLUMN_ID] = provisionInfo
					.getProvisionID();
			tableCellArray[ProvisionNodeListTableViewLabelProvider.NODE_LIST_COLUMN_NODENAME] = provisionInfo
					.getNodeName();
			tableCellArray[ProvisionNodeListTableViewLabelProvider.NODE_LIST_COLUMN_GROUP] = provisionInfo
					.getGroup();
			tableCellArray[ProvisionNodeListTableViewLabelProvider.NODE_LIST_COLUMN_IPADDRESS] = provisionInfo
					.getIpAddress();
			if (provisionInfo.getStartDate() != null) {
				tableCellArray[ProvisionNodeListTableViewLabelProvider.NODE_LIST_COLUMN_START_DATE] = dateformat
						.format(provisionInfo.getStartDate());
			} else {
				tableCellArray[ProvisionNodeListTableViewLabelProvider.NODE_LIST_COLUMN_START_DATE] = "";
			}
			StringBuffer fileState = new StringBuffer(""); 
			boolean isSetTelnetFile = false;
			if (provisionInfo.getCommandFile() != null && !provisionInfo.getCommandFile().equals("")) {
				fileState.append("telnet=" + provisionInfo
						.getCommandFile());
				isSetTelnetFile = true;
			}
			if (provisionInfo.getFtpSourceFile() != null && !provisionInfo.getFtpSourceFile().equals("")) {
				if(isSetTelnetFile) {
					fileState.append("/");
				}
				fileState.append("ftp source=" + provisionInfo
						.getFtpSourceFile());
			}
			tableCellArray[ProvisionNodeListTableViewLabelProvider.NODE_LIST_COLUMN_COMMAND_FILE] = fileState.toString();
			if ((provisionInfo.getCommandResult() != null)
					&& !provisionInfo.getCommandResult().equals("")) {
				tableCellArray[ProvisionNodeListTableViewLabelProvider.NODE_LIST_COLUMN_COMMAND_RESULT] = provisionInfo
						.getCommandResult();
			} else {
				tableCellArray[ProvisionNodeListTableViewLabelProvider.NODE_LIST_COLUMN_COMMAND_RESULT] = "";
			}

			TableItem item = new TableItem(table, SWT.NONE);
			item.setText(tableCellArray);
			item.setData(tableCellArray);

			/* m[hIcon Imagem[hɕt */
			Image nodeIconImage = createNodeIconImage(provisionInfo
					.getNodeKind());
			item
					.setImage(
							ProvisionNodeListTableViewLabelProvider.NODE_LIST_COLUMN_NODENAME,
							nodeIconImage);

			/*
			 * m[hXgColor݂ɃZbg
			 */
			if ((i % 2) == 0) {
				item.setBackground(TableListViewColor.getInstance()
						.getNodeListOddBackgroundColor());
				item.setForeground(TableListViewColor.getInstance()
						.getNodeListOddForgroundColor());
			} else {
				item.setBackground(TableListViewColor.getInstance()
						.getNodeListEvenBackgroundColor());
				item.setForeground(TableListViewColor.getInstance()
						.getNodeListEvenForgroundColor());
			}

			if (provisionInfo.getCommandResult() != null) {

				if (provisionInfo.getCommandResult().indexOf(
						ProvisionCommandTaskPreference.STATUS_ABORT) >= 0) {
					item
							.setForeground(
									ProvisionNodeListTableViewLabelProvider.NODE_LIST_COLUMN_COMMAND_RESULT,
									RED_COLOR);
				} else if (provisionInfo.getCommandResult().indexOf(
						ProvisionCommandTaskPreference.STATUS_LOGIN_FAIL) >= 0) {
					item
							.setForeground(
									ProvisionNodeListTableViewLabelProvider.NODE_LIST_COLUMN_COMMAND_RESULT,
									RED_COLOR);
				} else if (provisionInfo.getCommandResult().equals(
						ProvisionCommandTaskPreference.STATUS_CAMCEL)) {
					item
							.setForeground(
									ProvisionNodeListTableViewLabelProvider.NODE_LIST_COLUMN_COMMAND_RESULT,
									GREEN_COLOR);
				} else if (provisionInfo.getCommandResult().equals(
						ProvisionCommandTaskPreference.STATUS_COMPLETE)) {
					item
							.setForeground(
									ProvisionNodeListTableViewLabelProvider.NODE_LIST_COLUMN_COMMAND_RESULT,
									BLACK_COLOR);
				} else if (provisionInfo.getCommandResult().equals(
						ProvisionCommandTaskPreference.STATUS_WAIT)) {
					item
							.setForeground(
									ProvisionNodeListTableViewLabelProvider.NODE_LIST_COLUMN_COMMAND_RESULT,
									BLUE_COLOR);
				}
			} else {

				item
						.setForeground(
								ProvisionNodeListTableViewLabelProvider.NODE_LIST_COLUMN_COMMAND_RESULT,
								BLACK_COLOR);
			}
		}
	}

	/*
	 * m[hʂm[hIcon image擾ĕԂ܂B
	 * 
	 * @param nodeKind m[h @return nodeIconImage m[hIcon image
	 */
	protected Image createNodeIconImage(String nodeKind) {
		/*
		 * m[hʂɑΉm[hIconC[Wt@C LqXMLt@CList𐶐Am[hIcon C[Wt@C擾
		 */
		String node16IconFileName = MediaResource.getInstance()
				.getNodeIcon16FileName(nodeKind);
		Image nodeIconImage = null;

		if (!nodeIconImageMap.containsKey(node16IconFileName)) {
			URL url = null;
			url = bundle.getEntry(node16IconFileName);

			if (url == null) {
				/* Icon\[Xt@CȂꍇMO̎ */
				logger.severe("Npt found icon file : " + node16IconFileName);
			} else {
				try {
					/* m[hIconC[W */
					nodeIconImage = new Image(display, url.openStream());

					/* m[hIconC[WMapɊi[ */
					nodeIconImageMap.put(node16IconFileName, nodeIconImage);
				} catch (IOException e) {
					logger.warning("Abort create image " + e.getMessage()
							+ " for " + node16IconFileName);
					e.printStackTrace();
				}
			}
		} else {
			nodeIconImage = (Image) nodeIconImageMap.get(node16IconFileName);
		}

		return nodeIconImage;
	}

	/**
	 * Provision listǂݍŕԂ܂B
	 * 
	 * @return provisionList Provision list
	 */
	public ArrayList getProvisionList() {

		ArrayList provisionList = new ArrayList();
		Iterator it = null;
		Map provisionMap = ProvisionInfoControl.getInstance()
				.getProvisionInfoHashMap();
		for (it = provisionMap.keySet().iterator(); it.hasNext();) {
			String key = (String) it.next();
			ProvisionInfo provisionInfo = (ProvisionInfo) provisionMap.get(key);

			if (provisionInfo == null) {
				continue;
			}
			provisionList.add(provisionInfo);
		}
		return provisionList;
	}

	/**
	 * Xe[^XC\Zbg܂B
	 * 
	 */
	protected void setStatusLine() {
		/* Xe[^XC\L */
		statusLineManager = (SubStatusLineManager) (getViewSite()
				.getActionBars().getStatusLineManager());
		statusLineManager.setVisible(true);
		statusLineManager.setMessage("Node List View Node count="
				+ provisionInfoIDMap.size());
	}

	protected void setResizedTableColumnWidth() {
		/*
		 * e[u\Ԃł΃e[uJZbg
		 */
		if (getSite().getPage().isPartVisible(getSite().getPart())
				&& getSite().getShell() != null) {
			if (getSite().getShell().getSize() != null) {
				// col0.setWidth(computeCol0Width());
			}
		}
	}

	/**
	 * m[hListe[ũANV܂B
	 * 
	 * @author Yoshimasa Matsumoto
	 * @version 1.0
	 */
	protected final class ProvisionTableListAction extends
			ActionBuilderProvisionNodeList {
		/**
		 * X[p[NX̃\bhI[o[ChāAm[hList e[u̕\XVLq܂B
		 */
		protected void refreshProvisionTable() {
			/* m[hListe[u\XV */
			setProvisionTableListView(true);
		}
	}

	/*
	 * Provisionf[^\^C}[̐Ass܂B
	 * 
	 */
	private void startTimer() {
		/* Provisionf[^\^C}[̐As */
		ProvisionTableTimerProcessor.getInstance().setDisplay(display);
		ProvisionTableTimerProcessor.getInstance().setTable(this);
		timerProcessor = ProvisionTableTimerProcessor.getInstance();
		display.timerExec(PROVISION_TIMER, timerProcessor);
	}

	/*
	 * ( Javadoc)
	 * 
	 * @see java.lang.Object#finalize()
	 */
	protected void finalize() throws Throwable {
		super.finalize();


		/* m[hIcon imagej */
		Map list = nodeIconImageMap;
		Iterator it = null;

		for (it = list.keySet().iterator(); it.hasNext();) {
			String key = (String) it.next();
			Image nodeIconImage = (Image) list.get(key);

			if (nodeIconImage != null) {
				nodeIconImage.dispose();
			}
		}

		if (table != null) {
			table.dispose();
		}
		/* Provisionf[^\^C}[~ */
		display.timerExec(ActionBuilderTrapReceiveTable.TIMER_STOP,
				timerProcessor);
	}
}
