/*
 * Created on 2007/01/10
 *
 *
 * Copyright(c) 2007 Yoshimasa Matsumoto
 */
package netjfwatcher.provision.nodemaneger.list;

import java.util.logging.Logger;

import netjfwatcher.common.view.AbstractNodeTreeView;
import netjfwatcher.common.view.NodeTreeGroup;
import netjfwatcher.provision.info.ProvisionInfo;
import netjfwatcher.provision.info.ProvisionInfoControl;
import netjfwatcher.provision.model.action.ActionBuilderProvisionNodeView;
import netjfwatcher.provision.model.action.ActionBuilderProvisionNodeTree;
import netjfwatcher.provision.model.action.ListenerProvisionNodeListTree;
import netjfwatcher.provision.model.action.ProvisionNodeTree;
import netjfwatcher.provision.model.action.ActionBuilderProvisionNodeView.ActionProvisionFileView;
import netjfwatcher.provision.model.action.ActionBuilderProvisionNodeView.ActionProvisionScheduleView;

import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchActionConstants;

/**
 * Provisionm[hTree\ViewNXłB
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class ProvisionNodeTreeView extends AbstractNodeTreeView {
	/* MO */
	private static Logger logger = null;

	/** Node TreeANV */
	protected ActionBuilderProvisionNodeTree actionProvisionNodeTree;

	protected ActionBuilderProvisionNodeView actionProvisionNodeOperation = new ActionBuilderProvisionNodeView();

	/**
	 * m[hTree\ViewNXCX^X𐶐܂B
	 * 
	 */
	public ProvisionNodeTreeView() {
		logger = Logger.getLogger(this.getClass().getName());

	}

	/**
	 * f[^x[Xm[hĎ񃊃XgǂݍTree\ ܂B
	 * 
	 */
	protected void initShow() {

	}

	/**
	 * ReLXgj[𐶐܂B
	 * 
	 */
	public void createContextMenu() {
		/* m[hTreeANVZbg */
		actionProvisionNodeTree = new ActionBuilderProvisionNodeTree(this,
				nodeListTreeViewer, parentComposite, nodeTreeGroupRoot);

		/* j[}l[W */
		MenuManager mm = new MenuManager();
		mm.setRemoveAllWhenShown(true);

		/* j[Xi[Zbg */
		mm.addMenuListener(new IMenuListener() {
			public void menuAboutToShow(IMenuManager manager) {
				fillContextMenu(manager);
			}
		});

		Menu menu = mm.createContextMenu(nodeListTreeViewer.getControl());
		nodeListTreeViewer.getControl().setMenu(menu);
		getSite().registerContextMenu(mm, nodeListTreeViewer);
	}

	/**
	 * ANV̏ƂToolBarݒ肵܂B
	 * 
	 */
	protected void setToolBarActions() {
		/* ToolBarݒ */
		IToolBarManager toolBarManager = getViewSite().getActionBars()
				.getToolBarManager();

		/* m[hTreeēǍANV */
		toolBarManager.add(actionProvisionNodeTree
				.actionReloadProvisionNodeTree());
		toolBarManager
				.add(actionProvisionNodeTree.actionSortProvisionNodeTree());

		toolBarManager.add(actionProvisionNodeOperation
				.getActionProvisionScheduleView());

		toolBarManager.add(actionBuilderEditorPart.actionCloseAllEditors());
	}

	/**
	 * j[o[ݒ肵܂B preWindowOpenɌĂ΂܂B m[hTreẽm[hIĂꍇƑIĂȂꍇ
	 * j[ς܂B
	 * 
	 * @param manager
	 *            IMenuManager
	 */
	protected void fillContextMenu(IMenuManager manager) {
		/* m[hTreeǂݍ݃ANVZbg */
		manager.add(new GroupMarker(IWorkbenchActionConstants.MB_ADDITIONS));

		/* m[hTreeēǂݍ */
		manager.add(actionProvisionNodeTree.actionReloadProvisionNodeTree());

		/* m[hTree\[g */
		manager.add(actionProvisionNodeTree.actionSortProvisionNodeTree());

		/*
		 * Treẽm[hIĂ邩`FbN
		 */
		if (nodeListTreeViewer.getTree().getSelection() != null) {
			TreeItem[] treeItem = nodeListTreeViewer.getTree().getSelection();

			if ((treeItem != null) && (treeItem.length > 0)) {
				for (int nodeTreeSelectNo = 0; nodeTreeSelectNo < treeItem.length; nodeTreeSelectNo++) {
					if (treeItem[nodeTreeSelectNo].getData() instanceof NodeTreeGroup) {
						/* GroupI */
						nodeListTreeViewer.getTree().deselectAll();
					} else if (treeItem[nodeTreeSelectNo].getData() instanceof ProvisionNodeTree) {

						ProvisionInfo targetProvisionNodeInfo = ProvisionInfoControl
								.getInstance()
								.getProvisionInfo(
										((ProvisionNodeTree) treeItem[nodeTreeSelectNo]
												.getData()).getProvisionInfo()
												.getProvisionID());

						((ActionProvisionScheduleView) actionProvisionNodeOperation
								.getActionProvisionScheduleView())
								.setNodeInfo(targetProvisionNodeInfo);
						manager.add(actionProvisionNodeOperation
								.getActionProvisionScheduleView());
						((ActionProvisionFileView) actionProvisionNodeOperation
								.getActionProvisionFileView())
								.setProvisionInfo(targetProvisionNodeInfo);
						manager.add(actionProvisionNodeOperation
								.getActionProvisionFileView());

					} else {
						/* Groupłm[hłȂ */
						nodeListTreeViewer.getTree().deselectAll();
					}
				}
			} else {
				/* TreeI */
				manager
						.add(actionBuilderNodeOperation
								.getActionNodeOperation());
			}
		}

	}

	/**
	 * m[hTree View̑IXi[ݒ肵܂B
	 * 
	 */
	protected void setupNodeTreeViewListener() {
		/*
		 * Node Tree ViewɃXi[o^ Xi[̏ƂẮA e[uViewɃtB[hꗗőIGg͒lƂĐݒ
		 * 
		 */
		nodeListTreeViewer
				.addSelectionChangedListener(new ListenerProvisionNodeListTree(
						false));
	}
}
