/*
 * Created on 2007/01/10
 *
 *
 * Copyright(c) 2007 Yoshimasa Matsumoto
 */
package netjfwatcher.provision.perspective;

import netjfwatcher.provision.nodemaneger.list.ProvisionNodeListTableView;
import netjfwatcher.provision.nodemaneger.list.ProvisionNodeTreeView;
import netjfwatcher.provisionlog.gui.treeview.ProvisionLogNodeTreeView;

import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;

/**
 * Provision Manager PerspectiveNXłB
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class ProvisionManagerPerspective implements IPerspectiveFactory {
	public static final String ID = "netjfwatcher.provision.perspective.ProvisionManagerPerspective";

	private static final float NODE_TREE_RATIO = 0.20f;

	private static final float NODE_LIST_RATIO = 0.40f;

	/**
	 * PerspectivȅCAEgs܂B
	 * 
	 * @param layout
	 *            IPageLayout
	 */
	public void createInitialLayout(IPageLayout layout) {
		layout.setEditorAreaVisible(false);

		String editorArea = layout.getEditorArea();

		/* PerspectiveɃm[hTree */
		IFolderLayout left = layout.createFolder("left", IPageLayout.LEFT,
				NODE_TREE_RATIO, editorArea);
		left.addView(ProvisionNodeTreeView.class.getName());
		left.addView(ProvisionLogNodeTreeView.class.getName());
		IFolderLayout top = layout.createFolder("top", IPageLayout.TOP,
				NODE_LIST_RATIO, editorArea);
		top.addView(ProvisionNodeListTableView.class.getName());

	}
}
