/*
 * Created on 2006/12/02
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 */
package netjfwatcher.provisionlog.gui.action;

import netjfwatcher.application.NetJFWatcherPlugin;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

/**
 * SĂEditors PartcloseANVNXłB
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class ActionBuilderEditorsPartClose extends Action {
	/* 摜肷邽߂PluginResource bundle */
	private final Bundle bundle = NetJFWatcherPlugin.getInstance().getBundle();

	/* Editor partcloseANV */
	private IAction closeAllEditors = new ActionCloseAllEditors();

	/**
	 * Editor partcloseANVԂ܂B
	 * 
	 * @return closeAllEditors Editor partcloseANV
	 */
	public IAction actionCloseAllEditors() {
		return closeAllEditors;
	}

	/**
	 * ANV`钊ۃNXłB
	 * 
	 * @author Yoshimasa Matsumoto
	 * @version 1.0
	 */
	protected abstract class AbstractNodeAction extends Action {

		public final void run() {
			doTask();
		}

		protected abstract void doTask();
	}

	/**
	 * SĂEditor partcloseANVNXłB
	 * 
	 * 
	 * @author Yoshimasa Matsumoto
	 * @version 1.0
	 */
	protected final class ActionCloseAllEditors extends AbstractNodeAction {
		/**
		 * ImageDescriptorԂ܂B
		 * 
		 * @return ImageDescriptor
		 */
		public ImageDescriptor getImageDescriptor() {
			return ImageDescriptor.createFromURL(bundle
					.getEntry("icons/remove_exc.gif"));
		}

		/**
		 * TextԂ܂B
		 * 
		 * @return Text
		 */
		public String getText() {
			return "Close All Editors";
		}

		/**
		 * ToolTipTextԂ܂B
		 * 
		 * @return ToolTipText
		 */
		public String getToolTipText() {
			return "Close All Editors";
		}

		/**
		 * SĂEditorClose^XNłB
		 * 
		 */
		protected void doTask() {
			IWorkbenchPage activePage = PlatformUI.getWorkbench()
					.getActiveWorkbenchWindow().getActivePage();

			activePage.closeAllEditors(false);
			activePage.setEditorAreaVisible(false);
		}
	}
}
